; Altirra Acid800 test suite
; Copyright (C) 2010 Avery Lee, All Rights Reserved.
;
; Permission is hereby granted, free of charge, to any person obtaining a copy
; of this software and associated documentation files (the "Software"), to deal
; in the Software without restriction, including without limitation the rights
; to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
; copies of the Software, and to permit persons to whom the Software is
; furnished to do so, subject to the following conditions:
;
; The above copyright notice and this permission notice shall be included in
; all copies or substantial portions of the Software.
;
; THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
; IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
; FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
; AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
; LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
; OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
; SOFTWARE. 

		.ifndef SYS5200
		;in Acid5200, we are invoked from cartridge.s instead.
		opt		h+o+
		GENLIBRARY = 1
		.endif

		MOD_OPTIONS = 0
		MOD_DISPMIN = 1

;==========================================================================
; options (also resets org. to $1800 for A8)
;
		icl		'options.s'

;==========================================================================
; main library
;
		.ifdef SYS5200
		TEST_FIRST = 1
		.else
		TEST_FIRST = 5
		icl		'library.s'
		.endif

;==========================================================================
; 16K boot support (A8 only)
		.ifdef SYS800
		org		$2000
.proc _main
		;initialize library
		jsr		_crt0init

		;check if we have 16K of memory
		lda		memtop+1
		cmp		#$40
		scc:jmp	main
		
		;OS-B has a dumb bug where its screen editor clears up to one page
		;more than it should, so we install our own mini display module
		;that doesn't have such bugs.
		ldx		#MOD_DISPMIN
		jsr		_loadSeg
		jsr		_runSeg

		jmp		main
.endp
		.endif

;==========================================================================
		.ifndef SYS5200
		org		$1000
		.endif

.proc main
restart:
		lda		#0
		sta		passed
		sta		failed
		sta		skipped
		lda		#TEST_FIRST
		sta		testidx

		;print banner
		jsr		printBanner
		
		;do countdown
		mva		#0 ch
		.ifndef SYS5200
		mva		#0 ch1
		.endif
		lda		#5
waitloop:
		pha
		sta		d1
		jsr		_imprintf
		dta		c"Press key for options... %d",0

		;wait for a key for one second
		lda		#50
		ldx		pal
		cpx		#$0f
		sne:lda	#60
		clc
		.ifdef SYS5200
		adc		rtclok+1
		.else
		adc		rtclok+2
		.endif
waitloop2:
		ldx		ch
		beq		nokey
		
		mva		#0 ch
		
		jsr		_imprint
		dta		$9c,c"Loading option module...",$9b,0
		
		ldx		#MOD_OPTIONS
		jsr		_loadSeg
		
		jsr		_imprint
		dta		$9c,0
		
		jsr		_runSeg
		jmp		starttests
		
nokey:
		.ifdef SYS5200
		cmp		rtclok+1
		.else
		cmp		rtclok+2
		.endif
		bne		waitloop2

		jsr		_imprint
		dta		$9c,0
	
		;next second
		pla
		sec
		sbc		#1
		bne		waitloop
		
starttests:
		.ifndef SYS5200
		;check if a button is down
		lda		consol
		and		#7
		cmp		#7
		beq		buttonsup
		
		jsr		_imprint
		dta		c"Waiting for console buttons to release.",$9b,$9b,0

waitbtns:
		lda		consol
		and		#7
		cmp		#7
		bne		waitbtns
		
buttonsup:
		.endif

testloop:
		ldx		testidx
		inc		testidx
		mwa		#testnext _exitTest
		jsr		runtest
		mva		passed d1
		mva		failed d2
		mva		skipped d3
		jsr		_imprintf
		dta		c"All tests complete.",$9B
		dta		c"Passed: %d  Failed: %d  Skipped: %d",$9B,0
		
		jsr		_waitKeyPrompt
		jmp		restart

testnext:
		bpl		notfail
		
		;test was failed
		lda		opt_wait
		ora		opt_waitfail
		spl:jsr	_waitKeyPrompt

		inc		failed
		jmp		testloop
notfail:
		beq		waspass
		
		;test was skipped
		lda		opt_wait
		spl:jsr	_waitKeyPrompt
		
		inc		skipped
		jmp		testloop
		
waspass:
		;test was passed
		lda		opt_wait
		spl:jsr	_waitKeyPrompt
		
		inc		passed
		jmp		testloop
.endp

.proc	printBanner
		jsr		_imprint
		dta		$7d
		.ifdef SYS5200
		dta		c"Altirra Acid5200 test, V1.1",$9B
		.else
		dta		c"Altirra Acid800 test, V1.1",$9B
		.endif
		dta		c"Copyright (C) 2010-2013 Avery Lee.",$9B
		dta		c"All Rights Reserved.",$9B,$9B,0

		.ifdef SYS5200
		mwa		#$3FFF d1
		.else
		mwa		memtop d1
		.endif
		
		lda		_cpuMode
		asl
		lda		_cpuMode
		rol

		tax
		mva		cpu_lo_tab,x d3
		mva		cpu_hi_tab,x d3+1
		
		jsr		_imprintf
		dta		c"HIMEM: $%X  CPU: %s",$9B,0
		
		;checksum the ROM and report it
.ifdef SYS5200
		mwa		#$f0 a0+1
.else
		mwa		#$d8 a0+1
.endif
		ldy		#0
		sty		a0
		sty		d1
		sty		d2
		clc
chk_loop:
		lda		d1
		adc		(a0),y
		sta		d1
		iny
		lda		d2
		adc		(a0),y
		sta		d2
		iny
		bne		chk_loop
		inc		a0+1
		bne		chk_loop
		
		jsr		_imprintf
		dta		c"OS rom checksum: $%X",$9B,$9B,0
		
		rts
		
cpu_lo_tab:
		dta		<(str6502)
		dta		<(str65C816_16)
		dta		<(str65C02)
		dta		<(str65C816_24)

cpu_hi_tab:
		dta		>(str6502)
		dta		>(str65C816_16)
		dta		>(str65C02)
		dta		>(str65C816_24)

str6502:
		dta		c"6502",0
str65C02:
		dta		c"65C02",0
str65C816_16:
		dta		c"65C816[16]",0
str65C816_24:
		dta		c"65C816[24]",0
.endp

;==========================================================================
; Run a test.

; X = test index
.proc	runtest
		;check if this test exists
		lda		segaddrlo+1,x
		ora		segaddrhi+1,x
		bne		testOK
		rts	
testOK:
		txa
		pha
		sub		#TEST_FIRST-1
		sta		d1
		lda		a0
		pha
		lda		a0+1
		pha
		jsr		_imprintf
		dta		c"Loading test %d",0
		pla
		sta		a0+1
		pla
		sta		a0
				
		;store return stack ptr
		tsx
		inx
		inx
		sta		_exitTestS
		
		;load segment
		pla
		tax
		jsr		_loadSeg
		
		;clear loading message
		jsr		_imprint
		dta		$9c,0
		
		;run segment
		jmp		_runSeg
.endp

		.ifndef SYS5200
		run		_main
		.endif
