; Altirra Acid800 test suite
; Copyright (C) 2010 Avery Lee, All Rights Reserved.
;
; Permission is hereby granted, free of charge, to any person obtaining a copy
; of this software and associated documentation files (the "Software"), to deal
; in the Software without restriction, including without limitation the rights
; to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
; copies of the Software, and to permit persons to whom the Software is
; furnished to do so, subject to the following conditions:
;
; The above copyright notice and this permission notice shall be included in
; all copies or substantial portions of the Software.
;
; THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
; IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
; FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
; AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
; LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
; OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
; SOFTWARE. 

		_SAP_HEADER "POKEY: Init timing"

		opt		h+o+

		icl		'library.s'

;==========================================================================
retoff	equ		$80
result1	equ		$81
result2	equ		$82

;==========================================================================
		org		$2000

.nowarn .proc main
		ldy		#>testname
		lda		#<testname
		jsr		_testInit

		;initialize runway
		ldx		#0
		lda		#$ea
runway_init:
		sta		runway,x
		inx
		bne		runway_init
		lda		#$24			;bit zp
		sta		runway
		lda		#$60			;rts
		sta		runway+$ff
		
		;turn interrupts off and revector irq
		jsr		_screenOff
		jsr		_interruptsOff
		mva		#0 irqen
		mwa		#irqhandler vimirq
		
		;reset serial port to force output complete
		mva		#0 skctl
		pha:pla
		
		;revector IRQ and enable interrupts
		cli
		
		;set timer 1 for 15KHz operation
		mva		#$01 audctl
		mva		#$00 audf1
		mva		#0 audc1 
		jsr		runtests

		;check values
		;
		;Note that Ataris vary slightly in their POKEY IRQ latency, so we have to
		;accept two sets of timing values here.
		_ASSERT1_DUAL result1, $1F, $20, c"Incorrect 15KHz cycle count (even): $%x",0
		_ASSERT1 result2, $1F, c"Incorrect 15KHz cycle count (odd): $%x",0
		
		;set timer 1 for 64KHz operation
		mva		#$00 audctl
		mva		#$02 audf1
		mva		#0 audc1 
		jsr		runtests

		;check values
		_ASSERT1 result1, $1E, c"Incorrect 64KHz cycle count (even): $%x",0
		_ASSERT1_DUAL result2, $1E, $1D, c"Incorrect 64KHz cycle count (odd): $%x",0
		
		jmp		_testPassed
.endp
	
;==========================================================================
.proc	runtests		
		;run even test
		lda		#0
		sta		skctl
		sta		retoff
		lda		#$01
		ldy		#3
		sta		wsync
		sta		wsync
		sty		skctl
		sta		stimer
		sta		irqen
		cli
		jsr		runway+1
		sei
		mva		retoff result1
		mva		#0 irqen
		
		;run odd test
		lda		#$01
		ldx		#0
		stx		skctl
		ldy		#3
		sta		wsync
		sta		wsync
		sty		skctl
		sta		stimer
		sta		irqen
		cli
		jsr		runway
		sei
		mva		retoff result2
		mva		#0 irqen
		rts
.endp

;==========================================================================
.proc	irqhandler
		pha
		txa
		pha
		
		tsx
		lda		$0104,x
		sta		retoff
		mva		#0 irqen
		
		pla
		tax
		pla
		rti
.endp
		
testname:
		dta		c"POKEY: Init timing",0
		
runway	equ		$2400

		run		$2000
		end
