; Altirra Acid800 test suite
; Copyright (C) 2010 Avery Lee, All Rights Reserved.
;
; Permission is hereby granted, free of charge, to any person obtaining a copy
; of this software and associated documentation files (the "Software"), to deal
; in the Software without restriction, including without limitation the rights
; to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
; copies of the Software, and to permit persons to whom the Software is
; furnished to do so, subject to the following conditions:
;
; The above copyright notice and this permission notice shall be included in
; all copies or substantial portions of the Software.
;
; THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
; IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
; FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
; AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
; LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
; OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
; SOFTWARE. 

		_SAP_HEADER "POKEY: Noise generators"

		opt		h+o+

		icl		'library.s'

		org		$2000

main:
		ldy		#>testname
		lda		#<testname
		jsr		_testInit
		jsr		_screenOff
		jsr		_interruptsOff

		;kick POKEY into init mode
		mva		#0 skctl
		sta		wsync
		sta		wsync
		
		;check RANDOM in init mode
		lda		random
		cmp		#$ff
		beq		test1_ok
		
		jsr		_testFailed
		dta		c"RANDOM was not $ff in init mode.",0
		
test1_ok:
		;set noise generator to short mode and read a byte
		mvx		#$00 nmien
		sei
		
		mva		#$80 audctl
		lda		#$03
		inc		wsync
		sta		skctl			;105, 106, 107
		inc		wsync
		lda		random			;105, 106, 107, 108
		
		mvx		#$40 nmien
		cli
		
		cmp		#$95
		beq		test2_ok
		
		sta		d1
		jsr		_testFailed
		dta		c"Incorrect 9-bit PRNG value: $%x",0
		
test2_ok:
		mva		#0 skctl
		sta		wsync
		sta		wsync

		mvx		#$00 nmien
		sei
		
		mva		#$00 audctl
		lda		#$03
		inc		wsync
		sta		skctl			;105, 106, 107
		inc		wsync
		lda		random			;108, 109, 110, 111
		
		mvx		#$40 nmien
		cli

		cmp		#$08
		beq		test3_ok
		
		sta		d1
		jsr		_testFailed
		dta		c"Incorrect 17-bit PRNG value: $%x", 0
		
test3_ok:
		jmp		_testPassed

		;set noise generator to long mode and read a byte
		
testname:
		dta		c"POKEY: Noise generators",0

		run		$2000
		end
