; Altirra Acid800 test suite
; Copyright (C) 2010 Avery Lee, All Rights Reserved.
;
; Permission is hereby granted, free of charge, to any person obtaining a copy
; of this software and associated documentation files (the "Software"), to deal
; in the Software without restriction, including without limitation the rights
; to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
; copies of the Software, and to permit persons to whom the Software is
; furnished to do so, subject to the following conditions:
;
; The above copyright notice and this permission notice shall be included in
; all copies or substantial portions of the Software.
;
; THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
; IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
; FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
; AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
; LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
; OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
; SOFTWARE. 

		_SAP_HEADER "POKEY: Init timing"

		opt		h+o+

		icl		'library.s'

.macro _DELAY_CYCLES_X
	;validate parameters
	.if :0 != 1
	.error "Cycle count required." c' '
	.endif
		
	.if :1 < 2
	.error "Cycle count must be at least 2." c' '
	.endif
	
	.if :1 > 1000
	.error "Cycle count is too large." c' '
	.endif
	
	.def ?cycles = :1
	
	;check for page break
	.if ?cycles > 14 && ((*+5)&$ff)<3
		jmp *+3
		
		.def ?cycles = ?cycles - 3
	.endif
	
	.if ?cycles > 14
		;5N+1 cycles
	
		.def ?loops = (?cycles - 1) / 5
		.if ?loops*5+2 == ?cycles
			.def ?loops = ?loops - 1
		.endif
		
		ldx		#<?loops
		.pages 1
		dex:rne
		.endpg
		
		.def ?cycles = ?cycles - (5 * ?loops + 1)
	.endif
	
	.if ?cycles > 8
		pha
		pla
		.def ?cycles = ?cycles - 7
	.endif
	
	.if ?cycles == 8
		bit		$0100
		bit		$0100
	.elseif ?cycles == 7
		pha
		pla
	.elseif ?cycles == 6
		bit		$0100
		nop
	.elseif ?cycles == 5
		bit		$00
		nop
	.elseif ?cycles == 4
		bit		$0100
	.elseif ?cycles == 3
		bit		$00
	.elseif ?cycles == 2
		nop
	.elseif ?cycles != 0
		.error "Internal error" c' '
	.endif
.endm

;==========================================================================
		org		$2000

.nowarn .proc main
		_INITTEST c"POKEY: Timer timing"

		;turn interrupts off
		jsr		_screenOff
		jsr		_interruptsOff
		
		;set timer 1 for 1.79MHz
		mva		#$40 audctl
		mva		#$10 audf1
		mva		#$00 audf2
		
		;------------------------------------------------------------------
		;check for early 1.79MHz 8-bit timer
		sta		wsync
		sta		wsync
		_DELAY_CYCLES_X 60
		sta		stimer
		mva		#0 irqen
		mva		#$01 irqen
		_DELAY_CYCLES_X 19-12
		
		lda		irqst
		and		#$01
		_ASSERTA $01, c"1.79MHz 8-bit timer triggered too early (loop #1)."
		
		;------------------------------------------------------------------
		;check for late 1.79MHz 8-bit timer
		sta		wsync
		sta		wsync
		_DELAY_CYCLES_X 60
		sta		stimer
		mva		#0 irqen
		mva		#$01 irqen
		_DELAY_CYCLES_X 20-12
		lda		irqst
		and		#$01
		_ASSERTA $00, c"1.79MHz 8-bit timer triggered too late (loop #1)."

		;------------------------------------------------------------------
		;check for early 1.79MHz 8-bit timer (loop 2)
		sta		wsync
		sta		wsync
		_DELAY_CYCLES_X 60
		sta		stimer
		mva		#0 irqen
		_DELAY_CYCLES_X 12
		mva		#$01 irqen
		_DELAY_CYCLES_X 39-24
		
		lda		irqst
		and		#$01
		_ASSERTA $01, c"1.79MHz 8-bit timer triggered too early (loop #2)."
		
		;------------------------------------------------------------------
		;check for late 1.79MHz 8-bit timer (loop 2)
		sta		wsync
		sta		wsync
		_DELAY_CYCLES_X 60
		sta		stimer
		mva		#0 irqen
		_DELAY_CYCLES_X 12
		mva		#$01 irqen
		_DELAY_CYCLES_X 40-24
		lda		irqst
		and		#$01
		_ASSERTA $00, c"1.79MHz 8-bit timer triggered too late (loop #2)."
		
		;====== 16-bit timer tests ========================================
		
		;switch to linked timers
		mva		#$50 audctl
		
		;------------------------------------------------------------------
		;check for early 1.79MHz 16-bit lo timer
		sta		wsync
		sta		wsync
		_DELAY_CYCLES_X 60
		sta		stimer
		mva		#0 irqen
		mva		#$01 irqen
		_DELAY_CYCLES_X 19-12
		
		lda		irqst
		and		#$01
		_ASSERTA $01, c"1.79MHz 16-bit lo timer triggered too early (loop #1)."
		
		;------------------------------------------------------------------
		;check for late 1.79MHz 16-bit lo timer
		sta		wsync
		sta		wsync
		_DELAY_CYCLES_X 60
		sta		stimer
		mva		#0 irqen
		mva		#$01 irqen
		_DELAY_CYCLES_X 20-12
		lda		irqst
		and		#$01
		_ASSERTA $00, c"1.79MHz 16-bit lo timer triggered too late (loop #1)."

		;------------------------------------------------------------------
		;check for early 1.79MHz 16-bit lo timer (loop 2)
		sta		wsync
		sta		wsync
		_DELAY_CYCLES_X 60
		sta		stimer
		mva		#0 irqen
		_DELAY_CYCLES_X 15
		mva		#$01 irqen
		_DELAY_CYCLES_X 42-27
		
		lda		irqst
		and		#$01
		_ASSERTA $01, c"1.79MHz 16-bit lo timer triggered too early (loop #2)."
		
		;------------------------------------------------------------------
		;check for late 1.79MHz 16-bit lo timer (loop 2)
		sta		wsync
		sta		wsync
		_DELAY_CYCLES_X 60
		sta		stimer
		mva		#0 irqen
		_DELAY_CYCLES_X 15
		mva		#$01 irqen
		_DELAY_CYCLES_X 43-27
		lda		irqst
		and		#$01
		_ASSERTA $00, c"1.79MHz 16-bit lo timer triggered too late (loop #2)."

		;------------------------------------------------------------------
		;check for early 1.79MHz 16-bit hi timer
		sta		wsync
		sta		wsync
		_DELAY_CYCLES_X 60
		sta		stimer
		mva		#0 irqen
		mva		#$02 irqen
		_DELAY_CYCLES_X 22-12
		
		lda		irqst
		and		#$02
		_ASSERTA $02, c"1.79MHz 16-bit hi timer triggered too early (loop #1)."
		
		;------------------------------------------------------------------
		;check for late 1.79MHz 16-bit hi timer
		sta		wsync
		sta		wsync
		_DELAY_CYCLES_X 60
		sta		stimer
		mva		#0 irqen
		mva		#$02 irqen
		_DELAY_CYCLES_X 23-12
		lda		irqst
		and		#$02
		_ASSERTA $00, c"1.79MHz 16-bit hi timer triggered too late (loop #1)."

		;------------------------------------------------------------------
		;check for early 1.79MHz 16-bit hi timer (loop 2)
		sta		wsync
		sta		wsync
		_DELAY_CYCLES_X 60
		sta		stimer
		mva		#0 irqen
		_DELAY_CYCLES_X 21
		mva		#$02 irqen
		_DELAY_CYCLES_X 45-33
		
		lda		irqst
		and		#$02
		_ASSERTA $02, c"1.79MHz 16-bit hi timer triggered too early (loop #2)."
		
		;------------------------------------------------------------------
		;check for late 1.79MHz 16-bit hi timer (loop 2)
		sta		wsync
		sta		wsync
		_DELAY_CYCLES_X 60
		sta		stimer
		mva		#0 irqen
		_DELAY_CYCLES_X 21
		mva		#$02 irqen
		_DELAY_CYCLES_X 46-33
		lda		irqst
		and		#$02
		_ASSERTA $00, c"1.79MHz 16-bit hi timer triggered too late (loop #2)."
		
		jmp		_testPassed
.endp
	
		run		$2000
		end
