; Altirra Acid800 test suite
; Copyright (C) 2010 Avery Lee, All Rights Reserved.
;
; Permission is hereby granted, free of charge, to any person obtaining a copy
; of this software and associated documentation files (the "Software"), to deal
; in the Software without restriction, including without limitation the rights
; to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
; copies of the Software, and to permit persons to whom the Software is
; furnished to do so, subject to the following conditions:
;
; The above copyright notice and this permission notice shall be included in
; all copies or substantial portions of the Software.
;
; THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
; IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
; FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
; AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
; LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
; OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
; SOFTWARE. 

.proc _crt0init_5200
	lda		#$02
	sta		sskctl
	sta		skctl
	
	mva		#$04 consol
	mva		#$00 keydel
	
	php
	sei
	
	lda		pokmsk
	ora		#$c0
	sta		pokmsk
	sta		irqen

	mwa		#_kybd_handler vkybdf
	mwa		#_vbd_handler vvblkd
	
	plp
	rts
.endp

;==========================================================================
.proc _kybd_handler
	;The bass-ackward design of the 5200 keyboard causes an IRQ to occur
	;every 32 scanlines while a key is held down. We require keys to be
	;released for at least one full frame before we recognize another
	;one.
	ldx		keydel
	sne:sta	ch
	lda		#2
	sta		keydel
	pla
	tay
	pla
	tax
	pla
	rti
.endp

;==========================================================================
.proc _vbd_handler
	lda		keydel
	seq:dec	keydel
	
	plr
	rti
.endp

