; Altirra Acid800 test suite
; Copyright (C) 2010-2011 Avery Lee, All Rights Reserved.
;
; Permission is hereby granted, free of charge, to any person obtaining a copy
; of this software and associated documentation files (the "Software"), to deal
; in the Software without restriction, including without limitation the rights
; to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
; copies of the Software, and to permit persons to whom the Software is
; furnished to do so, subject to the following conditions:
;
; The above copyright notice and this permission notice shall be included in
; all copies or substantial portions of the Software.
;
; THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
; IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
; FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
; AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
; LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
; OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
; SOFTWARE. 

	opt	h-o+
	org	0

.macro _PADSECTOR
	:(($80-*)&$7f) dta 0
.endm

	dta	$96, $02
	dta	a([diskend - imagestart]/$10)
	dta	$80
	:11 dta 0
	
	org	$0080
imagestart:
	ins	'loader.obx'

;==========================================================================

.macro _MODULEADDRHI
	dta >(mod_:1/$80)
.endm	

.macro _MODULEADDRLO
	dta <(mod_:1/$80)
.endm	

.def ?module_count = 0

.macro _MODULELABEL1
	.def mod_:1 = *
.endm

.macro _MODULELABEL
	;workaround for annoying MADS bug where MACRO and REPT parameters don't nest properly
	.rept :1+1
	.if # == :1
		_MODULELABEL1 #
	.endif
	.endr
.endm

.macro _MODULE
	_MODULELABEL ?module_count

	ins	:1
	_PADSECTOR

	.def :?module_count = :?module_count + 1
.endm

;==========================================================================

	_PADSECTOR
imageend:
	:63 _MODULEADDRLO #
check_1:
	_PADSECTOR

check_2:
	:63 _MODULEADDRHI #
check_3:
	_PADSECTOR
	
	_MODULE 'mod_options.obx'
	_MODULE 'mod_dispmin.obx'
	_MODULE 'mod_disp80.obx'
	_MODULE 'mod_vbxe80.obx'
	_MODULE 'mod_scroll40.obx'
	_MODULE 'cpu_insn.obx'
	_MODULE 'cpu_flags.obx'
	_MODULE 'cpu_decimal.obx'
	_MODULE 'cpu_timing.obx'
	_MODULE 'cpu_bugs.obx'
	_MODULE 'cpu_clisei.obx'
	_MODULE 'cpu_illegal.obx'
	_MODULE 'cpu_65c816.obx'
	_MODULE 'antic_default.obx'
	_MODULE 'antic_nmist.obx'
	_MODULE 'antic_hiresbug.obx'
	_MODULE 'antic_vcount.obx'
	_MODULE 'antic_wsync.obx'
	_MODULE 'antic_addresswrap.obx'
	_MODULE 'antic_dlistwrap.obx'
	_MODULE 'antic_dlitiming.obx'
	_MODULE 'antic_addrmirror.obx'
	_MODULE 'antic_pmdma.obx'
	_MODULE 'antic_charcontrol.obx'
	_MODULE 'antic_dmapattern.obx'
	_MODULE 'antic_blockednmi.obx'
	_MODULE 'antic_hscrolbug.obx'
	_MODULE 'antic_virtdma.obx'
	_MODULE 'antic_vscroll.obx'
	_MODULE 'antic_vscroldli.obx'
	_MODULE 'antic_pfstarttiming.obx'
	_MODULE 'antic_pfstoptiming.obx'
	_MODULE 'antic_linebuffering.obx'
	_MODULE 'pokey_default.obx'
	_MODULE 'pokey_noise.obx'
	_MODULE 'pokey_irqtiming.obx'
	_MODULE 'pokey_timerirq.obx'
	_MODULE 'pokey_timertiming.obx'
	_MODULE 'pokey_timergranularity.obx'
	_MODULE 'pokey_twotone.obx'
	_MODULE 'pokey_seroc.obx'
	_MODULE 'pokey_serclock.obx'
	_MODULE 'pokey_serdirect.obx'
	_MODULE 'pokey_sertiming.obx'
	_MODULE 'pokey_skstat.obx'
	_MODULE 'pokey_asyncrecv.obx'
	_MODULE 'pokey_addrmirror.obx'
	_MODULE 'pokey_inittiming.obx'
	_MODULE 'pia_basic.obx'
	_MODULE 'pia_irq.obx'
	_MODULE 'gtia_default.obx'
	_MODULE 'gtia_phantomdma.obx'
	_MODULE 'gtia_consol.obx'
	_MODULE 'gtia_vdelay.obx'
	_MODULE 'gtia_collision.obx'
	_MODULE 'gtia_collision2.obx'
	_MODULE 'gtia_pmretrigger.obx'
	_MODULE 'gtia_pmresize.obx'
	_MODULE 'gtia_pmoverlap.obx'
	_MODULE 'gtia_psuedomodee.obx'
	_MODULE 'gtia_addrmirror.obx'
	_MODULE 'mmu_xlbanking.obx'
	_MODULELABEL ?module_count

	.if ?module_count<>(check_1-imageend-1)
	.error "Module low byte table length is incorrect"
	.endif

	.if ?module_count<>(check_3-check_2-1)
	.error "Module high byte table length is incorrect"
	.endif
	
	_PADSECTOR
diskend
