; Altirra Acid800 test suite
; Copyright (C) 2010 Avery Lee, All Rights Reserved.
;
; Permission is hereby granted, free of charge, to any person obtaining a copy
; of this software and associated documentation files (the "Software"), to deal
; in the Software without restriction, including without limitation the rights
; to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
; copies of the Software, and to permit persons to whom the Software is
; furnished to do so, subject to the following conditions:
;
; The above copyright notice and this permission notice shall be included in
; all copies or substantial portions of the Software.
;
; THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
; IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
; FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
; AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
; LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
; OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
; SOFTWARE. 

;==========================================================================
; MEMORY MAP (800)
;
;	$0000-007F		OS zero page
;	$0080-00BF		Module zero page
;	$00C0-00DF		Library zero page
;	$00E0-00EF		80-column zero page
;	$0100-01FF		6502 stack
;	$0200-03FF		OS database
;	$0400-0AFF		Boot loader / unused
;	$0B00-0BFF		Boot loader / sector load buffer
;	$0C00-0FFF		Boot loader / 16K display
;	$1000-18FF		Resident test driver (full suite only)
;	$1900-19FF		Segment tables (full suite only)
;	$1A00-1FFF		Library code
;	$2000-3FFF		Module run area
;	$4000-5FFF		Segment load area / Extended memory window
;	$6000-7FFF		80-column screen A / Extended memory window
;	$9000-9BFF		80-column driver
;	$9C00-9FFF		Unused (display list if cart)
;	$A000-BFFF		80-column screen B
;
; MEMORY MAP (5200)
;
;	$0000-001F		OS zero page
;	$0020-003F		Display zero page
;	$0080-00BF		Module zero page
;	$00C0-00DF		Library zero page
;	$0100-01FF		6502 stack
;	$0200-021F		OS database
;	$0220-027F		Unused
;	$0280-02FF		Library database
;	$0300-07FF		Display memory
;	$0800-0FFF		Unused
;	$1000-1FFF		LZ decompression history window
;	$2000-3FFF		Module run area
;	$4000-BFFF		Cartridge library code and module store
;
; MEMORY MAP (SAP)
;
;	$0080-00BF		Module zero page
;	$00C0-00DF		Library zero page
;	$0280-02FF		Library database
;	$0300-07FF		Display memory
;	$2000-3FFF		Module run area
;	$4000-BFFF		Module store

;==========================================================================
; CONFIGURATION
;
		.ifndef SYS800
		SEGS_IN_ROM = 1
		.else
		SEGS_MIN_MEM = 1
		.endif
		
		.ifdef SYS5200
		SEGS_LZPACK = 1
		.endif

;==========================================================================
; HARDWARE INCLUDES
;
.ifdef SYS5200
;GTIA
gtia = $c000
m0pf	equ	$c000
m1pf	equ	$c001
m2pf	equ	$c002
m3pf	equ	$c003
p0pf	equ	$c004
p1pf	equ	$c005
p2pf	equ	$c006
p3pf	equ	$c007
m0pl	equ	$c008
m1pl	equ	$c009
m2pl	equ	$c00a
m3pl	equ	$c00b
p0pl	equ	$c00c
p1pl	equ	$c00d
p2pl	equ	$c00e
p3pl	equ	$c00f
hposp0	equ	$c000
hposp1	equ	$c001
hposp2	equ	$c002
hposp3	equ	$c003
hposm0	equ	$c004
hposm1	equ	$c005
hposm2	equ	$c006
hposm3	equ	$c007
sizep0	equ	$c008
sizep1	equ	$c009
sizep2	equ	$c00a
sizep3	equ	$c00b
sizem	equ	$c00c
grafp0	equ	$c00d
grafp1	equ	$c00e
grafp2	equ	$c00f
grafp3	equ	$c010
trig0	equ	$c010
grafm	equ	$c011
colpm0	equ	$c012
colpm1	equ	$c013
colpm2	equ	$c014
pal		equ	$c014
colpm3	equ	$c015
colpf0	equ	$c016
colpf1	equ	$c017
colpf2	equ	$c018
colpf3	equ	$c019
colbk	equ	$c01a
prior	equ	$c01b
vdelay	equ	$c01c
gractl	equ	$c01d
hitclr	equ	$c01e
consol	equ	$c01f

;POKEY
pokey = $e800
audf1	equ	$e800
audc1	equ	$e801
audf2	equ	$e802
audc2	equ	$e803
audf3	equ	$e804
audc3	equ	$e805
audf4	equ	$e806
audc4	equ	$e807
audctl	equ	$e808
stimer	equ	$e809
random	equ	$e80a
skres	equ	$e80a
serin	equ	$e80d
serout	equ	$e80d
irqen	equ	$e80e
irqst	equ	$e80e
skctl	equ	$e80f
skstat	equ	$e80f
.else
;GTIA
gtia = $d000
m0pf	equ	$d000
m1pf	equ	$d001
m2pf	equ	$d002
m3pf	equ	$d003
p0pf	equ	$d004
p1pf	equ	$d005
p2pf	equ	$d006
p3pf	equ	$d007
m0pl	equ	$d008
m1pl	equ	$d009
m2pl	equ	$d00a
m3pl	equ	$d00b
p0pl	equ	$d00c
p1pl	equ	$d00d
p2pl	equ	$d00e
p3pl	equ	$d00f
hposp0	equ	$d000
hposp1	equ	$d001
hposp2	equ	$d002
hposp3	equ	$d003
hposm0	equ	$d004
hposm1	equ	$d005
hposm2	equ	$d006
hposm3	equ	$d007
sizep0	equ	$d008
sizep1	equ	$d009
sizep2	equ	$d00a
sizep3	equ	$d00b
sizem	equ	$d00c
grafp0	equ	$d00d
grafp1	equ	$d00e
grafp2	equ	$d00f
grafp3	equ	$d010
trig0	equ	$d010
grafm	equ	$d011
colpm0	equ	$d012
colpm1	equ	$d013
colpm2	equ	$d014
pal		equ	$d014
colpm3	equ	$d015
colpf0	equ	$d016
colpf1	equ	$d017
colpf2	equ	$d018
colpf3	equ	$d019
colbk	equ	$d01a
prior	equ	$d01b
vdelay	equ	$d01c
gractl	equ	$d01d
hitclr	equ	$d01e
consol	equ	$d01f

;POKEY
pokey = $d200
audf1	equ	$d200
audc1	equ	$d201
audf2	equ	$d202
audc2	equ	$d203
audf3	equ	$d204
audc3	equ	$d205
audf4	equ	$d206
audc4	equ	$d207
audctl	equ	$d208
stimer	equ	$d209
kbcode	equ	$d209
random	equ	$d20a
skres	equ	$d20a
serin	equ	$d20d
serout	equ	$d20d
irqen	equ	$d20e
irqst	equ	$d20e
skctl	equ	$d20f
skstat	equ	$d20f

;PIA
porta	equ	$d300
portb	equ	$d301
pactl	equ	$d302
pbctl	equ	$d303
.endif

;ANTIC
dmactl	equ	$d400
chactl	equ	$d401
dlistl	equ	$d402
dlisth	equ	$d403
hscrol	equ	$d404
vscrol	equ	$d405
pmbase	equ	$d407
chbase	equ	$d409
wsync	equ	$d40a
vcount	equ	$d40b
nmien	equ	$d40e
nmires	equ	$d40f
nmist	equ	$d40f

;==========================================================================
; OS INCLUDES (5200)
;
.ifdef SYS5200
pokmsk	equ		$00
rtclok	equ		$01
;		equ		$02
critic	equ		$03
atract	equ		$04
sdlstl	equ		$05
sdlsth	equ		$06
sdmctl	equ		$07
pcolr0	equ		$08
pcolr1	equ		$09
pcolr2	equ		$0a
pcolr3	equ		$0b
color0	equ		$0c
color1	equ		$0d
color2	equ		$0e
color3	equ		$0f
color4	equ		$10

vimirq	equ		$0200		;IRQ immediate vector
vvblki	equ		$0202		;VBI immediate vector
vvblkd	equ		$0204		;VBI deferred vector
vdslst	equ		$0206		;display list vector
vkybdi	equ		$0208		;keyboard immediate vector
vkybdf	equ		$020a		;keyboard deferred vector
.endif

;==========================================================================
; OS INCLUDES (800)
;
.ifndef SYS5200
pokmsk	equ	$10
rtclok	equ	$12
savmsc	equ	$58
ramtop	equ	$6a

vdslst	equ	$0200
vkeybd	equ	$0208
vimirq	equ	$0216
cdtmv1	equ	$0218
vvblki	equ	$0222
vvblkd	equ	$0224
cdtma1	equ	$0226
sdmctl	equ	$022f
sdlstl	equ	$0230
sdlsth	equ	$0231
sskctl	equ	$0232
runad	equ	$02e0
initad	equ	$02e2
memtop	equ	$02e5
ch1		equ	$02f2
ch		equ	$02fc

ddevic	equ	$0300
dunit	equ	$0301
dcomnd	equ	$0302
dstats	equ	$0303
dbuflo	equ	$0304
dbufhi	equ	$0305
dtimlo	equ	$0306
dbytlo	equ	$0308
dbythi	equ	$0309
daux1	equ	$030a
daux2	equ	$030b

iccmd	equ	$0342
icbal	equ	$0344
icbah	equ	$0345
icptl	equ	$0346
icpth	equ	$0347
icbll	equ	$0348
icblh	equ	$0349
icax1	equ	$034a

basicf	equ	$03f8

dskinv	equ	$e453
ciov	equ	$e456
siov	equ	$e459
xitvbv	equ	$e462
.endif

;==========================================================================
; LIBRARY ZP
;
a0		equ	$c0
a1		equ	$c2
a2		equ	$c4
a3		equ	$c6
d0		equ	$c8
d1		equ	$c9
d2		equ	$ca
d3		equ	$cb
d4		equ	$cc
d5		equ	$cd
d6		equ	$ce
d7		equ	$cf

;==========================================================================
; LIBRARY VARS
;
		opt o-

.ifdef SYS5200
		opt f-
.else
.ifdef STANDALONE
		opt o+
.endif
.ifdef GENLIBRARY
		opt o+
.endif
.endif

		.ifdef SYSSAP
		org	$0280
		.endif
		
		.ifdef SYS5200
		org	$0280
		.endif
		
		.ifdef SYS800
		org	$1a20
		.endif		
_intsOff	dta		0
_scrnOff	dta		0
_prevIRQ	dta		a(0)
_prevVBI	dta		a(0)
_exitTest	dta		a(0)
_exitTestS	dta		$ff
_vputchar	dta		a(0)

		.ifdef SYS800
_vputunhook	dta		a(0)
		.endif

	CPUMODE_6502 = 0
	CPUMODE_65C02 = 1
	CPUMODE_65C816_16 = 0x80
	CPUMODE_65C816_24 = 0x81
_cpuMode	dta		0

		.ifdef SYS5200
sskctl		dta		0
ch			dta		0
keydel		dta		0

			org		$02e0
runad		dta		a(0)
initad		dta		a(0)
		.endif

		.ifdef SEGS_IN_ROM
_lastMod	dta		0
		.endif
		.ifdef SEGS_MIN_MEM
_lastMod	dta		0
		.endif

		.ifdef SYS5200
		.ifdef STANDALONE
		opt o+f+
		.endif
		.ifdef GENLIBRARY
		opt o+f+
		.endif

		.ifdef LIBBASE
		org	LIBBASE
		.else
		org	$4000
		.endif
		.endif
		
		.ifdef SYSSAP
		org		$4000
		.endif

;==========================================================================
; MACROS
;
.macro _INITTEST
	jsr		_imTestInit
	dta		:1,0
.endm

.macro _ASSERT1
	lda	:1
	cmp	#:2
	beq	pass
	
	sta	d1
	jsr	_testFailed
	dta	:3,0
pass:
.endm

.macro _ASSERT1_DUAL
	lda	:1
	cmp	#:2
	beq	pass
	cmp	#:3
	beq	pass
	
	sta	d1
	jsr	_testFailed
	dta	:4,0
pass:
.endm

.macro _ASSERTA
	cmp	#:1
	beq	pass
	
	sta	d1
	jsr	_testFailed
	dta	:2,0
pass:
.endm

.macro _ASSERTX
	cpx	#:1
	beq	pass
	
	stx	d1
	jsr	_testFailed
	dta	:2,0
pass:
.endm

.macro _ASSERTY
	cpy	#:1
	beq	pass
	
	sty	d1
	jsr	_testFailed
	dta	:2,0
pass:
.endm

.macro _FAIL
	jsr		_testFailed
	dta		:1,0
.endm

.macro _SKIP
	jsr		_testSkipped
	dta		:1,0
.endm

.macro _SAP_HEADER
	.ifdef GENSAP
		opt		o+h-f-
		org		$0700
		dta		c"SAP",$0d,$0a
		dta		c"AUTHOR ",$22,c"Avery Lee",$22,$0d,$0a
		dta		c"NAME ",$22,c":1",$22,$0d,$0a
		dta		c"TYPE D",$0d,$0a
		dta		c"INIT 2000",$0d,$0a
		dta		c"TIME 00:",c"05",$0d,$0a
		dta		a($ffff)
	.endif
.endm

;==========================================================================
.nowarn .proc	_crt0init
.ifdef SYSSAP
	jsr		_crt0init_sap
.endif

	;clear zero page and database
.ifdef SYS5200
	ldx		#$20
	lda		#0
zploop:
	sta		0,x
	inx
	bne		zploop
	ldx		#$80
dbloop:
	sta		$0200,x
	inx
	bne		dbloop
.endif
	
	;detect CPU
	ldy		#CPUMODE_6502
	sed
	lda		#$99
	clc
	adc		#$01
	cld
	bne		detdone
	
	;we have at least a 65C02... check for 65C816
	ldy		#CPUMODE_65C02

	sec
	opt		c+
	rep		#$01
	bcs		detdone
	sep		#$01
	bcc		detdone
	
	ldy		#CPUMODE_65C816_16
	
	;check for 24-bit addressing
	lda		d3+$10000
	eor		#$f5
	sta		d3
	cmp		d3+$10000
	seq
	iny
	
	opt		c-
	
detdone:
	sty		_cpuMode

.ifdef SYS5200
	jsr		_crt0init_5200
.endif

.ifdef SYS800
	;init putchar handler
	mwa		icptl _vputchar
	inw		_vputchar
.endif

	rts
.endp

;==========================================================================
.nowarn .proc	_interruptsOff
	lda	_intsOff
	bmi	xit
	sei
	mwa	vimirq _prevIRQ
	mva	#$ff _intsOff
xit:
	rts
.endp

;==========================================================================
.nowarn .proc	_interruptsOn
	lda	_intsOff
	bpl	xit
	sei
	mwa	_prevIRQ vimirq
	mva	pokmsk irqen
	mva	#$00 _intsOff
	cli
xit:
	rts
.endp

;==========================================================================
.nowarn .proc _screenOn
	.ifndef SYSSAP
	lda	_scrnOff
	bpl	xit
	
	jsr	_waitVBL
	
	sei
	lda	#0
	sta	wsync
	sta	nmien
	mva	#$22 dmactl
	mwa	sdlstl dlistl
	mwa	_prevVBI vvblki
	lda	#$40
	sta	nmien
	cli
	
	jsr	_waitVBL
	sta	wsync
	sta	wsync
	jsr	_waitVBL
	.endif

	mva	#$00 _scrnOff
xit:
	rts
.endp

;==========================================================================
.nowarn .proc _screenOff
	.ifndef SYSSAP
	lda	_scrnOff
	bmi	xit
	
	jsr	_waitVBL
		
	php
	sei
	lda	#0
	sta	wsync
	sta	nmien
	sta	dmactl
	mwa	vvblki _prevVBI
	plp
	.endif

	mva	#$ff _scrnOff
xit:
	rts
.endp

;==========================================================================
.nowarn .proc _waitVBL
	lda	#123
	cmp:rne vcount
	cmp:req vcount
	rts
.endp

;==========================================================================
.nowarn .proc _waitFrame
	inc	wsync
	inc	wsync
	jmp	_waitVBL
.endp

;==========================================================================
.nowarn .proc _waitKeyPrompt
	jsr		_imprint
	dta		c"Press a key...",0
	.ifdef SYS5200
	mva		#$ff ch
	lda:rmi	ch
	.else
	lda		#0
	sta		ch
	sta		ch1
	lda:req	ch
	.endif
	jsr		_imprint
	dta		$9c,0
	rts
.endp

;==========================================================================
.nowarn .proc _resetAV
	lda	#0
	sta	gractl
	sta	grafp0
	sta	grafp1
	sta	grafp2
	sta	grafp3
	sta	grafm
	sta	audc1
	sta	audc2
	sta	audc3
	sta	audc4
	rts
.endp

;==========================================================================
.nowarn .proc _imprint
	pla
	tax
	pla
	tay
	inx
	sne:iny
	txa
	jsr	_print
	lda	a0+1
	pha
	lda	a0
	pha
	rts	
.endp

;==========================================================================
.nowarn .proc _imprintf
	pla
	tax
	pla
	tay
	inx
	sne:iny
	txa
	jsr	_printf
	lda	a0+1
	pha
	lda	a0
	pha
	rts	
.endp

;==========================================================================
.nowarn .proc _print
	sta	a0
	sty	a0+1
charloop:
	ldy	#0
	lda	(a0),y
	beq	done
	inw	a0
	jsr	_printf.putbyte
	jmp	charloop
done:
	rts
.endp

;==========================================================================
.nowarn .proc _println
	jsr		_imprint
	dta		$9b,0
	rts
.endp
;==========================================================================
.nowarn .proc _printf
	sta	a0
	sty	a0+1
	ldy	#0
	sty	d0
charloop:
	lda	(a0),y
	beq	done
	inw	a0
	cmp	#'%'
	beq	special
escaped:
	jsr	putbyte
nextchar:
	ldy	#0
	jmp	charloop
done:
	rts
special:
	inc	d0
	ldx	d0
	lda	(a0),y
	inw	a0
	cmp #'d'
	bne	notdec
	tya
	sty	a1
	ldy	#6
	sei
	sed
decloop1:
	rol	d0,x
	adc	a1
	sta	a1
	dey
	bne	decloop1
	sty	a1+1
	ldy	#2
decloop2:
	rol	d0,x
	adc	a1
	sta	a1
	rol	a1+1
	dey
	bne	decloop2
	cld
	cli
	lda	a1+1
	beq	decdigit2
	tax
	lda	_hexdig,x
	jsr	putbyte
	lda	a1
	jsr	puthex
	jmp	nextchar
decdigit2:
	lda	a1
	cmp	#$10
	bcc	decdigit1
	jsr	puthex
	jmp	nextchar
decdigit1:
	tax
	lda	_hexdig,x
	jmp	escaped

notdec:
	cmp	#'x'
	bne	nothex
	lda	d0,x
	jsr	puthex
	jmp	nextchar

nothex:
	cmp	#'X'
	bne	nothexword
	inc	d0
	lda	d1,x
	jsr	puthex
	ldx	d0
	lda	d0-1,x
	jsr	puthex
	jmp	nextchar

nothexword:
	cmp #'D'
	bne	notdecword

	ldy	#8
	lda	#0
	sta	a1
	sta a1+1
	sta	a2
	sei
	sed
decword1:
	rol	d1,x
	lda	a1
	adc	a1
	sta	a1
	lda	a1+1
	adc	a1+1
	sta	a1+1
	dey
	bne	decword1
	
	ldy	#8
decword2:
	rol	d0,x
	lda	a1
	adc	a1
	sta	a1
	lda	a1+1
	adc	a1+1
	sta	a1+1
	lda	a2
	adc	a2
	sta	a2
	dey
	bne	decword2
	cld
	cli
	
	tax
	beq	decword3
	jsr	puthexcond
	lda	a1+1
	jsr	puthex
	lda	a1
	jsr	puthex
	jmp	nextchar

decword3:
	lda	a1+1
	beq	decword4
	lda	a1
	jsr	puthex
	jmp	nextchar
	
decword4:
	lda	a1
	jsr	puthex
	jmp	nextchar

notdecword:
	cmp #'c'
	bne	notchar
	inc	d0
	lda	d0,x
	jsr	putbyte
	jmp	nextchar
	
notchar:
	cmp #'s'
	bne	notstr
	
	inc	d0
	lda	d0,x
	sta	a1
	lda	d0+1,x
	sta	a1+1

strloop:
	ldy	#0
	lda	(a1),y
	beq	strdone
	jsr	putbyte2
	inw	a1
	jmp	strloop

strdone:
	jmp	nextchar
	
notstr:
	dec	d0
	jmp	escaped
	
puthexcond:
	cmp	#$10
	bcs	puthex
	tax
	lda	_hexdig,x
	jmp	putbyte	
puthex:	
	pha
	lsr
	lsr
	lsr
	lsr
	tax
	lda	_hexdig,x
	jsr	putbyte
	pla
	and	#$0f
	tax
	lda	_hexdig,x
	jmp	putbyte

putbyte:
	tax
	jsr	putbyte2
	txa
	rts
	
putbyte2:
	jmp	(_vputchar)
.endp

;==========================================================================
.nowarn .proc	_jam
loop:
	jmp	loop
.endp

;==========================================================================
.nowarn .proc	_waitVCount
	cmp:rne	vcount
	rts
.endp

;=========================================================================
.nowarn .proc	_imTestInit
	pla
	sta		a0
	tay
	pla
	sta		a0+1
	
	inw		a0

	mva		#0 a1
	mva		a0+1 a1+1	
skiploop:
	lda		(a1),y
	beq		skipdone
	iny
	sne:inc a1+1
	jmp		skiploop
skipdone:
	lda		a1+1
	pha
	tya
	pha
	lda		a0
	ldy		a0+1
	jmp		_testInit
.endp

;=========================================================================
.nowarn .proc	_testInit
	.ifdef STANDALONE
	pha
	tya
	pha
	
	jsr _crt0init
	
	pla
	tay
	pla
	.endif
	
	jsr	_print
	jsr	_imprint
	dta	c"...",0
	
	.ifdef STANDALONE
	mwa	#_testEnd _exitTest
	.else
	:10 nop
	.endif
	
	rts
	
msg:
	dta	c"...",0
.endp

;=========================================================================
.nowarn .proc	_testEnd
	.ifdef SYSSAP
		.ifdef STANDALONE
			jmp	_sap_testEnd
		.else
			jmp	_jam
		.endif
	.else
		.ifdef SYS5200
			jmp	_jam
		.else
			;wait for key
			sei
			lda		#0
			sta		nmien
			sta		irqen
			mva		#3 skctl
			mva		#$40 irqen
			bit:rne	irqst
			
			;initiate soft reset
			jmp		($fffc)
		.endif
	.endif
.endp

;=========================================================================
.nowarn .proc	_testRestore
	cld
	php
	sei
	
	;check if the screen is off; if so, make sure we kill DLIs
	lda		_scrnOff
	beq		scrnOK
	
	lda		#0
	inc		wsync
	sta		nmien
	
scrnOK:

	mva		sskctl skctl
		
	.ifdef SYSSAP
	;kill PIA port A interrupt
	mva		#$3c pactl
	
	;force kernel ROMs back _out_
	mva		#$38 pbctl
	mva		#$ff portb
	mva		#$3c pbctl
	mva		#$82 portb
	.endif
	
	.ifdef SYS5200
	mva		#$00 prior
	mva		#$f8 chbase
	mva		#$02 chactl
	mva		#$04 consol
	.endif
	
	.ifdef SYS800
	;kill PIA port A interrupt
	mva		#$3c pactl
	
	;force kernel ROMs back in	
	mva		#$38 pbctl
	mva		#$00 portb
	mva		#$3c pbctl
	mva		#$83 portb
	
	;kill OS timer 1
	ldx		#$ff
	stx		wsync
	stx		cdtmv1
	inx
	stx		cdtmv1
	stx		cdtmv1+1
	.endif

	plp
	jsr	_interruptsOn
	jsr	_screenOn
	jmp	_resetAV
.endp

;=========================================================================
.nowarn .proc	_testPassed
	jsr	_testRestore

	jsr	_imprint
	dta	c"Pass",$9b,0
	
	ldx	_exitTestS
	txs
	ldy	#0
	jmp	(_exitTest)
.endp

;=========================================================================
.nowarn .proc	_testFailed
	jsr	_testRestore

	jsr	_imprint
	dta	c"FAIL.",$9b,0

nomsgentry:
	pla
	tax
	pla
	tay
	inx
	sne:iny
	txa
	jsr	_printf
	jsr	_println
	
	ldx	_exitTestS
	txs
	ldy	#$80
	jmp	(_exitTest)

msg2:
	dta	$9b,0
.endp

;=========================================================================
.nowarn .proc	_testFailed2
	jsr	_testRestore
	jmp	_testFailed.nomsgentry
.endp

;=========================================================================
.nowarn .proc	_testSkipped
	jsr		_testRestore

	jsr		_imprint
	dta		c"Skipped",$9b,0
	
	pla
	tax
	pla
	tay
	inx
	sne:iny
	txa
	jsr		_printf
	
	jsr		_println
	
	ldx		_exitTestS
	txs
	ldy		#$40
	jmp		(_exitTest)
.endp

;==========================================================================
; _loadSeg()
;
; Module loader.
;
;	X = index of module to load
;
.ifdef SEGS_MIN_MEM
.nowarn .proc	_loadSeg
	;get starting sector
	mva		segaddrlo,x	daux1
	mva		segaddrhi,x	daux2
		
	;get ending sector
	lda		segaddrlo+1,x
	sub		daux1
	sta		d7

	;setup sector load command and relocation
	mva		#'R' dcomnd
	mva		#1 dunit
	lda		#$00
	sta		dbuflo
	sta		a0
	sta		runad+1
	lda		#$0b
	sta		dbufhi
	sta		a0+1
	
	;preload first two sectors
	jsr		step_sector
relocloop:
	;load starting address
	mva		(a0),y a1
	iny:sne:jsr step_sector
	mva		(a0),y a1+1
	iny:sne:jsr step_sector
	
	;skip $ffff words
	lda		a1
	and		a1+1
	cmp		#$ff
	beq		relocloop
	
	;load ending address
	mva		(a0),y a2
	iny:sne:jsr step_sector
	mva		(a0),y a2+1
	iny:sne:jsr step_sector
	inw		a2
	
	;copy data (slow, but oh well)
	ldx		#0
copyloop:
	lda		(a0),y
	sta		(a1,x)
	iny:sne:jsr step_sector
	inw		a1
	lda		a1
	cmp		a2
	bne		copyloop
	lda		a1+1
	cmp		a2+1
	bne		copyloop
	
	;init a segment
	mwa		#definit initad
	jsr		doinit
	
	;check if we're done
	lda		runad+1
	beq		relocloop
	rts

doinit:
	jmp		(initad)
	
step_sector:
	lda		d7
	beq		no_sectors_left
	jsr		dskinv
	dec		d7
	inw		daux1
	lda		dbuflo
	eor		#$80
	sta		dbuflo
	bne		step_sector
no_sectors_left:
	ldy		#0
	ldx		#0
definit:
	rts
.endp
.else
.nowarn .proc	_loadSeg
.ifdef SEGS_IN_ROM
	stx		_lastMod
	rts
.else
	;get starting sector
	mva		segaddrlo,x	daux1
	mva		segaddrhi,x	daux2
		
	;get ending sector
	mva		segaddrlo+1,x	a0
	mva		segaddrhi+1,x	a0+1

	;load sectors starting at $4000
sectorloop:
	mva		#'R' dcomnd
	mva		#1 dunit
	mwa		#$4000 dbuflo
		
	jsr		dskinv
	tya
	bmi		sectorloop
	
	lda		#$80
	eor		dbuflo
	sta		dbuflo
	sne:inc	dbufhi
	
	inc		daux1
	sne:inc	daux2
	
	lda		daux1
	cmp		a0
	bne		sectorloop
	lda		daux2
	cmp		a0+1
	bne		sectorloop
	rts
.endif
.endp
.endif

;==========================================================================
; _runSeg()
;
; Module relocator and executor.
;
; The last segment loaded by _loadSeg() is relocated and executed.
;

.ifdef SEGS_MIN_MEM

;-----------------------------------------------
; Minimum memory implementation.
.nowarn .proc _runSeg
	jmp		(runad)
.endp

.else

;-----------------------------------------------
.nowarn .proc _runSeg
	
	;begin relocation
	mwa		#relocloop runad

	.ifdef SEGS_IN_ROM
	ldx		_lastMod
	mva		segaddrlo,x a0
	mva		segaddrhi,x a0+1
	.else
	mwa		#$4000 a0
	.endif
	
	.ifndef SEGS_LZPACK
	
	;==== uncompressed version

	ldy		#0
relocloop:
	;load starting address
	mva		(a0),y a1
	inw		a0
	mva		(a0),y a1+1
	inw		a0
	
	;skip $ffff words
	lda		a1
	and		a1+1
	cmp		#$ff
	beq		relocloop
	
	;load ending address
	mva		(a0),y a2
	inw		a0
	mva		(a0),y a2+1
	inw		a0
	inw		a2
	
	;copy data (slow, but oh well)
copyloop:
	lda		(a0),y
	sta		(a1),y
	inw		a0
	inw		a1
	lda		a1
	cmp		a2
	bne		copyloop
	lda		a1+1
	cmp		a2+1
	bne		copyloop
	
	;init a segment
	mwa		#definit initad
	jsr		doinit
	jmp		(runad)

doinit:
	jmp		(initad)
	
definit:
	rts

	.else
	
	;==== compressed version
	;
	;loader:
	;	a3		destination
	;	d6/d7	segment end address
	;
	;decompressor:
	;	a0		raw source stream
	;	a1		run source pointer
	;	a2		window pointer ($1000-1fff)
	;	d0		literal/run flag bits
	;	d1		remaining flag bits shifter
	;	d2		run length counter
	;	d3		temporary
	;	d4		superflag bits
	;	d5		superflag shifter

	lda		#0
	sta		d0
	sta		d1
	sta		d2
	sta		d5
	sta		a2
	lda		#$10
	sta		a2+1
relocloop:
	ldy		#0
	;load starting address
	jsr		getbyte
	sta		a3
	jsr		getbyte
	sta		a3+1
	
	;skip $ffff words
	and		a3
	cmp		#$ff
	beq		relocloop
	
	;load ending address
	jsr		getbyte
	sta		d6
	jsr		getbyte
	sta		d7
	inw		d6
	
	;copy data (slow, but oh well)
copyloop:
	jsr		getbyte
	sta		(a3),y
	inw		a3
	lda		a3
	cmp		d6
	bne		copyloop
	lda		a3+1
	cmp		d7
	bne		copyloop
	
	;init a segment
	mwa		#definit initad
	jsr		doinit
	jmp		(runad)

doinit:
	jmp		(initad)
	
getbyte:
	;check if we have a run in progress
	lda		d2
	bne		getrunbyte

	;check if we need to reload flag bits
	asl		d1
	bne		havebits
	
	;check if we need to reload superflag bits
	asl		d5
	bne		havesuperbits
	
	;load next superflag byte
	jsr		getrawbyte
	sta		d4
	lda		#$7f
	sta		d5
	
havesuperbits:
	;pull next superflag and check if it's all literals (0)
	asl		d4
	bcc		all_literals
	
	;nope... read next byte as flags byte
	jsr		getrawbyte
	sta		d0

all_literals:
	lda		#$7f
	sta		d1
havebits:
	asl		d0
	bcs		isrun
	
	;store byte into window
	jsr		getrawbyte
	jmp		putwinbyte

isrun:
	;load offset/run bytes
	jsr		getrawbyte
	sta		d3
	jsr		getrawbyte
	sta		d2
	
	;compute run source from current position and offset
	lda		a2
	clc
	sbc		d3
	sta		a1
	lda		a2+1
	sbc		d2
	and		#$0f
	ora		#$10
	sta		a1+1
	
	;compute length and stash run length
	lda		d2
	lsr
	lsr
	lsr
	lsr
	add		#3
	sta		d2
getrunbyte:
	dec		d2
	ldy		#0
	lda		(a1),y
	inc		a1
	bne		putwinbyte
	inc		a1+1
	pha
	lda		a1+1
	and		#$0f
	ora		#$10
	sta		a1+1
	pla
	jmp		putwinbyte
	
getrawbyte:
	lda		(a0),y
	inw		a0
	rts
	
putwinbyte:
	sta		(a2),y
	inc		a2
	seq:rts
	ldy		a2+1
	iny
	cpy		#$20
	sne:ldy	#$10
	sty		a2+1
	ldy		#0
definit:
	rts	
	
	.endif
.endp
.endif

;==========================================================================
_hexdig	dta		c"0123456789ABCDEF"

;==========================================================================
; segment table
;
.ifndef SYS800
segaddrlo	equ	$bf00
segaddrhi	equ	$bf80
.else
segaddrlo	equ	$1900
segaddrhi	equ	$1980
.endif

;==========================================================================
; platform-specific library
;
.ifdef SYS5200
	icl		'lib5200.s'
.endif
.ifdef SYSSAP
	icl		'libsap.s'
.endif

;==========================================================================
.ifndef STANDALONE
.ifdef SYS5200
	opt	o+
.else
	opt	h+o+
.endif
.endif
