; Altirra Acid800 test suite
; Copyright (C) 2010 Avery Lee, All Rights Reserved.
;
; Permission is hereby granted, free of charge, to any person obtaining a copy
; of this software and associated documentation files (the "Software"), to deal
; in the Software without restriction, including without limitation the rights
; to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
; copies of the Software, and to permit persons to whom the Software is
; furnished to do so, subject to the following conditions:
;
; The above copyright notice and this permission notice shall be included in
; all copies or substantial portions of the Software.
;
; THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
; IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
; FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
; AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
; LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
; OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
; SOFTWARE. 

		_SAP_HEADER "POKEY: IRQ timing"

		opt		h+o+

		icl		'library.s'

		org		$2000

main:
		ldy		#>testname
		lda		#<testname
		jsr		_testInit
		
		;turn interrupts off
		jsr		_screenOff
		jsr		_interruptsOff
		mva		#$00 irqen
		
		;reset serial port to force output complete
		mva		#0 skctl
		mva		#3 skctl
		
		;revector IRQ and enable interrupts
		mwa		#irq1 vimirq
		cli
		
		lda		#124
		cmp:rne	vcount
		
		;enable seroc and see how long it takes to fire
		lda		#$08
		ldx		#0
		inc		wsync
		pha:pla				;105-111
		pha:pla				;112-4 (113-5)
		pha:pla				;5-10
		pha:pla				;11-17
		pha:pla				;18-24
		pha:pla				;25-34
		pha:pla				;35-43
		pha:pla				;44-52
		pha:pla				;53-61
		sta		irqen
		inx
		inx		;interrupt here
		inx		;...or here
		inx
		inx
		inx
		inx
		inx
		
		sei
resume1:
		stx		d0
		
		;try again, with a one cycle offset
		mva		#0 irqen
		mwa		#irq2 vimirq
		cli
		
		;enable seroc and see how long it takes to fire
		mva		#1 d1
		lda		#$08
		ldx		#0
		inc		wsync
		pha:pla				;105-111
		pha:pla				;112-4 (113-5)
		pha:pla				;5-10
		pha:pla				;11-17
		pha:pla				;18-24
		pha:pla				;25-34
		pha:pla				;35-43
		pha:pla				;44-52
		pha:pla				;53-61
		sta		irqen
		ldx		d1
		inx		;interrupt here
		inx
		inx
		inx
		inx
		inx
		inx
		
		sei
resume2:
		stx		d1

		;check values
		;
		;Note that Ataris vary slightly in their POKEY IRQ latency; my 130XE shows 2
		;cycles whereas my 800XL shows 3. This shows up as a one-level difference in
		;the even value.
		lda		d0
		cmp		#$02
		beq		evenok1
		_ASSERTA $01, c"Incorrect cycle count (even): $%x",0
evenok1:
		_ASSERT1 d1, $01, c"Incorrect cycle count (odd): $%x",0

		jmp		_testPassed
	
irq1:
		pla
		pla
		pla
		jmp		resume1
		
irq2:
		pla
		pla
		pla
		jmp		resume2
		
testname:
		dta		c"POKEY: IRQ timing",0

		run		$2000
		end
