// Altirra Acid800 test suite
// Build utility
// Copyright (C) 2010-2011 Avery Lee, All Rights Reserved.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE. 

#include <stdafx.h>

int cmd_lzpack(int argc, const char *const *argv) {
	if (argc < 2)
		fail("lzpack requires input and output filenames");

	FILE *fi = fopen(argv[1], "rb");
	if (!fi)
		fail("cannot open input file: %s", argv[1]);

	FILE *fo = fopen(argv[2], "wb");
	if (!fo)
		fail("cannot open output file: %s", argv[2]);

	int htchain[4096];
	int ht[256];

	for(int i=0; i<256; ++i)
		ht[i] = -1;

	for(int i=0; i<4096; ++i)
		htchain[i] = -1;

	fseek(fi, 0, SEEK_END);
	size_t len = ftell(fi);
	fseek(fi, 0, SEEK_SET);

	uint8 *const mem = new uint8[len + 18];
	memset(mem, 0, len + 18);

	if (1 != fread(mem, len, 1, fi))
		fail("cannot read input file: %s", argv[1]);

	fclose(fi);

	uint32 pos = 0;
	uint32 lenm2 = len > 2 ? len - 2 : 0;
	uint8 hc = mem[0] + mem[1] + mem[2];

	uint8 dstbuf[136];
	uint8 *dst = dstbuf;
	int dstbits = 0;
	int dstsuperbits = 0;

	*dst++ = 0;

	uint8 *dstflags = dst;
	*dst++ = 0;

	while(pos < lenm2) {
		// search hash chain
		int minpos = pos > 4096 ? (int)pos - 4096 : 0;
		const uint8 *curptr = mem + pos;
		int bestlen = 2;
		int bestdist = 0;

		int testpos = ht[hc];
		while(testpos >= minpos) {
			uint8 *testptr = mem + testpos;

			if (testptr[bestlen] == curptr[bestlen]) {
				int matchlen = 0;

				while(matchlen < 18 && testptr[matchlen] == curptr[matchlen])
					++matchlen;

				if (matchlen > bestlen) {
					bestlen = matchlen;
					bestdist = (pos - testpos) - 1;

					if (matchlen == 18)
						break;
				}
			}

			int nextpos = htchain[testpos & 0xfff];
			if (nextpos >= testpos)
				break;

			testpos = nextpos;
		}

		*dstflags += *dstflags;
		if (bestlen >= 3) {
			++*dstflags;
			*dst++ = (uint8)bestdist;
			*dst++ = (uint8)((bestdist >> 8) + ((bestlen - 3) << 4));
		} else {
			*dst++ = *curptr;
			bestlen = 1;
		}

		if (++dstbits >= 8) {
			dstbits = 0;

			dstbuf[0] += dstbuf[0];

			if (*dstflags == 0) {
				memmove(dstflags, dstflags + 1, dst - (dstflags + 1));
				--dst;
			} else {
				++dstbuf[0];
			}

			if (++dstsuperbits >= 8) {
				dstsuperbits = 0;

				fwrite(dstbuf, dst - dstbuf, 1, fo);
				dst = dstbuf;

				*dst++ = 0;
			}

			dstflags = dst;
			*dst++ = 0;
		}

		do {
			htchain[pos & 0xfff] = ht[hc];
			ht[hc] = pos;

			hc -= mem[pos];
			hc += mem[pos + 3];
			++pos;
		} while(--bestlen);
	}

	while(pos < len) {
		*dstflags += *dstflags;
		*dst++ = mem[pos++];

		if (++dstbits >= 8) {
			dstbits = 0;

			dstbuf[0] += dstbuf[0];

			if (*dstflags == 0) {
				memmove(dstflags, dstflags + 1, dst - (dstflags + 1));
				--dst;
			} else {
				++dstbuf[0];
			}

			if (++dstsuperbits >= 8) {
				dstsuperbits = 0;

				fwrite(dstbuf, dst - dstbuf, 1, fo);
				dst = dstbuf;

				*dst++ = 0;
			}

			dstflags = dst;
			*dst++ = 0;
		}
	}

	if (dstbits) {
		*dstflags <<= (8 - dstbits);

		dstbuf[0] += dstbuf[0];

		if (*dstflags == 0) {
			memmove(dstflags, dstflags + 1, dst - (dstflags + 1));
			--dst;
		} else {
			++dstbuf[0];
		}

		++dstsuperbits;
	} else {
		--dst;
	}

	if (dstsuperbits) {
		dstbuf[0] <<= (8 - dstsuperbits);
		fwrite(dstbuf, dst - dstbuf, 1, fo);
	}

	printf("%s(%d) -> %s(%d)\n", argv[1], len, argv[2], (int)ftell(fo));

	fclose(fo);

	return 0;
}
