// Altirra Acid800 test suite
// Build utility
// Copyright (C) 2010-2011 Avery Lee, All Rights Reserved.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE. 

#include <stdafx.h>

int cmd_lzunpack(int argc, const char *const *argv) {
	if (argc < 2)
		fail("lzunpack requires input and output filenames");

	FILE *fi = fopen(argv[1], "rb");
	if (!fi)
		fail("cannot open input file: %s", argv[1]);

	FILE *fo = fopen(argv[2], "wb");
	if (!fo)
		fail("cannot open output file: %s", argv[2]);

	uint8 window[8192] = {0};

	uint8 bits = 0;
	int bitsleft = 0;
	uint8 superbits = 0;
	int superbitsleft = 0;

	int pos = 0;
	for(;;) {
		int c = getc(fi);

		if (c < 0)
			break;

		if (!bitsleft) {
			if (!superbitsleft) {
				superbits = (uint8)c;
				superbitsleft = 8;

				c = getc(fi);
				if (c < 0)
					fail("decompression error");
			}

			if (superbits & 0x80) {
				bits = (uint8)c;

				c = getc(fi);
				if (c < 0)
					fail("decompression error");
			} else {
				bits = 0;
			}
			bitsleft = 8;

			superbits <<= 1;
			--superbitsleft;
		}

		if (bits & 0x80) {
			int d = getc(fi);

			if (d < 0)
				fail("decompression error");

			int offset = c + ((d & 15) << 8);
			int len = (d >> 4) + 3;

			const uint8 *src = window + ((pos - (offset + 1)) & 0xfff);
			do {
				uint8 b = *src++;

				window[pos++ & 0xfff] = b;
				putc(b, fo);
			} while(--len);
		} else {
			window[pos++ & 0xfff] = c;
			putc(c, fo);
		}

		bits <<= 1;
		--bitsleft;
	}

	int packlen = ftell(fi);
	int len = ftell(fo);

	fclose(fi);
	fclose(fo);

	printf("%s(%d) -> %s(%d)\n", argv[1], packlen, argv[2], len);

	return 0;
}
