// Altirra Acid800 test suite
// Build utility
// Copyright (C) 2010-2011 Avery Lee, All Rights Reserved.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE. 

#include <stdafx.h>

extern int cmd_lzpack(int argc, const char *const *argv);
extern int cmd_lzunpack(int argc, const char *const *argv);
extern int cmd_mkfsdos2(int argc, const char *const *argv);

void print_usage();

int main(int argc, const char *const *argv) {
	if (argc < 2) {
		print_usage();
		exit(0);
	}

	const char *cmdname = argv[1];
	--argc;
	++argv;

	if (!strcmp(cmdname, "lzpack"))
		return cmd_lzpack(argc, argv);
	else if (!strcmp(cmdname, "lzunpack"))
		return cmd_lzunpack(argc, argv);
	else if (!strcmp(cmdname, "mkfsdos2"))
		return cmd_mkfsdos2(argc, argv);

	print_usage();
	return 10;
}

void print_usage() {
	puts("AcidBuilder <command> [arguments...]");
	puts("");
	puts("Commands:");
	puts("  lzpack - compress using LZ77");
	puts("  lzunpack - decompress using LZ77");
	puts("  mkfsdos2 - make DOS 2.0S filesystem");
}
