; Altirra Acid800 test suite
; Copyright (C) 2010-2011 Avery Lee, All Rights Reserved.
;
; Permission is hereby granted, free of charge, to any person obtaining a copy
; of this software and associated documentation files (the "Software"), to deal
; in the Software without restriction, including without limitation the rights
; to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
; copies of the Software, and to permit persons to whom the Software is
; furnished to do so, subject to the following conditions:
;
; The above copyright notice and this permission notice shall be included in
; all copies or substantial portions of the Software.
;
; THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
; IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
; FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
; AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
; LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
; OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
; SOFTWARE. 

	opt	h-o+
	org	0

.macro _PADSECTOR
	:(($80-*)&$7f) dta 0
.endm

	dta	$96, $02
	dta	a([diskend - imagestart]/$10)
	dta	$80
	:11 dta 0
	
	org	$0080
imagestart:
	ins	'boot.obx'

;==========================================================================

.macro _MODULEADDRHI
	dta >(mod_:1/$80)
.endm	

.macro _MODULEADDRLO
	dta <(mod_:1/$80)
.endm	

.def ?module_count = 0

.macro _MODULELABEL1
	.def mod_:1 = *
.endm

.macro _MODULELABEL
	;workaround for annoying MADS bug where MACRO and REPT parameters don't nest properly
	.rept :1+1
	.if # == :1
		_MODULELABEL1 #
	.endif
	.endr
.endm

.macro _MODULE
	_MODULELABEL ?module_count

	ins	:1
	_PADSECTOR

	.def :?module_count = :?module_count + 1
.endm

;==========================================================================

	_PADSECTOR
imageend:
	:1 _MODULEADDRLO #
check_1:
	_PADSECTOR

check_2:
	:1 _MODULEADDRHI #
check_3:
	_PADSECTOR
	
	_MODULELABEL ?module_count

	.if ?module_count<>(check_1-imageend-1)
	.error "Module low byte table length is incorrect"
	.endif

	.if ?module_count<>(check_3-check_2-1)
	.error "Module high byte table length is incorrect"
	.endif
	
	_PADSECTOR
diskend
