; Altirra AcidOS test suite
; Copyright (C) 2013 Avery Lee, All Rights Reserved.
;
; Permission is hereby granted, free of charge, to any person obtaining a copy
; of this software and associated documentation files (the "Software"), to deal
; in the Software without restriction, including without limitation the rights
; to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
; copies of the Software, and to permit persons to whom the Software is
; furnished to do so, subject to the following conditions:
;
; The above copyright notice and this permission notice shall be included in
; all copies or substantial portions of the Software.
;
; THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
; IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
; FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
; AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
; LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
; OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
; SOFTWARE. 

		icl		'cio.inc'

		org		$8000

.proc __init
		;set APPMHI
		mwa		#$7fff appmhi
		
		mwa		#_log_display _log_curln
		mva		#0 _log_curx
		
		;shut off NMIs and display DMA
		lda		#0
		sta		nmien
		sta		dmactl
		
		;enable paging
		mva		#LOGF_PAGING _log_flags
		
		;clear display
		lda		#$7d
		jsr		_log_putchar
		
		;hook keyboard interrupt
		sei
		mwa		vkeybd _log_keyboardirq.chainaddr
		mwa		#_log_keyboardirq vkeybd
		cli
		
		mwa		sdlstl _log_dlsave
		
		;replace deferred VBI
		lda		#7
		ldy		#<_log_deferred_vbi
		ldx		#>_log_deferred_vbi
		jsr		setvbv
		
		;reinitialize display
		mwa		#_log_dlist sdlstl
		mva		#$40 nmien
				
		;open keyboard on IOCB #4
		ldx		#$40
		mva		#CIOCmdClose iccmd,x
		jsr		ciov
		mva		#CIOCmdOpen iccmd,x
		mwa		#kbdname icbal,x
		mva		#$0c icax1,x
		mva		#0 icax2,x
		jsr		ciov
		
		;reopen display on IOCB #0
		ldx		#0
		mva		#CIOCmdClose iccmd,x
		jsr		ciov
		mva		#CIOCmdOpen iccmd,x
		mwa		#dispname icbal,x
		mva		#$04 icax1,x
		jsr		ciov
		
		;wait for display to reinit
		lda		rtclok+2
		cmp:req	rtclok+2
		
.ifdef STANDALONE
		;call program
		jsr		main
		
		jsr		_log_imprint
		dta		'Test completed.',$9b,0
		
		;wait for a key before exiting
		jsr		_waitKey
		
		;restore keyboard IRQ
		sei
		mwa		_log_keyboardirq.chainaddr vkeybd
		cli
		
		;restore system VBIs
		lda		#7
		ldy		#<xitvbv
		ldx		#>xitvbv
		jsr		setvbv
		
		;restore display
		sei
		lda		_log_dlsave+1
		mwa		_log_dlsave dlistl
		cli
		
		lda		rtclok+2
		cmp:rne	rtclok+2
		
		rts
.else
		jmp		main
.endif

dispname:
		dta		'E:',$9B

kbdname:
		dta		'K:',$9B
.endp
