; Altirra AcidOS test suite
; Copyright (C) 2013 Avery Lee, All Rights Reserved.
;
; Permission is hereby granted, free of charge, to any person obtaining a copy
; of this software and associated documentation files (the "Software"), to deal
; in the Software without restriction, including without limitation the rights
; to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
; copies of the Software, and to permit persons to whom the Software is
; furnished to do so, subject to the following conditions:
;
; The above copyright notice and this permission notice shall be included in
; all copies or substantial portions of the Software.
;
; THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
; IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
; FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
; AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
; LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
; OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
; SOFTWARE. 

;==========================================================================
; MEMORY MAP
;
; 0480-04FF		Line buffer
; 0500-21FF		Reserved for DOS
; 2200-25FF		Test display
; 2600-2BFF		Library code
;
;==========================================================================

		icl		'hardware.inc'
		icl		'kerneldb.inc'

		opt		o-

		org		$b0
d0		dta		0
d1		dta		0
d2		dta		0
d3		dta		0
d4		dta		0
d5		dta		0
d6		dta		0
d7		dta		0
a0		dta		a(0)
a1		dta		a(0)
a2		dta		a(0)
a3		dta		a(0)

		org		$c0
		
_log_curx	dta		0
_log_curln	dta		a(0)
_log_srcptr	dta		a(0)
_log_lncnt	dta		0

LOGF_PAGING = $80
_log_flags	dta		0

_test_sp		dta		0
_test_exit		dta		0

		.if *>$d4
		.error	'Library zero-page intrudes upon FP region: ',*
		.endif

;=======================================================================

.macro _TEST_ENTRY
.ifdef STANDALONE
		icl		'init.s'
		run		__init
.else
		run		main
.endif		
.endm

;=======================================================================

		org		$2200
		
.ifdef GENLIBRARY
		opt		o+
.else
		opt		o-
.endif
		
_log_dlist:
		:3 dta	$70
		dta		$42,a(_log_display_start)
		dta		$00
		:23 dta	$02
		dta		$41,a(_log_dlist)
		
		org		$2240
_log_display_start:
		dta		"  AcidOS output - Ctrl+A to toggle      "*
_log_display:
		;$2258-25FF
_log_displayend equ $2600

		org		$2600

;=======================================================================
_cpu_mode		dta		0
_opt_wait		dta		0
_opt_waitfail	dta		0
_test_exitfn	dta		a(0)
_test_passed	dta		0
_test_failed	dta		0
_test_skipped	dta		0
_test_testidx	dta		0
_menu_2ndtime	dta		0
_log_visible	dta		$ff
_log_dlsave		dta		a(0)

;=======================================================================
_hexdig	dta		'0123456789ABCDEF'

;=======================================================================
.nowarn .proc _log_keyboardirq
		lda		#>next
		pha
		lda		#<next
		pha
		php
		pha
		jmp		$ffff
chainaddr = *-2

next:
		lda		ch
		cmp		#$bf		;CTRL+A
		bne		not_ctrla
		
		;eat the key
		lda		#$ff
		sta		ch
		
		;toggle display flag
		eor		_log_visible
		sta		_log_visible
		bmi		is_visible
		mwa		_log_dlsave sdlstl
is_visible:
not_ctrla:
		pla
		rti
.endp

;=======================================================================
.nowarn .proc _log_deferred_vbi
		bit		_log_visible
		bpl		dl_ok
		
		lda		sdlstl
		ldx		sdlsth
		cmp		#<_log_dlist
		bne		dl_replaced
		cpx		#>_log_dlist
		beq		dl_ok
dl_replaced:
		sta		_log_dlsave
		stx		_log_dlsave+1
		php
		sei
		lda		#<_log_dlist
		sta		sdlstl
		lda		#>_log_dlist
		sta		sdlsth
		plp
dl_ok:
		jmp		xitvbv
.endp

;=======================================================================
;	A = column
;	X = row
.nowarn .proc _log_gotoxy
		;save new X
		pha
		
		;erase existing cursor
		ldy		_log_curx
		lda		(_log_curln),y
		eor		#$80
		sta		(_log_curln),y
		
		;recompute line addr
		mva		#>[_log_display/2] _log_curln+1
		lda		pos_table,x
		asl
		rol		_log_curln+1
		asl
		rol		_log_curln+1
		sta		_log_curln
		
		;update X and redraw cursor
		pla
		tay
		sty		_log_curx
		lda		(_log_curln),y
		eor		#$80
		sta		(_log_curln),y
		rts
		
pos_table:
		:22 dta [#*40+(<_log_display)]/4
.endp

;=======================================================================
.nowarn .proc _log_cls
		ldy		#0
		sty		_log_lncnt
		tya
clearloop:
		sta		_log_display,y
		sta		_log_displayend-$300,y
		sta		_log_displayend-$200,y
		sta		_log_displayend-$100,y
		iny
		bne		clearloop
		mwa		#_log_display _log_curln
		bne		_log_clearline.xit
.endp

;=======================================================================
.nowarn .proc _log_clearline
		ldy		#39
		lda		#0
		sta:rpl	(_log_curln),y-
xit:
		ldy		#2
		sty		_log_curx
		lda		#$80
		sta		(_log_curln),y
		rts
.endp

;=======================================================================
; Modified:
;	A, Y
;
; Preserved:
;	X
;
; Control codes handled:
;	$7D		clear
;	$9B		end of line
;	$9C		clear line
;
.nowarn .proc _log_putchar
		;check for EOL
		cmp		#$9b
		bne		not_eol
		ldy		_log_curx
		lda		#0
		sta		(_log_curln),y
		beq		wrap
not_eol:
		;check for clear
		cmp		#$7d
		beq		_log_cls
		
		;check for clear line
		cmp		#$9c
		beq		_log_clearline
		
		;convert ATASCII to INTERNAL
		pha
		rol
		rol
		rol
		rol
		and		#$03
		tay
		pla
		eor		conv_tab,y

		ldy		_log_curx
		sta		(_log_curln),y
		iny
		cpy		#40
		bcs		wrap
		sty		_log_curx
done:
		lda		#$80
		sta		(_log_curln),y
		rts
wrap:
		ldy		#2
		sty		_log_curx
		lda		_log_curln
		adc		#39
		sta		_log_curln
		scc:inc	_log_curln+1
		
		lda		_log_curln+1
		cmp		#>_log_displayend
		bne		no_scroll
scroll:
		ldy		#<(_log_display+40)
		mva:rne	_log_display&$ff00,y +(_log_display&$ff00)-40,y+
		mva:rne	$100+(_log_display&$ff00),y $100+(_log_display&$ff00)-40,y+
		mva:rne	$200+(_log_display&$ff00),y $200+(_log_display&$ff00)-40,y+
		mva:rne	$300+(_log_display&$ff00),y $300+(_log_display&$ff00)-40,y+

		mva		#$d8 _log_curln
		dec		_log_curln+1

		jsr		_log_clearline
no_scroll:
		;check if paging is enabled
		bit		_log_flags
		bpl		done
		
		;check if we've done a page
		inc		_log_lncnt
		lda		_log_lncnt
		cmp		#21
		bcc		done
		mva		#0 _log_lncnt
		
		ldy		#9
more_loop:
		lda		more_msg-2,y
		sta		(_log_curln),y
		dey
		cpy		#1
		bne		more_loop
		
		jsr		_waitKey
		jsr		_log_clearline
		jmp		done
		
more_msg:
		dta		"--More--"

conv_tab:
		dta		$40
		dta		$20
		dta		$60
		dta		$00
.endp

;=======================================================================
.nowarn .proc _log_imprint
		pla
		sta		_log_srcptr
		pla
		sta		_log_srcptr+1
print_entry:
		jsr		_log_printm1
		lda		_log_srcptr+1
		pha
		lda		_log_srcptr
		pha
		rts
.endp

;=======================================================================
_log_print = _log_printm1.alt_entry

.nowarn .proc _log_printm1
		ldx		#0
prloop:
		inw		_log_srcptr
prloop1:
		lda		(_log_srcptr,x)
		beq		done
		jsr		_log_putchar
		jmp		prloop
alt_entry:
		ldx		#0
		beq		prloop1
done:
		rts
.endp

;=======================================================================
.nowarn .proc _log_imprintf
		pla
		tax
		pla
		tay
		inx
		sne:iny
		txa
		jsr		_log_printf
		lda		a0+1
		pha
		lda		a0
		pha
		rts	
.endp

;=======================================================================
.nowarn .proc _log_printf
		sta		a0
		sty		a0+1
		ldy		#0
		sty		d0
		
charloop:
		lda		(a0),y
		beq		done
		inw		a0
		cmp		#'%'
		beq		special
escaped:
		jsr		_log_putchar
nextchar:
		ldy		#0
		beq		charloop

done:
		rts

special:
		inc		d0
		ldx		d0
		lda		(a0),y
		inw		a0
		cmp		 #'d'
		bne		notdec
		tya
		sty		a1
		ldy		#6
		sei
		sed
decloop1:
		rol		d0,x
		adc		a1
		sta		a1
		dey
		bne		decloop1
		sty		a1+1
		ldy		#2
decloop2:
		rol		d0,x
		adc		a1
		sta		a1
		rol		a1+1
		dey
		bne		decloop2
		cld
		cli
		lda		a1+1
		beq		decdigit2
		tax
		lda		_hexdig,x
		jsr		putbyte
		lda		a1
		jmp		puthex_nextchar
		
decdigit2:
		lda		a1
		cmp		#$10
		bcc		decdigit1
		jmp		puthex_nextchar
		
decdigit1:
		tax
		lda		_hexdig,x
		jmp		escaped

notdec:
		cmp		#'x'
		bne		nothex
		lda		d0,x
		jmp		puthex_nextchar

nothex:
		cmp		#'X'
		bne		nothexword
		inc		d0
		lda		d1,x
		jsr		puthex
		ldx		d0
		lda		d0-1,x
		jmp		puthex_nextchar

nothexword:
		cmp		 #'D'
		bne		notdecword

		ldy		#8
		lda		#0
		sta		a1
		sta		a1+1
		sta		a2
		sei
		sed
decword1:
		rol		d1,x
		lda		a1
		adc		a1
		sta		a1
		lda		a1+1
		adc		a1+1
		sta		a1+1
		dey
		bne		decword1
	
		ldy		#8
decword2:
		rol		d0,x
		lda		a1
		adc		a1
		sta		a1
		lda		a1+1
		adc		a1+1
		sta		a1+1
		lda		a2
		adc		a2
		sta		a2
		dey
		bne		decword2
		cld
		cli
	
		tax
		beq		decword3
		jsr		puthexcond
		
		lda		a1+1
		jsr		puthex
		lda		a1
		jmp		puthex_nextchar

decword3:
		lda		a1+1
		beq		decword4
		jsr		puthexcond
		lda		a1
puthex_nextchar:
		jsr		puthex
		jmp		nextchar
	
decword4:
		lda		a1
		jsr		puthexcond
		jmp		nextchar

notdecword:
		cmp		 #'c'
		bne		notchar
		lda		d0,x
		jsr		putbyte
strdone:
		jmp		nextchar
	
notchar:
		cmp		 #'s'
		bne		notstr
	
		inc		d0
		lda		d0,x
		sta		a1
		lda		d0+1,x
		sta		a1+1

strloop:
		ldy		#0
		lda		(a1),y
		beq		strdone
		jsr		_log_putchar
		inw		a1
		jmp		strloop
	
notstr:
		cmp		#'f'
		bne		notfloat

		inc		d0
		lda		d0+1,x
		tay
		lda		d0,x
		tax
		jsr		fld0r
		jsr		fasc
		ldx		inbuff
nextfloatchar:
		lda		+(lbuff&$ff00),x
		inx
		pha
		and		#$7f
		jsr		_log_putchar
		pla
		bpl		nextfloatchar
		jmp		nextchar

notfloat:
		dec		d0
		jmp		escaped
	
puthexcond:
		cmp		#$10
		bcs		puthex
		tax
		lda		_hexdig,x
		jmp		putbyte

puthex:	
		pha
		lsr
		lsr
		lsr
		lsr
		tax
		lda		_hexdig,x
		jsr		putbyte
		pla
		and		#$0f
		tax
		lda		_hexdig,x
putbyte:
		tax
		jsr		_log_putchar
		txa
		rts
.endp

;==========================================================================
.nowarn .proc _waitKey
		lda		#$ff
		sta		ch
		sta		ch1
		cmp:req	ch
		rts
.endp

;==========================================================================
.nowarn .proc _waitKeyPrompt
		jsr		_log_imprint
		dta		c"Press a key...",0
		jsr		_waitKey
		jsr		_log_imprint
		dta		$9c,0
		rts
.endp

;==========================================================================
; _load_seg
;
; Module loader.
;
;	X:A = address of filename to load
;
.nowarn .proc	_load_seg
		;open IOCB #1
		sta		icbal+$10
		stx		icbah+$10
		lda		#$04
		sta		icax1+$10
		lda		#CIOCmdOpen
		jsr		do_io
		bmi		other_fail

		;begin relocation
		mwa		#definit runad

relocloop:
		;load starting address
		mwa		#a0 icbal+$10
		jsr		load_two
		bmi		startaddr_fail
		
		;check for $FFFF signature
		lda		a0
		and		a0+1
		cmp		#$ff
		beq		relocloop
		
		;load ending address
		mwa		#a1 icbal+$10
		jsr		load_two
		bmi		other_fail
		
		;compute length and load
		sbw		a1 a0 icbll+$10
		inw		icbll+$10
		mwa		a0 icbal+$10
		jsr		load_bytes
		bmi		other_fail
		
		;init a segment
		mwa		#definit initad
		jsr		doinit
		jmp		relocloop

startaddr_fail:
		cpy		#CIOStatEndOfFile
		bne		other_fail
		ldy		#1
other_fail:
		;save status
		sty		a0
		
		;close IOCB #1
		lda		#CIOCmdClose
		jsr		do_io
		
		;restore status and exit
		ldy		a0
		rts
		
load_two:
		mwa		#2 icbll+$10
load_bytes:
		lda		#CIOCmdGetChars
do_io:
		sta		iccmd+$10
		ldx		#$10
		jmp		ciov

doinit:
		jmp		(initad)
	
definit:
		rts

.endp

;==========================================================================
; _run_seg
;
; Module relocator and executor.
;
; The last segment loaded by _load_seg is relocated and executed.
;
.nowarn .proc _run_seg
		jmp		(runad)
.endp

;=======================================================================
.nowarn .proc _Exec
		jsr		_load_seg
		jmp		_run_seg
.endp

;=======================================================================
.nowarn .proc _ExecMenu
		ldx		#>menu_exe
		lda		#<menu_exe
		jmp		_Exec

menu_exe:
		dta		'D:MENU.EXE',$9B		
.endp

;=======================================================================
.nowarn .proc _RunTests
test_loop:
		;read next test line
		mva		#$80 icbll+$20
		mva		#$00 icblh+$20
		ldx		#$20
		jsr		ciov
		bpl		testOK
		jmp		_ExecMenu
testOK:
		;replace EOL with 0
		ldx		#$ff
		lda		#$9b
eol_loop:
		inx
		cmp		$0480,x
		bne		eol_loop
		lda		#0
		sta		$0480,x

		mwa		#$0482 d1
		jsr		_log_imprintf
		dta		'--- Test %s ---',$9B,'Loading...',0
				
		;store return stack ptr
		tsx
		inx
		inx
		sta		_test_sp
		
		;load segment
		mva		#'D' $0480
		mva		#':' $0481
		ldx		#$04
		lda		#$80
		jsr		_load_seg
		bmi		fail
		
		;clear loading message
		jsr		_log_imprint
		dta		$9c,0
		
		;run segment
		jsr		_run_seg
		jmp		test_loop
		
fail:
		sty		d1
		jsr		_log_imprintf
		dta		'FAILED to load: %x',$9b,0
		jsr		_waitKeyPrompt
		jmp		test_loop
.endp

;=======================================================================
		.if *>$2c00
		.error	'Library too long: ',*,' > $2C00'
		.endif

		opt		o+
