		icl		'library.s'
		icl		'kerneldb.inc'
		icl		'cio.inc'

		_TEST_ENTRY

;==========================================================================
		org		$80
		opt		o-

CMODES	.enum
		MultiJoy8
		Count
		.ende

cmode	dta		0

;==========================================================================
		opt		o+
		org		$2c00

.proc	main
		mva		#0 cmode
		jsr		RedrawScreen
		
poll_loop:
		lda		rtclok+2
		cmp:req	rtclok+2

		jsr		Poll		
		
		jmp		poll_loop
.endp

;==========================================================================
.proc Poll
		ldx		cmode
		lda		disp_hi_table,x
		pha
		lda		disp_lo_table,x
		pha
		rts
		
disp_lo_table:
		dta		<[PollMultiJoy8-1]

disp_hi_table:
		dta		>[PollMultiJoy8-1]
.endp

;==========================================================================
.proc PollMultiJoy8
		;switch to DDRA
		lda		pactl
		and		#$fb
		sta		pactl
		
		;enable bits 4-7 for output
		lda		porta
		ora		#$f0
		sta		porta
		
		;switch to ORA
		lda		pactl
		ora		#$04
		sta		pactl
		
		;select controller
		lda		rtclok+2
		and		#$07
		tay
		asl
		asl
		asl
		asl
		sta		porta
		
		;wait at least 30 cycles
		ldx		#6
		dex:rne
		
		;poll controller
		lda		porta
		and		#$0f
		
		;update screen
		sta		d1
		
		iny
		iny
		iny
		tya
		tax
		lda		#2
		jsr		_log_gotoxy
		jsr		_log_imprintf
		dta		'%x',0

		rts
.endp

;==========================================================================
.proc RedrawScreen
		jsr		_log_imprint
		dta		$7d
		dta		'AcidOS manual controller test'*,$9b
		dta		'Controller mode: '
		dta		0

		ldx		cmode
		mva		cname_lo_tab,x _log_srcptr
		mva		cname_hi_tab,x _log_srcptr+1
		jsr		_log_print
		rts

cname_lo_tab:
		dta		<cname_multijoy8
		
cname_hi_tab:
		dta		>cname_multijoy8
		
cname_multijoy8:
		dta		'MultiJoy8',0
.endp

