		icl		'library.s'
		icl		'kerneldb.inc'
		icl		'cio.inc'

		_TEST_ENTRY

		org		$80
		opt		o-

revcount	dta		0
time0		dta		0
time1		dta		0
time2		dta		0
vcmax		dta		0

		opt		o+

		org		$2c00

.proc	main
		ldx		#156
		lda		pal
		seq:ldx	#131
		stx		vcmax

testloop:
		mva		#16 revcount
		
		jsr		ReadBootSector
		jsr		ReadClock
		sta		time0
		stx		time1
		sty		time2
		
readloop:
		jsr		ReadBootSector
		dec		revcount
		bne		readloop
		
		jsr		ReadClock
		clc
		sbc		time0
		bcs		noframeover
		adc		vcmax
		sec
noframeover:
		sta		time0
		txa
		sbc		time1
		sta		fr0
		tya
		sbc		time2
		sta		fr0+1
		
		;seconds per rev = vcount / (7159090/(8*114) * 16)
		;RPM = (7159090/(8*114) * 16 * 60) / vcount
		jsr		ipf
		jsr		fmove
		
		lda		vcmax
		sta		fr0
		lda		#0
		sta		fr0+1
		jsr		ipf
		jsr		fmul
		jsr		fmove
		
		lda		time0
		sta		fr0
		lda		#0
		sta		fr0+1
		jsr		ipf
		jsr		fadd
		jsr		fmove

		ldx		#<cconst
		ldy		#>cconst
		jsr		fld0r
		jsr		fdiv
		jsr		fasc
		
		mva		#$9c lbuff-1
		
		ldy		#0
xloop:
		lda		(inbuff),y		
		bmi		xloop2
		iny
		bne		xloop
xloop2:
		and		#$7f
		sta		(inbuff),y
		iny
		lda		#0
		sta		(inbuff),y
		
		mwa		#lbuff-1 _log_srcptr
		jsr		_log_print
		
		jmp		testloop
		
cconst:
		.fl		7535884.2105263157894736842105263
.endp

.proc ReadBootSector
		mwa		#1 daux1
		mva		#'R' dcomnd
		mva		#1 dunit
		mwa		#diskbuf dbuflo
		jmp		dskinv
.endp

.proc ReadClock
retry:
		ldx		rtclok+2
		ldy		rtclok+1
		lda		vcount
		cpx		rtclok+2
		bne		retry
		sec
		sbc		#248/2
		beq		retry
		scs:adc	vcmax
no_correct:
		rts
.endp

		org		$3000
diskbuf:
