		icl		'library.s'
		icl		'kerneldb.inc'
		icl		'cio.inc'

		org		$2c00

.proc	main
		lda		_menu_2ndtime
		beq		first_time

		jsr		_waitKeyPrompt

first_time:
		lda		#0
		sta		_test_passed
		sta		_test_failed
		sta		_test_skipped

		;close list file IOCB if it is already open
		ldx		#$20
		lda		#CIOCmdClose
		sta		iccmd,x
		jsr		ciov
		
		;print banner
		jsr		printBanner
		
		;do countdown
		lda		#$ff
		sta		ch
		sta		ch1
		lda		#5
waitloop:
		pha
		sta		d1
		jsr		_log_imprintf
		dta		c"Press key for options... %d",0
		
		;wait for a key for one second
		lda		#50
		ldx		pal
		cpx		#$0f
		sne:lda	#60
		clc
		adc		rtclok+2
waitloop2:
		ldx		ch
		inx
		beq		nokey
		
		mva		#$ff ch
		
		jsr		_log_imprint
		dta		$9c,c"Loading option module...",$9b,0
		
		ldx		#>fname_options
		lda		#<fname_options
		jmp		_Exec
		
nokey:
		cmp		rtclok+2
		bne		waitloop2

		jsr		_log_imprint
		dta		$9c,0
	
		;next second
		pla
		sec
		sbc		#1
		bne		waitloop
		
starttests:
		;check if a button is down
		lda		consol
		and		#7
		cmp		#7
		beq		buttonsup
		
		jsr		_log_imprint
		dta		c"Waiting for console buttons to release.",$9b,$9b,0

waitbtns:
		lda		consol
		and		#7
		cmp		#7
		bne		waitbtns
		
buttonsup:
		;open list file
		mva		#CIOCmdOpen iccmd+$20
		mwa		#testlist_filename icbal+$20
		mva		#$04 icax1+$20
		ldx		#$20
		jsr		ciov
		
		mva		#CIOCmdGetRecord iccmd+$20
		mwa		#$482 icbal+$20

		mva		#1 _menu_2ndtime
		jmp		_RunTests
		
testlist_filename:
		dta		'D:TESTS.TXT',$9B
		
fname_options:
		dta		'D:OPTIONS.EXE',$9b
.endp

;==========================================================================
.proc	printBanner
		jsr		_log_imprint
		dta		$7d
		dta		c"Altirra AcidOS test, V1.1 beta",$9B
		dta		c"Copyright (C) 2013 Avery Lee.",$9B
		dta		c"All Rights Reserved.",$9B,$9B,0

		mwa		memtop d1
		
		lda		_cpu_mode
		asl
		lda		_cpu_mode
		rol

		tax
		mva		cpu_lo_tab,x d3
		mva		cpu_hi_tab,x d3+1
		
		jsr		_log_imprintf
		dta		c"HIMEM: $%X  CPU: %s",$9B,$9B,0
		rts
		
cpu_lo_tab:
		dta		<(str6502)
		dta		<(str65C816_16)
		dta		<(str65C02)
		dta		<(str65C816_24)

cpu_hi_tab:
		dta		>(str6502)
		dta		>(str65C816_16)
		dta		>(str65C02)
		dta		>(str65C816_24)

str6502:
		dta		c"6502",0
str65C02:
		dta		c"65C02",0
str65C816_16:
		dta		c"65C816[16]",0
str65C816_24:
		dta		c"65C816[24]",0
.endp

		run		main
