		icl		'library.s'
		icl		'kerneldb.inc'
		icl		'cio.inc'

		org		$2c00

;==========================================================================
.proc	main
		jsr		_log_imprint
		dta		$7d
		dta		'AcidOS test options'*,$9B
		dta		'M - Manual tests',$9B
		dta		'P - Paged display ['
		dta		0
		
		ldx		#0
		lda		#LOGF_PAGING
		bit		_log_flags
		seq:inx
		
		mva		msg_on_off_lo,x _log_srcptr
		mva		msg_on_off_hi,x _log_srcptr+1
		jsr		_log_print
		
		jsr		_log_imprint
		dta		']',$9B
		dta		'X - Exit and run tests',$9B
		dta		$9B
		dta		0

		jsr		Getchar
		and		#$df
		cmp		#'M'
		bne		not_m
		jsr		ManualTestMenu
		jmp		main
not_m:
		cmp		#'X'
		bne		not_x
		jmp		_ExecMenu
not_x:
		cmp		#'P'
		bne		not_p
		lda		#LOGF_PAGING
		eor		_log_flags
		sta		_log_flags
not_p:
		jmp		main
.endp

;==========================================================================
.proc ManualTestMenu
		jsr		_log_imprint
		dta		$7D
		dta		'AcidOS manual tests'*,$9B
		dta		'C - Controller',$9B
		dta		'D - Disk',$9B
		dta		'X - Exit',$9B
		dta		$9B
		dta		0
		
		jsr		Getchar
		and		#$df
		cmp		#'X'
		bne		not_x
		rts
not_x:
		ldx		#comtab_end-comtab-1
scan_loop:
		cmp		comtab,x
		beq		found_test
		dex
		bpl		scan_loop
		jmp		ManualTestMenu

found_test:
		txa
		pha
		jsr		_log_imprint
		dta		$9B
		dta		'Loading...',$9B
		dta		0

		pla
		tax
		ldy		namlotab,x
		lda		namhitab,x
		tax
		tya
		jmp		_Exec

comtab:
		dta		'C'
		dta		'D'
comtab_end:
		
namlotab:
		dta		<name_controller
		dta		<name_disk
		
namhitab:
		dta		>name_controller
		dta		>name_disk
		
name_controller:
		dta		'D:MCNTROLR.EXE',$9B
		
name_disk:
		dta		'D:MDISK.EXE',$9B
.endp

;==========================================================================
.proc Getchar
		jsr		_log_imprint
		dta		'AcidOS>'
		dta		0
		
		ldx		#$40
		lda		#0
		sta		icbll,x
		sta		icblh,x
		mva		#CIOCmdGetChars iccmd,x
		jsr		ciov
		pha
		jsr		_log_imprint
		dta		$9C,0
		pla
		rts
.endp

;==========================================================================
msg_on_off_lo:
		dta		<msg_off
		dta		<msg_on

msg_on_off_hi:
		dta		>msg_off
		dta		>msg_on

msg_on:
		dta		'ON',0
msg_off:
		dta		'OFF',0

;==========================================================================

;==========================================================================

		run		main
