		icl		'library.s'
		icl		'cio.inc'
		
.macro _ASSERT_YP
		php
		cpy		#0
		bpl		ok
		sty		d1
		jsr		_log_imprintf
		dta		:1,$9B,0
ok:
		plp
.endm

.macro _ASSERT_Y
		php
		cpy		:1
		beq		ok
		sty		d1
		jsr		_log_imprintf
		dta		:2,$9B,0
ok:
		plp
.endm

.macro _ASSERT_P
		bpl		ok
		sty		d1
		jsr		_log_imprintf
		dta		:1,$9B,0
ok:
.endm

.macro _ASSERT_N
		bmi		ok
		sty		d1
		jsr		_log_imprintf
		dta		:1,$9B,0
ok:
.endm

		_TEST_ENTRY
		
		org		$80
		opt		o-
		
		org		$2c00
fnbuf:

		org		$2c10
devid	dta		0
tstatus	dta		0

		opt		o+
		
;==========================================================================
.proc main
		;close IOCB #3, to reset to standard state
		ldx		#$30
		mva		#CIOCmdClose iccmd,x
		jsr		ciov
		
		;close an already closed IOCB
		ldx		#$30
		mva		#CIOCmdClose iccmd,x
		jsr		ciov
		
		_ASSERT_YP 'Reclose status bad: Y=$%x'
		_ASSERT_P 'Reclose failed: N=1'

		;try to find a nonexistent device
		;there are only 12 slots, so we are guaranteed that a letter will
		;be free
		ldy		#'A'
search_loop:
		tya
		jsr		FindDevice
		bne		unused_found
		iny
		bne		search_loop
unused_found:

		;set up filename
		sty		fnbuf
		ldx		#$0f
		lda		#$9B
		sta:rne	fnbuf,x-
		
		;try to open a nonexistent device
		jsr		OpenIO
		
		_ASSERT_Y #CIOStatUnkDevice, 'Bogus open didn''''t fail: Y=$%x'
		_ASSERT_N 'Bogus open didn''''t fail: N=0'
		
		;register device
		lda		#0
		jsr		FindDevice
		beq		found_space
		jsr		_log_imprint
		dta		'HATABS full - skipping device tests.',$9B,0
		rts		
found_space:
		stx		devid
		lda		fnbuf
		sta		hatabs,x
		mwa		#TestDevHandlerTable hatabs+1,x
		
		;try to open the device again
		mva		#1 tstatus
		jsr		OpenIO
		
		_ASSERT_YP 'Test device open failed: Y=$%x'
		_ASSERT_P 'Test device open failed: N=1'
		
		;check that device ID is correct
		ldy		devid
		sty		d2
		_ASSERT_Y ichid+$30, 'IOCB id didn''''t match: $%x!=$%x'
		
		;check that unit #1 was chosen
		ldy		icdno+$30
		_ASSERT_Y #1, 'IOCB device no not 1 for implied: %x'
		
		;try to open again, and verify that we get an IOCB in use error
		jsr		OpenIO
		
		_ASSERT_Y #CIOStatIOCBInUse, 'Open reuse didn''''t fail: Y=%x'
		_ASSERT_N 'Open reuse didn''''t fail: N=0'

		;close the IOCB
		jsr		CloseIO
		
		;check that the handler ID is now $FF
		ldy		ichid+$30
		_ASSERT_Y #$ff, 'IOCB handler was not $FF after close: %x'
		
		;open x2: and check that unit is #2
		lda		#'2'
		sta		fnbuf+1
		jsr		OpenIO
		
		_ASSERT_YP 'T2: open failed: Y=%x'
		ldy		icdno+$30
		_ASSERT_Y #2, 'x2: open produced wrong unit: %x'
		
		jsr		CloseIO
		
		;check that x0: is not valid
		;
		;Note that we don't test x9:, because while it's invalid according
		;to the OS manual, the standard OS allows it.
		;
		lda		#'0'
		sta		fnbuf+1
		jsr		OpenIO
		_ASSERT_YP 'T0: open failed: Y=%x'
		ldy		icdno+$30
		_ASSERT_Y #1, 'x0: open produced wrong unit: %x'
		jsr		CloseIO

		;check that x20: opens x1:
		lda		#'2'
		sta		fnbuf+1
		lda		#'0'
		sta		fnbuf+2
		jsr		OpenIO
		_ASSERT_YP 'x20: open failed: Y=%x'
		ldy		icdno+$30
		_ASSERT_Y #2, 'x20: open produced wrong unit: %x'
		jsr		CloseIO

		;unregister the device
		lda		fnbuf
		jsr		FindDevice
		bne		not_registered
		lda		#0
		sta		hatabs,x
		sta		hatabs+1,x
		sta		hatabs+2,x
not_registered:
		rts
.endp

;==========================================================================
.proc	CloseIO
		lda		#CIOCmdClose
		jmp		DoIO
.endp

;==========================================================================
.proc	OpenIO
		mwa		#fnbuf icbal+$30
		lda		#CIOCmdOpen
		jmp		DoIO
.endp

;==========================================================================
; Inputs:
;	A = CIO command
;
.proc	DoIO
		ldx		#$30
		sta		iccmd,x
		jmp		ciov
.endp

;==========================================================================
.proc FindDevice
		ldx		#11*3
loop:
		cmp		hatabs,x
		beq		found
		dex
		dex
		dex
		bpl		loop
found:
		rts
.endp

;==========================================================================
.proc TestDevHandlerTable
		dta		a(TestDevOpen-1)
		dta		a(TestDevClose-1)
		dta		a(TestDevGetByte-1)
		dta		a(TestDevPutByte-1)
		dta		a(TestDevGetStatus-1)
		dta		a(TestDevSpecial-1)
.endp

;==========================================================================
.proc TestDevOpen
		ldy		tstatus
		rts
.endp

;==========================================================================
.proc TestDevClose
		rts
.endp

;==========================================================================
.proc TestDevGetByte
		rts
.endp

;==========================================================================
.proc TestDevPutByte
		rts
.endp

;==========================================================================
.proc TestDevGetStatus
		rts
.endp

;==========================================================================
.proc TestDevSpecial
		rts
.endp

