		icl		'library.s'
		icl		'cio.inc'

		_TEST_ENTRY
		
		org		$80
		opt		o-
		
scrnmode	dta		0

		org		$2c00
		opt		o-

vecsav:
		.ds		22

		opt		o+
		
.proc main
		;enable fast pot
		sei
		lda		sskctl
		ora		#$07
		sta		sskctl
		sta		skctl
		
		mva		#1 audf1
		mva		#2 audf1
		mva		#4 audf1
		mva		#0 audctl
		sta		stimer
		
		ldx		#21
		mva:rpl	vdslst,x vecsav,x-
		
		mwa		#TimerRoutine vtimr1
		mwa		#TimerRoutine vtimr2
		mwa		#TimerRoutine vtimr4
		mwa		#TimerRoutine vseroc
		mwa		#TimerRoutine vbreak
		
		ldx		#1
		jsr		RunTimerTest
		
		jsr		_log_imprintf
		dta		'Timer#1 IRQ latency: %d cycles',$9b,0
		
		ldx		#2
		jsr		RunTimerTest
		
		jsr		_log_imprintf
		dta		'Timer#2 IRQ latency: %d cycles',$9b,0

		ldx		#4
		jsr		RunTimerTest
		
		jsr		_log_imprintf
		dta		'Timer#4 IRQ latency: %d cycles',$9b,0
		
		ldx		#8
		jsr		RunTimerTest
		
		jsr		_log_imprintf
		dta		'SEROC IRQ latency: %d cycles',$9b,0

		;test BRK
		sei
		
		lda		#125
		cmp:rcs	vcount
		
		sta		wsync
		sta		wsync
		sta		potgo
		brk
post_test:		
		cli
		jsr		_log_imprintf
		dta		'BRK latency: %d cycles',$9b,0
		
		;test VBI stage 1; we can't test stage 2 because it hits POTGO
		inc		critic
		mva		#0 nmien
		lda		#124
		cmp:rcs	vcount
		jsr		dispatch_vbi
		lda		pot4
		sta		d1
		jsr		_log_imprintf
		dta		'VBI stage 1 latency: %d cycles',$9b,0
		dec		critic
				
		;turn NMI back on
		mva		#$40 nmien

		;cleanup

		sei
		ldx		#21
		mva:rpl	vecsav,x vdslst,x-
		cli

		rts
		
dispatch_vbi:
		lda		#>dispatch_vbi_xit
		pha
		lda		#<dispatch_vbi_xit
		pha
		php
		sei
		pha
		pha					;we don't care about preserving A/X/Y
		pha
		sta		potgo
		jmp		(vvblki)
dispatch_vbi_xit:
		rts
.endp

;==========================================================================
.proc RunTimerTest
		sei
		lda		pokmsk
		pha
		stx		pokmsk
		stx		irqen
		
		lda		#125
		cmp:rcs	vcount
		
		sta		wsync
		
		lda		#>post_test
		pha
		lda		#<post_test
		pha
		php
		sta		wsync
		sta		potgo
		jmp		(vimirq)

post_test:
		pla
		sta		pokmsk
		sta		irqen
		
		cli
		rts
.endp

;==========================================================================
.proc TimerRoutine
		lda		pot4
		sta		d1
		pla
		rti
.endp
