		icl		'library.s'
		icl		'cio.inc'

		_TEST_ENTRY
		
		org		$80
		opt		o-
		
		org		$2c00
		opt		o-

_LDFR0	.macro
		jsr		LoadFR0
		.fl		:1
		.endm

_LDFR0X	.macro
		jsr		LoadFR0
		dta		:1,:2,:3,:4,:5,:6
		.endm

_LDFR1	.macro
		jsr		LoadFR1
		.fl		:1
		.endm

_LDSTR	.macro
		jsr		LoadString
		dta		:1,$80
		.endm

_ZFR0	.macro
		jsr		zfr0
		.endm
		
_ZFR1	.macro
		jsr		ZeroFR1
		.endm

_ASFR0	.macro
		jsr		AssertFR0
		.fl		:1
		dta		:2,0
		.endm

_ASFR0_RAW	.macro
		jsr		AssertFR0
		dta		:1,:2,:3,:4,:5,:6
		dta		:7,0
		.endm

_ASERR	.macro
		jsr		AssertERR
		dta		:1,0
		.endm
		
_ASA	.macro
		ldx		#:1
		jsr		AssertA
		dta		:2,0
		.endm

_TEST_FASC	.macro
		jsr		TestFASC
		.fl		:1
		dta		:2,0
		.endm

_FADD	.macro
		jsr		fadd
		.endm
		
_FADD2	.macro
		_LDFR0	:1
		_LDFR1	:2
		_FADD
		.endm

_FSUB	.macro
		jsr		fsub
		.endm
		
_FSUB2	.macro
		_LDFR0	:1
		_LDFR1	:2
		_FSUB
		.endm
		
_FMUL	.macro
		jsr		fmul
		.endm
		
_FMUL2	.macro
		_LDFR0	:1
		_LDFR1	:2
		_FMUL
		.endm

_FDIV	.macro
		jsr		fdiv
		.endm
		
_FDIV2	.macro
		_LDFR0	:1
		_LDFR1	:2
		_FDIV
		.endm
		
_FLOG10	.macro
		jsr		log10
		.endm
		
_FLOG101	.macro
		_LDFR0	:1
		_FLOG10
		.endm

_FEXP10	.macro
		jsr		exp10
		.endm
		
_FEXP101	.macro
		_LDFR0	:1
		_FEXP10
		.endm

_FIFP	.macro
		jsr		ipf
		.endm
		
_FIFP1	.macro
		mwa		#:1 fr0
		_FIFP
		.endm

_FFPI	.macro
		jsr		fpi
		.endm
		
_FFPI1	.macro
		_LDFR0	:1
		_FFPI
		.endm
		
		opt		o+
		
.proc main
		;====================== fadd tests ======================
		_FADD2	0, 0
		_ASFR0	0, '0+0'
		
		_FADD2	0, 1
		_ASFR0	1, '0+1'

		_FADD2	1, 0
		_ASFR0	1, '1+0'
		
		;test difference in magnitudes that still matters
		_FADD2	1, 0.00000001
		_ASFR0	1.00000001, '1+0.00000001'
		
		;test difference in magnitude that doesn't matter (and for which rounding
		;doesn't make a difference)
		_FADD2	1, 1E-10
		_ASFR0	1, '1+1E-10'
						
		;test sign flip
		_FADD2	0.5, -1
		_ASFR0	-0.5, '0.5+-1'
		
		;test carry to higher exponent
		_FADD2	0.99, 0.01
		_ASFR0	1, '0.99+0.01'

		;test borrow to lower exponent
		_FADD2	1, -0.00000001
		_ASFR0	0.99999999, '1+-0.00000001'
		
		;test zero cancellation
		_FADD2	1, -1
		_ASFR0	0, '1+-1'
		
		;test destructive cancellation
		_FADD2	1, -0.99
		_ASFR0	0.01, '1+-0.99'
		
		_FADD2	1.00000001, -1
		_ASFR0	0.00000001, '1.00000001+-1'
		
		;test overflow (>=1E+98)
		_FADD2	9.9E+97, 9.9E+95
		_ASFR0	9.999E+97, '9.9E+97 + 9.9E+95'
		
		_FADD2	9.9E+97, 1E+96
		_ASERR	'9.9E+97 + 1E+96'
		
		;test underflow
		_FADD2	1.000001E-96, -1E-96
		_ASFR0	0, '1.000001E-96 + -1E-96'
		
		;====================== fadd tests ======================
		_FSUB2	0, 0
		_ASFR0	0, '0-0'
		
		_FSUB2	0, -1
		_ASFR0	1, '0-1'

		_FSUB2	1, 0
		_ASFR0	1, '1-0'
		
		;test difference in magnitudes that still matters
		_FSUB2	1, -0.00000001
		_ASFR0	1.00000001, '1--0.00000001'
		
		;test difference in magnitude that doesn't matter (and for which rounding
		;doesn't make a difference)
		_FSUB2	1, -1E-10
		_ASFR0	1, '1+-1E-10'
						
		;test sign flip
		_FSUB2	0.5, 1
		_ASFR0	-0.5, '0.5+1'
		
		;test carry to higher exponent
		_FSUB2	0.99, -0.01
		_ASFR0	1, '0.99+-0.01'

		;test borrow to lower exponent
		_FSUB2	1, 0.00000001
		_ASFR0	0.99999999, '1-0.00000001'
		
		;test zero cancellation
		_FSUB2	1, 1
		_ASFR0	0, '1-1'
		
		;test destructive cancellation
		_FSUB2	1, 0.99
		_ASFR0	0.01, '1-0.99'
		
		_FSUB2	1.00000001, 1
		_ASFR0	0.00000001, '1.00000001-1'
		
		;test overflow (>=1E+98)
		_FSUB2	9.9E+97, -9.9E+95
		_ASFR0	9.999E+97, '9.9E+97 - -9.9E+95'
		
		_FSUB2	9.9E+97, -1E+96
		_ASERR	'9.9E+97 + -1E+96'
		
		;test underflow
		_FSUB2	1.000001E-96, 1E-96
		_ASFR0	0, '1.000001E-96 - 1E-96'

		;====================== fmul tests ======================
		_FMUL2	0, 0
		_ASFR0	0, '0x0'
		
		_FMUL2	0, 1
		_ASFR0	0, '0x1'
		
		_FMUL2	1, 0
		_ASFR0	0, '1x0'
		
		_FMUL2	1, 1
		_ASFR0	1, '1x1'
		
		_FMUL2	1, -1
		_ASFR0	-1, '1x-1'
		
		_FMUL2	-1, 1
		_ASFR0	-1, '-1x1'
		
		_FMUL2	-1, -1
		_ASFR0	1, '-1x-1'
		
		_FMUL2	0.01, 0.01
		_ASFR0	0.0001, '0.01x0.01'

		_FMUL2	12.34567891, 1
		_ASFR0	12.34567891, '12.34567891x1'
		
		_FMUL2	1.2345, 6.7890
		_ASFR0	8.3810205, '1.2345x6.7890'
		
		_FMUL2	0.99, 0.99
		_ASFR0	0.9801, '0.99x0.99'
		
		;test overflow
		_FMUL2	1e+90, 1e+90
		_ASERR	'1e+90x1e+90'
		
		_FMUL2	1e+90, -1e+90
		_ASERR	'1e+90x-1e+90'

		_FMUL2	-1e+90, 1e+90
		_ASERR	'-1e+90x1e+90'

		_FMUL2	-1e+90, -1e+90
		_ASERR	'-1e+90x-1e+90'

		;Test underflow
		;
		;There is arguably a bug in the base OS where multiplying two numbers
		;where the composite byte exponent is below -65 results in an error
		;even though it is an underflow. For this reason, we avoid using such
		;tiny numbers and use ones big enough to cause underflow without an
		;error.
		
		_FMUL2	1e-64, 1e-64
		_ASFR0	0, '1e-64x1e-64'
		
		_FMUL2	1e-64, -1e-64
		_ASFR0	0, '1e-64x-1e-64'

		_FMUL2	-1e-64, 1e-64
		_ASFR0	0, '-1e-64x1e-64'

		_FMUL2	-1e-64, -1e-64
		_ASFR0	0, '-1e-64x-1e-64'

		;====================== fdiv tests ======================
		_FDIV2	1, 1
		_ASFR0	1, '1/1'
		
		_FDIV2	0, 1
		_ASFR0	0, '0/1'
				
		_FDIV2	1, -1
		_ASFR0	-1, '1/-1'

		_FDIV2	1, 2
		_ASFR0	0.5, '1/2'
		
		_FDIV2	2, 0.5
		_ASFR0	4, '2/0.5'
		
		_FDIV2	100, 0.01
		_ASFR0	10000, '100/0.01'
		
		;test overflow
		_FDIV2	1e+90, 1e-90
		_ASERR	'1e+90/1e-90'
		
		;Test underflow
		;
		;1E-64
		_FDIV2	1e-64, 1e+64
		_ASFR0	0, '1e-64/1e+64'

		_FDIV2	1e-64, -1e+64
		_ASFR0	0, '1e-64/-1e+64'

		_FDIV2	-1e-64, 1e+64
		_ASFR0	0, '-1e-64/1e+64'

		_FDIV2	-1e-64, -1e+64
		_ASFR0	0, '-1e-64/-1e+64'

		;====================== log10 tests ======================
		_FLOG101	10
		_ASFR0	1, 'log10(10)'

		_FLOG101	100
		_ASFR0	2, 'log10(100)'

		;====================== ipf tests ======================
		_FIFP1	0
		clc
		_ASFR0	0, 'ipf(0)'

		_FIFP1	65535
		clc
		_ASFR0	65535, 'ipf(65535)'
		
		;====================== fpi tests ======================
		_FFPI1	0
		_FIFP
		_ASFR0	0, 'fpi(0)'

		_FFPI1	0.1
		_FIFP
		_ASFR0	0, 'fpi(0.1)'

		; >= 0.5 causes rounding up		
		_FFPI1	0.5
		_FIFP
		_ASFR0	1, 'fpi(0.5)'
		
		_FFPI1	0.9
		_FIFP
		_ASFR0	1, 'fpi(0.9)'

		_FFPI1	76
		_FIFP
		_ASFR0	76, 'fpi(76)'

		_FFPI1	1234
		_FIFP
		_ASFR0	1234, 'fpi(1234)'
		
		_FFPI1	21420
		_FIFP
		_ASFR0	21420, 'fpi(21420)'
		
		_FFPI1	65535.4
		_FIFP
		_ASFR0	65535, 'fpi(65535.4)'
				
		; negative number -- should fail
		_FFPI1	-0.1
		_ASERR	'fpi(-0.1)'
		
		; Atari precisely specified in its OS Manual that FPI is supposed to
		; give an error for FR0 >= 65535.5. That assumes their implementation
		; actually follows the spec, which it doesn't -- it gives 0 for values
		; between 65535.5 and 65536.
		_FFPI1	65536
		_ASERR	'fpi(65536)'

		_FFPI1	1000000
		_ASERR	'fpi(100000)'
		
		;====================== fasc tests ======================
		_TEST_FASC	0, '0'
		_TEST_FASC	0.1, '0.1'
		_TEST_FASC	0.01, '0.01'
		_TEST_FASC	0.001, '1.0E-03'
		_TEST_FASC	0.0001, '1E-04'
		_TEST_FASC	0.00001, '1.0E-05'
		_TEST_FASC	0.000001, '1E-06'
		_TEST_FASC	1, '1'
		_TEST_FASC	10, '10'
		_TEST_FASC	100, '100'
		_TEST_FASC	1000, '1000'
		_TEST_FASC	10000, '10000'
		_TEST_FASC	100000, '100000'
		_TEST_FASC	1000000, '1000000'
		_TEST_FASC	10000000, '10000000'
		_TEST_FASC	100000000, '100000000'
		_TEST_FASC	1000000000, '1000000000'
		_TEST_FASC	10000000000, '1E+10'
		
		;test decimals
		_TEST_FASC	1.1, '1.1'
		_TEST_FASC	1.12, '1.12'
		_TEST_FASC	1.123, '1.123'
		_TEST_FASC	1.1234, '1.1234'
		
		;test negatives
		_TEST_FASC	-1, '-1'
		
		;test full conversion precision, non-exponential
		_TEST_FASC	12.34567812, '12.34567812'
		
		;test full conversion precision, exponential
		_TEST_FASC	-0.001234567812, '-1.234567812E-03'
		_TEST_FASC	-0.0001234567812, '-1.23456781E-04'
		_TEST_FASC	-0.00001234567812, '-1.234567812E-05'
		_TEST_FASC	-0.000001234567812, '-1.23456781E-06'

		_TEST_FASC	-12345678100, '-1.23456781E+10'
		_TEST_FASC	-123456781200, '-1.234567812E+11'
		_TEST_FASC	-1234567810000, '-1.23456781E+12'
		_TEST_FASC	-12345678120000, '-1.234567812E+13'
		
		;====================== afp tests ======================
		mwa		#afp_test1 inbuff
		mva		#0 cix
		_ZFR0
		jsr		afp
		_ASERR	'afp("")'
		
		_LDSTR	'0'
		jsr		afp
		_ASFR0	0, 'afp("0")'
		lda		cix
		_ASA	2, 'afp("0")-CIX'
		
		mwa		#afp_test2 inbuff
		mva		#0 cix
		_ZFR0
		jsr		afp
		_ASFR0	100, 'afp("100")'
		lda		cix
		_ASA	3, 'afp("100")-CIX'

		mwa		#afp_test3 inbuff
		mva		#0 cix
		_ZFR0
		jsr		afp
		_ASFR0	100, 'afp(" 100")'
		lda		cix
		_ASA	4, 'afp(" 100")-CIX'

		mwa		#afp_test4 inbuff
		mva		#0 cix
		_ZFR0
		jsr		afp
		_ASFR0	-20, 'afp("-20 100")'
		lda		cix
		_ASA	3, 'afp("-20 100")-CIX'

		mwa		#afp_test4 inbuff
		mva		#4 cix
		_ZFR0
		jsr		afp
		_ASFR0	100, 'afp("-20 100") #2'
		lda		cix
		_ASA	7, 'afp("-20 100")-CIX #2'

		mwa		#afp_test5 inbuff
		mva		#0 cix
		_ZFR0
		jsr		afp
		_ASFR0	100, 'afp("0100")'
		lda		cix
		_ASA	4, 'afp("0100")-CIX'
		
		;leading spaces are allowed and consumed
		_LDSTR	'  945'
		jsr		afp
		_ASFR0	945, 'afp("  945")'
		lda		cix
		_ASA	6, 'afp("  945")-CIX'
		
		;leading period is allowed and consumed
		_LDSTR	'.130'
		jsr		afp
		_ASFR0	0.130, 'afp(".130")'
		lda		cix
		_ASA	5, 'afp(".130")-CIX'
		
		;trailing period is allowed and consumed
		_LDSTR	'123.'
		jsr		afp
		_ASFR0	123, 'afp("123.")'
		lda		cix
		_ASA	5, 'afp("123.")-CIX'

		;a second trailing period is allowed but not consumed
		_LDSTR	'123..'
		jsr		afp
		_ASFR0	123, 'afp("123..")'
		lda		cix
		_ASA	5, 'afp("123..")-CIX'

		;leading plus is allowed and consumed
		_LDSTR	'+12'
		jsr		afp
		_ASFR0	12, 'afp("+12")'
		lda		cix
		_ASA	4, 'afp("+12")-CIX'
		
		;a single sign is not allowed and is an error
		_LDSTR	'-'
		jsr		afp
		_ASERR	'afp("-")'

		_LDSTR	'+'
		jsr		afp
		_ASERR	'afp("+")'
		
		;repeated signs are not allowed
		_LDSTR	'--'
		jsr		afp
		_ASERR	'afp("--")'

		_LDSTR	'++'
		jsr		afp
		_ASERR	'afp("++")'
		
		;spaces are not allowed after a sign
		_LDSTR	'+ 1'
		jsr		afp
		_ASERR	'afp("+ 1")'

		_LDSTR	'0E+02'
		jsr		afp
		_ASFR0	0, 'afp("0E+02")'
		lda		cix
		_ASA	6, 'afp("0E+02")-CIX'
		
		;100.45E+02 should convert as 1.2345E+04
		_LDSTR	'123.45E+02'
		jsr		afp
		_ASFR0	1.2345E+04, 'afp("123.45E+02")'
		
		;10^97 is not an overflow
		mwa		#afp_test6 inbuff
		mva		#0 cix
		jsr		afp
		_ASFR0	1E+97, 'afp("1E+97")'
		
		;10^98 or higher is an overflow
		mwa		#afp_test6a inbuff
		mva		#0 cix
		jsr		afp
		_ASERR	'afp("1E+98")'
		
		;9.9999E+97 is not an overflow
		_LDSTR	'9.999E97'
		jsr		afp
		_ASFR0	9.999E+97, 'afp("9.999E97")'
		
		;99.99E+97 is an overflow, however, because it renormalizes to >=10^98
		_LDSTR	'99.99E97'
		jsr		afp
		_ASERR	'afp("99.99E97")'
		
		;100E+96 is also an overflow
		_LDSTR	'100E96'
		jsr		afp
		_ASERR	'afp("100E96")'
		
		;check if AFP can renormalize up
		_LDSTR	'0.0123456E+06'
		jsr		afp
		_ASFR0	1.23456E+04, 'afp("0.0123456E+06")'
		
		;check for silly levels of normalization (need to use RAW for this because of
		;.FL encoding bugs in MADS 1.9.8b5):
		_LDSTR	'0.000000001234567890'
		jsr		afp
		;_ASFR0	1.23456789E-09, 'afp("0.000000001234567890")'
		_ASFR0_RAW	$3B,$12,$34,$56,$78,$90, 'afp("0.000000001234567890")'
		
		_LDSTR	'0.0000000001234567890'
		jsr		afp
		;_ASFR0	1.23456789E-10, 'afp("0.0000000001234567890")'
		_ASFR0_RAW	$3B,$01,$23,$45,$67,$89, 'afp("0.0000000001234567890")'
		
		_LDSTR	'0.0000000012345678E-06'
		jsr		afp
		_ASFR0	1.2345678E-15, 'afp("0.0000000012345678E-06")'
		
		_LDSTR	'000012345678900000000000E-19'
		jsr		afp
		_ASFR0	1.234567890, 'afp("000012345678900000000000E-19")'

		;test precision -- note that only nine digits are converted even though in some
		;cases we could accommodate 10; we avoid testing the tenth digit because we don't
		;want to penalize a math pack that can preserve it
		_LDSTR	'1234567890'
		jsr		afp
		_ASFR0	1234567890, 'afp("1234567890")'
		
		_LDSTR	'1234567.890'
		jsr		afp
		_ASFR0	1234567.89, 'afp("1234567.891")'
		
		;two periods are not allowed, but are not an error
		_LDSTR	'1.234.567'
		jsr		afp
		_ASFR0	1.234, 'afp("1.234.567")'
		lda		cix
		_ASA	6, 'afp("1.234.567")-CIX'
		
		;AFP does *not* take a lowercase e!
		mwa		#afp_test7 inbuff
		mva		#0 cix
		jsr		afp
		_ASFR0	1, 'afp("1e+97")'
		
		;'+' is optional
		mwa		#afp_test8 inbuff
		mva		#0 cix
		jsr		afp
		_ASFR0	1E+97, 'afp("1E97")'
		
		;digit or sign is required after E -- if missing, conversion stops at the E
		_LDSTR	'1E',$80
		jsr		afp
		_ASFR0	1,'afp("1E")'
		lda		cix
		_ASA	2,'afp("1E")-CIX'
		
		;AFP can even back up two chars if there is a sign, too
		_LDSTR	'5E-',$80
		jsr		afp
		_ASFR0	5,'afp("5E-")'
		lda		cix
		_ASA	2,'afp("5E-")-CIX'
		
		;there needs to be at least one digit before exponent
		_LDSTR	'E+08',$80
		jsr		afp
		_ASERR	'afp("E+08")'
		
		_LDSTR	'-E+08',$80
		jsr		afp
		_ASERR	'afp("-E+08")'
		
		;check underflow cases
		mwa		#afp_test9 inbuff
		mva		#0 cix
		jsr		afp
		_ASFR0	0, 'afp("1E-99")'
	
		_LDSTR	'0.000001E-99'
		jsr		afp
		_ASFR0	0, 'afp("0.000001E-99")'
		
		;stock OS fails this test :P
		;_LDSTR	'0.0000000000000000000000000000001E-99'
		;jsr		afp
		;_ASFR0	0, 'afp("0.0000000000000000000000000000001E-99")'

		;AFP only takes two exponent digits max, which causes it to
		;miss underflow/overflow cases
		mwa		#afp_test10 inbuff
		mva		#0 cix
		jsr		afp
		_ASFR0	1E-20, 'afp("1E-205")'
		lda		cix
		_ASA	5, 'afp("1E-205")-CIX'

		mwa		#afp_test11 inbuff
		mva		#0 cix
		jsr		afp
		_ASFR0	1E+20, 'afp("1E+205")'
		
		;leading zeroes don't count
		_LDSTR	'1E+011'
		jsr		afp
		_ASFR0	10, 'afp("1E+011")'
		lda		cix
		_ASA	6, 'afp("1E+011")-CIX'
		
		;zero is not a valid exponent
		_LDSTR	'1E+001'
		jsr		afp
		_ASFR0	1, 'afp("1E+001")'
		lda		cix
		_ASA	2, 'afp("1E+001")-CIX'

		_LDSTR	'1E+0x'
		jsr		afp
		_ASFR0	1, 'afp("1E+0x")'
		lda		cix
		_ASA	2, 'afp("1E+0x")-CIX'
		
		;all done!
		rts
		
afp_test4:
		dta		'-20'
afp_test3:
		dta		' '
afp_test2:
		dta		'100'
afp_test1:
		dta		$80
		
afp_test5:
		dta		'0100',$80
		
afp_test6:
		dta		'1E+97',$80

afp_test6a:
		dta		'1E+98',$80
		
afp_test7:
		dta		'1e+97',$80

afp_test8:
		dta		'1E97',$80

afp_test9:
		dta		'1E-99',$80

afp_test10:
		dta		'1E-205',$80

afp_test11:
		dta		'1E+205',$80
.endp

;==========================================================================
.proc LoadLR
		tsx
		lda		$0103,x
		clc
		adc		#1
		sta		flptr
		lda		$0104,x
		adc		#0
		sta		flptr+1
		rts
.endp

;==========================================================================
.proc AddLR_6
		lda		flptr
		clc
		adc		#6
		sta		flptr
		scc:inc	flptr+1
		rts
.endp

;==========================================================================
.proc LoadFR0
		jsr		LoadLR
		jsr		fld0p
		
		;workaround for MADS zero bug
		lda		fr0+1
		sne:jsr	zfr0
		
		jsr		AddLR_6
		pla
		pla
		jmp		(flptr)
.endp

;==========================================================================
.proc LoadFR1
		jsr		LoadLR
		jsr		fld1p

		;workaround for MADS zero bug
		lda		fr1+1
		bne		not_zero
		ldx		#fr1
		jsr		zf1
not_zero:

		jsr		AddLR_6
		pla
		pla
		jmp		(flptr)
.endp

;==========================================================================
.proc ZeroFR1
		ldx		#fr1
		jmp		zf1
.endp

;==========================================================================
.proc LoadString
		pla
		sta		inbuff
		pla
		sta		inbuff+1
		mva		#1 cix
		
		ldy		#0
skip_loop:
		iny
		lda		(inbuff),y
		bpl		skip_loop
		
		tya
		clc
		adc		inbuff
		tay
		lda		inbuff+1
		adc		#0
		pha
		tya
		pha
		rts
.endp

;==========================================================================
.proc fcomp
		lda		fr0
		beq		fr0_or_fr1_zero
		ldx		fr1
		beq		fr0_or_fr1_zero

		;compare exponents
		lda		fr1
		cmp		fr0
		beq		exp_equal
		
		;check for sign difference
		php
		lda		fr0
		eor		fr1
		bmi		exp_xit
		
		;check for negative sign
		lda		fr0
		bmi		exp_xit
		
		;invert comparison
		plp
		lda		fr0
		cmp		fr1
		rts
		
exp_xit:
		plp
		rts

exp_equal:
		;compare mantissas
		ldx		#<-5
mant_loop:
		lda		fr0+6,x
		cmp		fr1+6,x
		bne		xit
		inx
		bne		mant_loop
		rts

fr0_or_fr1_zero:
		cmp		fr1+1
xit:
		rts
.endp

;==========================================================================
.proc AssertFR0
		php
		pla
		sta		d5
		cld
		jsr		LoadLR
		jsr		fld1p
		jsr		AddLR_6
		mwa		flptr d1
		
		lda		d5
		and		#$08
		beq		dec_ok
		
		jsr		_log_imprintf
		dta		'Decimal mode left on: %s',$9B,0
		
dec_ok:
		lsr		d5
		bcc		no_err
		
		jsr		_log_imprintf
		dta		'%s failed: val=%f',$9B,0
		
no_err:
		jsr		fcomp
		beq		pass
fail:
		mwa		#fr0 d3
		lda		flptr
		
		jsr		_log_imprintf
		dta		'%s mismatch: val=%f',$9B,0
		
pass:
		;skip past message
		ldy		#0
skip_loop:
		lda		(d1),y
		inw		d1
		tax
		bne		skip_loop
		pla
		pla
		jmp		(d1)
.endp

;==========================================================================
.proc AssertERR
		php
		pla
		sta		d5
		jsr		LoadLR
		mwa		flptr d1
		
		lda		d5
		and		#$08
		beq		dec_ok
		
		jsr		_log_imprintf
		dta		'Decimal mode left on: %s',$9B,0
		
dec_ok:
		lsr		d5
		bcs		AssertFR0.pass
		
		mwa		#fr0 d3
		
		jsr		_log_imprintf
		dta		'%s didn''t fail: FR0=%f',$9B,0
		
		jmp		AssertFR0.pass
.endp

;==========================================================================
.proc AssertA
		sta		d3
		stx		d4
		jsr		LoadLR
		mwa		flptr d1

		lda		d3
		cmp		d4		
		beq		pass
		
		jsr		_log_imprintf
		dta		'%s mismatch: A=%d, != %d',$9B,0
		
pass:
		jmp		AssertFR0.pass
.endp

;==========================================================================
.proc TestFASC
		jsr		LoadLR
		jsr		fld0p
		jsr		fasc
		
		jsr		LoadLR
		jsr		AddLR_6
		
		mwa		inbuff d1
		mwa		flptr d3

		;convert hibit-terminated output to zero-terminated		
		ldy		#$ff
fix_loop:
		iny
		lda		(inbuff),y
		bpl		fix_loop
		and		#$7f
		sta		(inbuff),y
		iny
		lda		#0
		sta		(inbuff),y

		;compare strings
strcmp_loop:
		lda		(flptr),y
		cmp		(inbuff),y
		bne		fail
		dey
		cpy		#$ff
		bne		strcmp_loop		
xit:
		ldy		#$ff
skip_loop:
		iny
		lda		(flptr),y
		bne		skip_loop
		
		tya
		sec
		adc		flptr
		sta		flptr
		scc:inc	flptr+1
		pla
		pla
		jmp		(flptr)

fail:
		jsr		_log_imprintf
		dta		'FASC mismatch: [%s] != [%s]',$9b,0
		jmp		xit
.endp