; Altirra Acid800 test suite
; Copyright (C) 2010 Avery Lee, All Rights Reserved.
;
; Permission is hereby granted, free of charge, to any person obtaining a copy
; of this software and associated documentation files (the "Software"), to deal
; in the Software without restriction, including without limitation the rights
; to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
; copies of the Software, and to permit persons to whom the Software is
; furnished to do so, subject to the following conditions:
;
; The above copyright notice and this permission notice shall be included in
; all copies or substantial portions of the Software.
;
; THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
; IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
; FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
; AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
; LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
; OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
; SOFTWARE. 

	.ifndef SAPBOOTER
	opt		h-o+
	dta		c'SAP',13,10
	dta		c'AUTHOR "Avery Lee"',13,10
	dta		c'NAME "AcidSAP full test suite"',13,10
	dta		c'TYPE D',13,10
	dta		c'INIT 2000',13,10
	dta		c'TIME 01:00',13,10
	.endif

;=========================================================================
	opt		h+o+
	
	org		$2000
__init:
	jmp		_boot
	
	org		$4000

	GENLIBRARY = 1

	icl		'library.s'
	icl		'options.s'

;=========================================================================
.def ?module_count = 0

.macro _MODULELABEL1
	.def mod_:1 = *
.endm

.macro _MODULELABEL
	;workaround for annoying MADS bug where MACRO and REPT parameters don't nest properly
	.rept :1+1
	.if # == :1
		_MODULELABEL1 #
	.endif
	.endr
.endm

.macro _MODULE
	_MODULELABEL ?module_count

	ins	:1
	.def :?module_count = :?module_count + 1
.endm

	_MODULE 'cpu_flags.obx'
	_MODULE 'cpu_decimal.obx'
	_MODULE 'cpu_timing.obx'
	_MODULE 'cpu_bugs.obx'
	_MODULE 'cpu_clisei.obx'
	_MODULE 'cpu_illegal.obx'
	_MODULE 'antic_vcount.obx'
	_MODULE 'antic_wsync.obx'
	_MODULE 'antic_addrmirror.obx'
	_MODULE 'pokey_default.obx'
	_MODULE 'pokey_noise.obx'
	_MODULE 'pokey_irqtiming.obx'
	_MODULE 'pokey_timergranularity.obx'
	_MODULE 'pokey_twotone.obx'
	_MODULE 'pokey_seroc.obx'
	_MODULE 'pokey_timerirq.obx'
	_MODULE 'pokey_asyncrecv.obx'
	_MODULE 'pokey_addrmirror.obx'
modules_end:

;=========================================================================
.proc _boot
		sei
		ldx		#$ff
		txs
		jsr		_crt0init
		cli

testloop:
		lda		#60
		
		ldx		#2
		jsr		_sys_beepplay
	
		ldx		testidx
		inc		testidx
		mwa		#testnext _exitTest
		jsr		runtest
		
		;all done -- announce pass or fail
		lda		failed
		beq		nofails
		jsr		_sys_beepfailure
		jmp		_jam
nofails:
		jsr		_sys_beepsuccess
		jmp		_jam

testnext:
		bpl		notfail
		
		;test was failed
		inc		failed
		jmp		testloop
notfail:
		beq		waspass
		
		;test was skipped
		inc		skipped
		jmp		testloop
		
waspass:
		;test was passed
		inc		passed
		jmp		testloop

runtest:
		;check if this test exists
		lda		segaddrlo+1,x
		ora		segaddrhi+1,x
		sne:rts
		
		;test is OK
		txa
		pha
				
		;store return stack ptr
		tsx
		inx
		inx
		sta		_exitTestS
		
		;load and run segment
		pla
		tax
		jsr		_loadSeg
		jmp		_runSeg
.endp

;=========================================================================
.macro _MODULEADDRLO
	dta <(mod_:1)
.endm	

		org		segaddrlo
		:?module_count _MODULEADDRLO #
		dta		<modules_end
		dta		$00

;=========================================================================
.macro _MODULEADDRHI
	dta >(mod_:1)
.endm	

		org		segaddrhi
		:?module_count _MODULEADDRHI #
		dta		>modules_end
		dta		$00

;=========================================================================
		.ifdef SAPBOOTER
		run		__init
		.endif
