; Altirra Acid800 test suite
; Copyright (C) 2010 Avery Lee, All Rights Reserved.
;
; Permission is hereby granted, free of charge, to any person obtaining a copy
; of this software and associated documentation files (the "Software"), to deal
; in the Software without restriction, including without limitation the rights
; to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
; copies of the Software, and to permit persons to whom the Software is
; furnished to do so, subject to the following conditions:
;
; The above copyright notice and this permission notice shall be included in
; all copies or substantial portions of the Software.
;
; THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
; IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
; FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
; AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
; LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
; OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
; SOFTWARE. 

;==========================================================================
_disp_adr		equ		$e0
_disp_buffer	equ		$1000

;==========================================================================
.nowarn .proc _crt0init_sap
	sei

	.ifdef SAPBOOTER
	;We're coming in hot from the Atari OS, so we need to shut everything down.
	lda		#0
	sta		nmien
	sta		irqen
	sta		pokmsk
	sta		dmactl

	;bank out all ROMs
	mva		#$38 pbctl
	mva		#$ff portb
	mva		#$3c pbctl
	mva		#$82 portb
	.endif
	
	;revector NMI and IRQ (NMI is just in case)
	mwa		#_sys_nmi $fffa
	mwa		#_sys_irq1 $fffe
	mwa		#_sys_irq2 vimirq

	;re-enable interrupts
	cli

	jmp		_disp_init
.endp

;==========================================================================
.nowarn .proc _sys_nmi
	;there should not be any NMIs when we are running under SAP
	sta		nmires
	rti
.endp

;==========================================================================
.nowarn .proc _sys_irq1
	cld
	jmp		(vimirq)
.endp

;==========================================================================
.nowarn .proc _sys_irq2
	pha
	mva		#0 irqen
	mva		pokmsk irqen
	pla
	rti
.endp

;==========================================================================
.nowarn .proc _disp_init
	mwa		#_disp_buffer _disp_adr
	mwa		#_disp_putchar _vputchar
	rts
.endp

;==========================================================================
.nowarn .proc _disp_putchar
	ldy		#0
	sta		(_disp_adr),y
	inc		_disp_adr
	seq:rts
	lda		_disp_adr+1
	clc
	adc		#1
	and		#$f7
	sta		_disp_adr+1
	rts
.endp

;==========================================================================
.nowarn .proc _sys_beepsuccess
	lda		#21
	
	ldx		#13
	jsr		_sys_beepplay
	
	ldx		#2
	jsr		_sys_beepwait
	
	ldx		#5
	jsr		_sys_beepplay
	
	ldx		#2
	jsr		_sys_beepwait
	
	ldx		#5
	jsr		_sys_beepplay
	
	ldx		#7
	jsr		_sys_beepwait
	
	ldx		#30
	jmp		_sys_beepplay
.endp

;==========================================================================
.nowarn .proc _sys_beepfailure
	lda		#255
	
	ldx		#100
	jmp		_sys_beepplay
.endp

;==========================================================================
; A = pitch
; X = duration
.nowarn .proc _sys_beepplay
	pha
	sta		audf1
	mvy		#$ac audc1
	sta		stimer
	mva		#$03 skctl
	mva		#$01 audctl
loop:
	pha
	jsr		_waitFrame
	pla
	cpy		#$a1
	beq		nodescent
	clc
	adc		#$20
	bcc		nodescent
	dey
	sty		audc1
nodescent:
	dex
	bne		loop
	mva		#$ff audf1
	mva		#0 audc1
	pla
	rts
.endp

;==========================================================================
; X = duration
.nowarn .proc _sys_beepwait
	pha
loop:
	jsr		_waitFrame
	dex
	bne		loop
	pla
	rts
.endp

;==========================================================================
.ifdef STANDALONE
.nowarn .proc _sap_testEnd
	bpl		passed
	jsr		_sys_beepfailure
	jmp		_jam
passed:
	jsr		_sys_beepsuccess
	jmp		_jam
.endp
.endif
