//	Altirra - Atari 800/800XL/5200 emulator
//	Copyright (C) 2008-2015 Avery Lee
//	Debugger module - target access interface
//
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef f_AT_ATDEBUGGER_TARGET_H
#define f_AT_ATDEBUGGER_TARGET_H

struct ATCPUExecState;

enum ATDebugDisasmMode : uint8 {
	kATDebugDisasmMode_6502,
	kATDebugDisasmMode_65C02,
	kATDebugDisasmMode_65C816
};

class IATDebugTarget {
public:
	virtual const char *GetName() = 0;
	virtual ATDebugDisasmMode GetDisasmMode() = 0;

	virtual void GetExecState(ATCPUExecState& state) = 0;
	virtual void SetExecState(const ATCPUExecState& state) = 0;

	virtual uint8 ReadByte(uint32 address) = 0;
	virtual void ReadMemory(uint32 address, void *dst, uint32 n) = 0;

	virtual uint8 DebugReadByte(uint32 address) = 0;
	virtual void DebugReadMemory(uint32 address, void *dst, uint32 n) = 0;

	virtual void WriteByte(uint32 address, uint8 value) = 0;
	virtual void WriteMemory(uint32 address, const void *src, uint32 n) = 0;
};

class IATDeviceDebugTarget {
public:
	enum { kTypeID = 'addt' };

	virtual IATDebugTarget *GetDebugTarget(uint32 index) = 0;
};

#endif
