//	Altirra - Atari 800/800XL/5200 emulator
//	Copyright (C) 2008-2015 Avery Lee
//
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "stdafx.h"
#include "antic.h"
#include "cpu.h"

#define AT_ANTIC_GENERIC_CYCLE							\
	ATSCHEDULER_ADVANCE(&scheduler);					\
	fetchMode = PreAdvance();							\
														\
	if (!((fetchMode | (uint8)mbWSYNCActive) & 1))		\
		cpu.Advance6502();								\
														\
	PostAdvance(fetchMode);								\
														\
	if (flag)											\
		return;

#define AT_ANTIC_CYCLE_0x00(cyc)						\
	mX = cyc;											\
	if (mDMAPattern[cyc] != 0x00) return;				\
	if (!mbWSYNCActive)									\
		cpu.Advance6502();								\
	PostAdvance(0);										\
	if (flag)											\
		return;

#define AT_ANTIC_CYCLE_0x01(cyc)						\
	mX = cyc;											\
	if (mDMAPattern[cyc] != 0x01) return;				\
	PostAdvance(0x01);									\
	if (flag)											\
		return;

#define AT_ANTIC_CYCLE_0x05(cyc)						\
	mX = cyc;											\
	if (mDMAPattern[cyc] != 0x05) return;				\
	PostAdvance(0x05);									\
	if (flag)											\
		return;

#define AT_ANTIC_CYCLE_0x80(cyc)						\
	mX = cyc;											\
	if (mDMAPattern[cyc] != 0x80) return;				\
	fetchMode = AdvanceSpecial();						\
	if (!((fetchMode | (uint8)mbWSYNCActive) & 1))		\
		cpu.Advance6502();								\
	PostAdvance(fetchMode);								\
	if (flag)											\
		return;

void ATAnticEmulator::RunScanlineFastGeneric(ATScheduler& scheduler, ATCPUEmulator& cpu, ATSimulatorEvent& flag) {
	uint8 fetchMode;

	switch(mX) {
		case   0:	AT_ANTIC_GENERIC_CYCLE
		case   1:	AT_ANTIC_GENERIC_CYCLE
		case   2:	AT_ANTIC_GENERIC_CYCLE
		case   3:	AT_ANTIC_GENERIC_CYCLE
		case   4:	AT_ANTIC_GENERIC_CYCLE
		case   5:	AT_ANTIC_GENERIC_CYCLE
		case   6:	AT_ANTIC_GENERIC_CYCLE
		case   7:	AT_ANTIC_GENERIC_CYCLE
		case   8:	AT_ANTIC_GENERIC_CYCLE
		case   9:	AT_ANTIC_GENERIC_CYCLE
		case  10:	AT_ANTIC_GENERIC_CYCLE
		case  11:	AT_ANTIC_GENERIC_CYCLE
		case  12:	AT_ANTIC_GENERIC_CYCLE
		case  13:	AT_ANTIC_GENERIC_CYCLE
		case  14:	AT_ANTIC_GENERIC_CYCLE
		case  15:	AT_ANTIC_GENERIC_CYCLE
		case  16:	AT_ANTIC_GENERIC_CYCLE
		case  17:	AT_ANTIC_GENERIC_CYCLE
		case  18:	AT_ANTIC_GENERIC_CYCLE
		case  19:	AT_ANTIC_GENERIC_CYCLE
		case  20:	AT_ANTIC_GENERIC_CYCLE
		case  21:	AT_ANTIC_GENERIC_CYCLE
		case  22:	AT_ANTIC_GENERIC_CYCLE
		case  23:	AT_ANTIC_GENERIC_CYCLE
		case  24:	AT_ANTIC_GENERIC_CYCLE
		case  25:	AT_ANTIC_GENERIC_CYCLE
		case  26:	AT_ANTIC_GENERIC_CYCLE
		case  27:	AT_ANTIC_GENERIC_CYCLE
		case  28:	AT_ANTIC_GENERIC_CYCLE
		case  29:	AT_ANTIC_GENERIC_CYCLE
		case  30:	AT_ANTIC_GENERIC_CYCLE
		case  31:	AT_ANTIC_GENERIC_CYCLE
		case  32:	AT_ANTIC_GENERIC_CYCLE
		case  33:	AT_ANTIC_GENERIC_CYCLE
		case  34:	AT_ANTIC_GENERIC_CYCLE
		case  35:	AT_ANTIC_GENERIC_CYCLE
		case  36:	AT_ANTIC_GENERIC_CYCLE
		case  37:	AT_ANTIC_GENERIC_CYCLE
		case  38:	AT_ANTIC_GENERIC_CYCLE
		case  39:	AT_ANTIC_GENERIC_CYCLE
		case  40:	AT_ANTIC_GENERIC_CYCLE
		case  41:	AT_ANTIC_GENERIC_CYCLE
		case  42:	AT_ANTIC_GENERIC_CYCLE
		case  43:	AT_ANTIC_GENERIC_CYCLE
		case  44:	AT_ANTIC_GENERIC_CYCLE
		case  45:	AT_ANTIC_GENERIC_CYCLE
		case  46:	AT_ANTIC_GENERIC_CYCLE
		case  47:	AT_ANTIC_GENERIC_CYCLE
		case  48:	AT_ANTIC_GENERIC_CYCLE
		case  49:	AT_ANTIC_GENERIC_CYCLE
		case  50:	AT_ANTIC_GENERIC_CYCLE
		case  51:	AT_ANTIC_GENERIC_CYCLE
		case  52:	AT_ANTIC_GENERIC_CYCLE
		case  53:	AT_ANTIC_GENERIC_CYCLE
		case  54:	AT_ANTIC_GENERIC_CYCLE
		case  55:	AT_ANTIC_GENERIC_CYCLE
		case  56:	AT_ANTIC_GENERIC_CYCLE
		case  57:	AT_ANTIC_GENERIC_CYCLE
		case  58:	AT_ANTIC_GENERIC_CYCLE
		case  59:	AT_ANTIC_GENERIC_CYCLE
		case  60:	AT_ANTIC_GENERIC_CYCLE
		case  61:	AT_ANTIC_GENERIC_CYCLE
		case  62:	AT_ANTIC_GENERIC_CYCLE
		case  63:	AT_ANTIC_GENERIC_CYCLE
		case  64:	AT_ANTIC_GENERIC_CYCLE
		case  65:	AT_ANTIC_GENERIC_CYCLE
		case  66:	AT_ANTIC_GENERIC_CYCLE
		case  67:	AT_ANTIC_GENERIC_CYCLE
		case  68:	AT_ANTIC_GENERIC_CYCLE
		case  69:	AT_ANTIC_GENERIC_CYCLE
		case  70:	AT_ANTIC_GENERIC_CYCLE
		case  71:	AT_ANTIC_GENERIC_CYCLE
		case  72:	AT_ANTIC_GENERIC_CYCLE
		case  73:	AT_ANTIC_GENERIC_CYCLE
		case  74:	AT_ANTIC_GENERIC_CYCLE
		case  75:	AT_ANTIC_GENERIC_CYCLE
		case  76:	AT_ANTIC_GENERIC_CYCLE
		case  77:	AT_ANTIC_GENERIC_CYCLE
		case  78:	AT_ANTIC_GENERIC_CYCLE
		case  79:	AT_ANTIC_GENERIC_CYCLE
		case  80:	AT_ANTIC_GENERIC_CYCLE
		case  81:	AT_ANTIC_GENERIC_CYCLE
		case  82:	AT_ANTIC_GENERIC_CYCLE
		case  83:	AT_ANTIC_GENERIC_CYCLE
		case  84:	AT_ANTIC_GENERIC_CYCLE
		case  85:	AT_ANTIC_GENERIC_CYCLE
		case  86:	AT_ANTIC_GENERIC_CYCLE
		case  87:	AT_ANTIC_GENERIC_CYCLE
		case  88:	AT_ANTIC_GENERIC_CYCLE
		case  89:	AT_ANTIC_GENERIC_CYCLE
		case  90:	AT_ANTIC_GENERIC_CYCLE
		case  91:	AT_ANTIC_GENERIC_CYCLE
		case  92:	AT_ANTIC_GENERIC_CYCLE
		case  93:	AT_ANTIC_GENERIC_CYCLE
		case  94:	AT_ANTIC_GENERIC_CYCLE
		case  95:	AT_ANTIC_GENERIC_CYCLE
		case  96:	AT_ANTIC_GENERIC_CYCLE
		case  97:	AT_ANTIC_GENERIC_CYCLE
		case  98:	AT_ANTIC_GENERIC_CYCLE
		case  99:	AT_ANTIC_GENERIC_CYCLE
		case 100:	AT_ANTIC_GENERIC_CYCLE
		case 101:	AT_ANTIC_GENERIC_CYCLE
		case 102:	AT_ANTIC_GENERIC_CYCLE
		case 103:	AT_ANTIC_GENERIC_CYCLE
		case 104:	AT_ANTIC_GENERIC_CYCLE
		case 105:	AT_ANTIC_GENERIC_CYCLE
		case 106:	AT_ANTIC_GENERIC_CYCLE
		case 107:	AT_ANTIC_GENERIC_CYCLE
		case 108:	AT_ANTIC_GENERIC_CYCLE
		case 109:	AT_ANTIC_GENERIC_CYCLE
		case 110:	AT_ANTIC_GENERIC_CYCLE
		case 111:	AT_ANTIC_GENERIC_CYCLE
		case 112:	AT_ANTIC_GENERIC_CYCLE
		case 113:	AT_ANTIC_GENERIC_CYCLE
					break;
		default:	VDNEVERHERE;
	}
}

template<>
void ATAnticEmulator::RunScanlineFastSpecific<0x727280>(ATScheduler& scheduler, ATCPUEmulator& cpu, ATSimulatorEvent& flag) {
	uint8 fetchMode;

	switch(mX) {
		case 113:	AT_ANTIC_CYCLE_0x80(114)
		case   0:	AT_ANTIC_CYCLE_0x80(  1)
		case   1:	AT_ANTIC_CYCLE_0x80(  2)
		case   2:	AT_ANTIC_CYCLE_0x80(  3)
		case   3:	AT_ANTIC_CYCLE_0x80(  4)
		case   4:	AT_ANTIC_CYCLE_0x80(  5)
		case   5:	AT_ANTIC_CYCLE_0x80(  6)
		case   6:	AT_ANTIC_CYCLE_0x80(  7)
		case   7:	AT_ANTIC_CYCLE_0x80(  8)
		case   8:	AT_ANTIC_CYCLE_0x80(  9)
		case   9:	AT_ANTIC_CYCLE_0x80( 10)
		case  10:	AT_ANTIC_CYCLE_0x00( 11)
		case  11:	AT_ANTIC_CYCLE_0x00( 12)
		case  12:	AT_ANTIC_CYCLE_0x00( 13)
		case  13:	AT_ANTIC_CYCLE_0x00( 14)
		case  14:	AT_ANTIC_CYCLE_0x00( 15)
		case  15:	AT_ANTIC_CYCLE_0x80( 16)
		case  16:	AT_ANTIC_CYCLE_0x00( 17)
		case  17:	AT_ANTIC_CYCLE_0x00( 18)
		case  18:	AT_ANTIC_CYCLE_0x00( 19)
		case  19:	AT_ANTIC_CYCLE_0x00( 20)
		case  20:	AT_ANTIC_CYCLE_0x00( 21)
		case  21:	AT_ANTIC_CYCLE_0x00( 22)
		case  22:	AT_ANTIC_CYCLE_0x00( 23)
		case  23:	AT_ANTIC_CYCLE_0x00( 24)
		case  24:	AT_ANTIC_CYCLE_0x01( 25)
		case  25:	AT_ANTIC_CYCLE_0x00( 26)
		case  26:	AT_ANTIC_CYCLE_0x00( 27)
		case  27:	AT_ANTIC_CYCLE_0x00( 28)
		case  28:	AT_ANTIC_CYCLE_0x01( 29)
		case  29:	AT_ANTIC_CYCLE_0x00( 30)
		case  30:	AT_ANTIC_CYCLE_0x00( 31)
		case  31:	AT_ANTIC_CYCLE_0x00( 32)
		case  32:	AT_ANTIC_CYCLE_0x01( 33)
		case  33:	AT_ANTIC_CYCLE_0x00( 34)
		case  34:	AT_ANTIC_CYCLE_0x00( 35)
		case  35:	AT_ANTIC_CYCLE_0x00( 36)
		case  36:	AT_ANTIC_CYCLE_0x01( 37)
		case  37:	AT_ANTIC_CYCLE_0x00( 38)
		case  38:	AT_ANTIC_CYCLE_0x00( 39)
		case  39:	AT_ANTIC_CYCLE_0x00( 40)
		case  40:	AT_ANTIC_CYCLE_0x01( 41)
		case  41:	AT_ANTIC_CYCLE_0x00( 42)
		case  42:	AT_ANTIC_CYCLE_0x00( 43)
		case  43:	AT_ANTIC_CYCLE_0x00( 44)
		case  44:	AT_ANTIC_CYCLE_0x01( 45)
		case  45:	AT_ANTIC_CYCLE_0x00( 46)
		case  46:	AT_ANTIC_CYCLE_0x00( 47)
		case  47:	AT_ANTIC_CYCLE_0x00( 48)
		case  48:	AT_ANTIC_CYCLE_0x01( 49)
		case  49:	AT_ANTIC_CYCLE_0x00( 50)
		case  50:	AT_ANTIC_CYCLE_0x00( 51)
		case  51:	AT_ANTIC_CYCLE_0x00( 52)
		case  52:	AT_ANTIC_CYCLE_0x01( 53)
		case  53:	AT_ANTIC_CYCLE_0x00( 54)
		case  54:	AT_ANTIC_CYCLE_0x00( 55)
		case  55:	AT_ANTIC_CYCLE_0x00( 56)
		case  56:	AT_ANTIC_CYCLE_0x01( 57)
		case  57:	AT_ANTIC_CYCLE_0x00( 58)
		case  58:	AT_ANTIC_CYCLE_0x00( 59)
		case  59:	AT_ANTIC_CYCLE_0x00( 60)
		case  60:	AT_ANTIC_CYCLE_0x00( 61)
		case  61:	AT_ANTIC_CYCLE_0x00( 62)
		case  62:	AT_ANTIC_CYCLE_0x00( 63)
		case  63:	AT_ANTIC_CYCLE_0x00( 64)
		case  64:	AT_ANTIC_CYCLE_0x00( 65)
		case  65:	AT_ANTIC_CYCLE_0x00( 66)
		case  66:	AT_ANTIC_CYCLE_0x00( 67)
		case  67:	AT_ANTIC_CYCLE_0x00( 68)
		case  68:	AT_ANTIC_CYCLE_0x00( 69)
		case  69:	AT_ANTIC_CYCLE_0x00( 70)
		case  70:	AT_ANTIC_CYCLE_0x00( 71)
		case  71:	AT_ANTIC_CYCLE_0x00( 72)
		case  72:	AT_ANTIC_CYCLE_0x00( 73)
		case  73:	AT_ANTIC_CYCLE_0x00( 74)
		case  74:	AT_ANTIC_CYCLE_0x00( 75)
		case  75:	AT_ANTIC_CYCLE_0x00( 76)
		case  76:	AT_ANTIC_CYCLE_0x00( 77)
		case  77:	AT_ANTIC_CYCLE_0x00( 78)
		case  78:	AT_ANTIC_CYCLE_0x00( 79)
		case  79:	AT_ANTIC_CYCLE_0x00( 80)
		case  80:	AT_ANTIC_CYCLE_0x00( 81)
		case  81:	AT_ANTIC_CYCLE_0x00( 82)
		case  82:	AT_ANTIC_CYCLE_0x00( 83)
		case  83:	AT_ANTIC_CYCLE_0x00( 84)
		case  84:	AT_ANTIC_CYCLE_0x00( 85)
		case  85:	AT_ANTIC_CYCLE_0x00( 86)
		case  86:	AT_ANTIC_CYCLE_0x00( 87)
		case  87:	AT_ANTIC_CYCLE_0x00( 88)
		case  88:	AT_ANTIC_CYCLE_0x00( 89)
		case  89:	AT_ANTIC_CYCLE_0x00( 90)
		case  90:	AT_ANTIC_CYCLE_0x00( 91)
		case  91:	AT_ANTIC_CYCLE_0x00( 92)
		case  92:	AT_ANTIC_CYCLE_0x00( 93)
		case  93:	AT_ANTIC_CYCLE_0x00( 94)
		case  94:	AT_ANTIC_CYCLE_0x00( 95)
		case  95:	AT_ANTIC_CYCLE_0x00( 96)
		case  96:	AT_ANTIC_CYCLE_0x00( 97)
		case  97:	AT_ANTIC_CYCLE_0x00( 98)
		case  98:	AT_ANTIC_CYCLE_0x00( 99)
		case  99:	AT_ANTIC_CYCLE_0x00(100)
		case 100:	AT_ANTIC_CYCLE_0x00(101)
		case 101:	AT_ANTIC_CYCLE_0x00(102)
		case 102:	AT_ANTIC_CYCLE_0x00(103)
		case 103:	AT_ANTIC_CYCLE_0x00(104)
		case 104:	AT_ANTIC_CYCLE_0x80(105)
		case 105:	AT_ANTIC_CYCLE_0x00(106)
		case 106:	AT_ANTIC_CYCLE_0x00(107)
		case 107:	AT_ANTIC_CYCLE_0x00(108)
		case 108:	AT_ANTIC_CYCLE_0x80(109)
		case 109:	AT_ANTIC_CYCLE_0x00(110)
		case 110:	AT_ANTIC_CYCLE_0x80(111)
		case 111:	AT_ANTIC_CYCLE_0x80(112)
		case 112:	AT_ANTIC_CYCLE_0x00(113)
					break;
		default:	VDNEVERHERE;
	}
}

template<>
void ATAnticEmulator::RunScanlineFastSpecific<0x1262a2>(ATScheduler& scheduler, ATCPUEmulator& cpu, ATSimulatorEvent& flag) {
	uint8 fetchMode;

	switch(mX) {
		case 113:	AT_ANTIC_CYCLE_0x80(114)
		case   0:	AT_ANTIC_CYCLE_0x80(  1)
		case   1:	AT_ANTIC_CYCLE_0x80(  2)
		case   2:	AT_ANTIC_CYCLE_0x80(  3)
		case   3:	AT_ANTIC_CYCLE_0x80(  4)
		case   4:	AT_ANTIC_CYCLE_0x80(  5)
		case   5:	AT_ANTIC_CYCLE_0x80(  6)
		case   6:	AT_ANTIC_CYCLE_0x80(  7)
		case   7:	AT_ANTIC_CYCLE_0x80(  8)
		case   8:	AT_ANTIC_CYCLE_0x80(  9)
		case   9:	AT_ANTIC_CYCLE_0x80( 10)
		case  10:	AT_ANTIC_CYCLE_0x00( 11)
		case  11:	AT_ANTIC_CYCLE_0x00( 12)
		case  12:	AT_ANTIC_CYCLE_0x00( 13)
		case  13:	AT_ANTIC_CYCLE_0x00( 14)
		case  14:	AT_ANTIC_CYCLE_0x00( 15)
		case  15:	AT_ANTIC_CYCLE_0x80( 16)
		case  16:	AT_ANTIC_CYCLE_0x00( 17)
		case  17:	AT_ANTIC_CYCLE_0x00( 18)
		case  18:	AT_ANTIC_CYCLE_0x00( 19)
		case  19:	AT_ANTIC_CYCLE_0x00( 20)
		case  20:	AT_ANTIC_CYCLE_0x05( 21)
		case  21:	AT_ANTIC_CYCLE_0x00( 22)
		case  22:	AT_ANTIC_CYCLE_0x05( 23)
		case  23:	AT_ANTIC_CYCLE_0x00( 24)
		case  24:	AT_ANTIC_CYCLE_0x05( 25)
		case  25:	AT_ANTIC_CYCLE_0x01( 26)
		case  26:	AT_ANTIC_CYCLE_0x05( 27)
		case  27:	AT_ANTIC_CYCLE_0x00( 28)
		case  28:	AT_ANTIC_CYCLE_0x05( 29)
		case  29:	AT_ANTIC_CYCLE_0x01( 30)
		case  30:	AT_ANTIC_CYCLE_0x05( 31)
		case  31:	AT_ANTIC_CYCLE_0x00( 32)
		case  32:	AT_ANTIC_CYCLE_0x05( 33)
		case  33:	AT_ANTIC_CYCLE_0x01( 34)
		case  34:	AT_ANTIC_CYCLE_0x05( 35)
		case  35:	AT_ANTIC_CYCLE_0x00( 36)
		case  36:	AT_ANTIC_CYCLE_0x05( 37)
		case  37:	AT_ANTIC_CYCLE_0x01( 38)
		case  38:	AT_ANTIC_CYCLE_0x05( 39)
		case  39:	AT_ANTIC_CYCLE_0x00( 40)
		case  40:	AT_ANTIC_CYCLE_0x05( 41)
		case  41:	AT_ANTIC_CYCLE_0x01( 42)
		case  42:	AT_ANTIC_CYCLE_0x05( 43)
		case  43:	AT_ANTIC_CYCLE_0x00( 44)
		case  44:	AT_ANTIC_CYCLE_0x05( 45)
		case  45:	AT_ANTIC_CYCLE_0x01( 46)
		case  46:	AT_ANTIC_CYCLE_0x05( 47)
		case  47:	AT_ANTIC_CYCLE_0x00( 48)
		case  48:	AT_ANTIC_CYCLE_0x05( 49)
		case  49:	AT_ANTIC_CYCLE_0x01( 50)
		case  50:	AT_ANTIC_CYCLE_0x05( 51)
		case  51:	AT_ANTIC_CYCLE_0x00( 52)
		case  52:	AT_ANTIC_CYCLE_0x05( 53)
		case  53:	AT_ANTIC_CYCLE_0x01( 54)
		case  54:	AT_ANTIC_CYCLE_0x05( 55)
		case  55:	AT_ANTIC_CYCLE_0x00( 56)
		case  56:	AT_ANTIC_CYCLE_0x05( 57)
		case  57:	AT_ANTIC_CYCLE_0x01( 58)
		case  58:	AT_ANTIC_CYCLE_0x05( 59)
		case  59:	AT_ANTIC_CYCLE_0x00( 60)
		case  60:	AT_ANTIC_CYCLE_0x05( 61)
		case  61:	AT_ANTIC_CYCLE_0x00( 62)
		case  62:	AT_ANTIC_CYCLE_0x05( 63)
		case  63:	AT_ANTIC_CYCLE_0x00( 64)
		case  64:	AT_ANTIC_CYCLE_0x05( 65)
		case  65:	AT_ANTIC_CYCLE_0x00( 66)
		case  66:	AT_ANTIC_CYCLE_0x05( 67)
		case  67:	AT_ANTIC_CYCLE_0x00( 68)
		case  68:	AT_ANTIC_CYCLE_0x05( 69)
		case  69:	AT_ANTIC_CYCLE_0x00( 70)
		case  70:	AT_ANTIC_CYCLE_0x05( 71)
		case  71:	AT_ANTIC_CYCLE_0x00( 72)
		case  72:	AT_ANTIC_CYCLE_0x05( 73)
		case  73:	AT_ANTIC_CYCLE_0x00( 74)
		case  74:	AT_ANTIC_CYCLE_0x05( 75)
		case  75:	AT_ANTIC_CYCLE_0x00( 76)
		case  76:	AT_ANTIC_CYCLE_0x05( 77)
		case  77:	AT_ANTIC_CYCLE_0x00( 78)
		case  78:	AT_ANTIC_CYCLE_0x05( 79)
		case  79:	AT_ANTIC_CYCLE_0x00( 80)
		case  80:	AT_ANTIC_CYCLE_0x05( 81)
		case  81:	AT_ANTIC_CYCLE_0x00( 82)
		case  82:	AT_ANTIC_CYCLE_0x05( 83)
		case  83:	AT_ANTIC_CYCLE_0x00( 84)
		case  84:	AT_ANTIC_CYCLE_0x05( 85)
		case  85:	AT_ANTIC_CYCLE_0x00( 86)
		case  86:	AT_ANTIC_CYCLE_0x05( 87)
		case  87:	AT_ANTIC_CYCLE_0x00( 88)
		case  88:	AT_ANTIC_CYCLE_0x05( 89)
		case  89:	AT_ANTIC_CYCLE_0x00( 90)
		case  90:	AT_ANTIC_CYCLE_0x05( 91)
		case  91:	AT_ANTIC_CYCLE_0x00( 92)
		case  92:	AT_ANTIC_CYCLE_0x05( 93)
		case  93:	AT_ANTIC_CYCLE_0x00( 94)
		case  94:	AT_ANTIC_CYCLE_0x05( 95)
		case  95:	AT_ANTIC_CYCLE_0x00( 96)
		case  96:	AT_ANTIC_CYCLE_0x05( 97)
		case  97:	AT_ANTIC_CYCLE_0x00( 98)
		case  98:	AT_ANTIC_CYCLE_0x05( 99)
		case  99:	AT_ANTIC_CYCLE_0x00(100)
		case 100:	AT_ANTIC_CYCLE_0x00(101)
		case 101:	AT_ANTIC_CYCLE_0x00(102)
		case 102:	AT_ANTIC_CYCLE_0x00(103)
		case 103:	AT_ANTIC_CYCLE_0x00(104)
		case 104:	AT_ANTIC_CYCLE_0x80(105)
		case 105:	AT_ANTIC_CYCLE_0x00(106)
		case 106:	AT_ANTIC_CYCLE_0x00(107)
		case 107:	AT_ANTIC_CYCLE_0x00(108)
		case 108:	AT_ANTIC_CYCLE_0x80(109)
		case 109:	AT_ANTIC_CYCLE_0x00(110)
		case 110:	AT_ANTIC_CYCLE_0x80(111)
		case 111:	AT_ANTIC_CYCLE_0x80(112)
		case 112:	AT_ANTIC_CYCLE_0x00(113)
					break;
		default:	VDNEVERHERE;
	}
}

void ATAnticEmulator::RunScanlineFast(ATScheduler& scheduler, ATCPUEmulator& cpu, ATSimulatorEvent& flag) {
	switch(mPFDMAPatternCacheKey) {
		case 0x1262a2:
			RunScanlineFastSpecific<0x1262a2>(scheduler, cpu, flag);
			break;

		case 0x727280:
			RunScanlineFastSpecific<0x727280>(scheduler, cpu, flag);
			break;

		default:
			RunScanlineFastGeneric(scheduler, cpu, flag);
			break;
	}
}
