;	Altirra - Atari 800/800XL/5200 emulator
;	Additions - color map utility
;	Copyright (C) 2008-2015 Avery Lee
;
;	This program is free software; you can redistribute it and/or modify
;	it under the terms of the GNU General Public License as published by
;	the Free Software Foundation; either version 2 of the License, or
;	(at your option) any later version.
;
;	This program is distributed in the hope that it will be useful,
;	but WITHOUT ANY WARRANTY; without even the implied warranty of
;	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;	GNU General Public License for more details.
;
;	You should have received a copy of the GNU General Public License
;	along with this program; if not, write to the Free Software
;	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

		icl		'kernel.inc'
		icl		'kerneldb.inc'
		icl		'hardware.inc'

pfptr	= $80
		; $81
colsav	= $82
		; $83
		; $84
		; $85
		; $86
dlsav	= $87
		; $88
dlisav	= $89
		; $8A
prsav	= $8B

		org		$2200

;==========================================================================
.proc Main
		;save colors
		ldx		#4
		mva:rpl	color0,x colsav,x-

		;swap in display list handler
		mva		#$40 nmien
		mwa		vdslst dlisav
		mwa		#DliHandler vdslst

		;swap in display list and enable DLI
		mwa		sdlstl dlsav
		mva		gprior prsav
		sei
		mwa		#dlist sdlstl
		mva		#$c0 nmien
		mva		#$40 gprior
		cli

		;wait for a key
		lda		#$ff
		sta		ch
waitkey:
		cmp		ch
		beq		waitkey
		sta		ch

		;restore colors, display list, and character set
		sei
		mva		#$40 nmien
		mwa		dlisav vdslst
		mwa		dlsav sdlstl
		mva		prsav gprior
		ldx		#4
		mva:rpl	colsav,x color0,x-
		cli

		;wait for display change to take place
		sec
		ror		strig0
		lda:rmi	strig0

		rts
.endp

;==========================================================================
.proc DliHandler
		pha
		txa
		pha
		sta		wsync
		ldx		#0
		ldy		#0
		lda		#0
row_loop:
		sta		wsync
		sta		colbk
		inx
		txa
		asl
		and		#$f0
		bcc		row_loop
xit:

		pla
		tax
		pla
		rti
.endp

;==========================================================================

		org		$3000

dlist:
		dta		$70
		dta		$70
		dta		$e0
		dta		$00
		:128 dta $4f, a(playfield)
		dta		$41, a(dlist)

playfield:
		:16	dta #*$11
		:16 dta 0

		run		Main
