//	Altirra - Atari 800/800XL/5200 emulator
//	Copyright (C) 2008-2015 Avery Lee
//
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include <stdafx.h>
#include <at/atcpu/execstate.h>
#include "cpu.h"
#include "debugtarget.h"
#include "simulator.h"

extern ATSimulator g_sim;

const char *ATDebuggerDefaultTarget::GetName() {
	return "Main CPU";
}

void ATDebuggerDefaultTarget::GetExecState(ATCPUExecState& state) {
	ATCPUEmulator& cpu = g_sim.GetCPU();
	state.mPC = cpu.GetInsnPC();
	state.mA = cpu.GetA();
	state.mX = cpu.GetX();
	state.mY = cpu.GetY();
	state.mS = cpu.GetS();
	state.mP = cpu.GetP();

	state.mAH = cpu.GetAH();
	state.mXH = cpu.GetXH();
	state.mYH = cpu.GetYH();
	state.mSH = cpu.GetSH();
	state.mB = cpu.GetB();
	state.mK = cpu.GetK();
	state.mDP = cpu.GetD();
	state.mbEmulationFlag = cpu.GetEmulationFlag();
}

void ATDebuggerDefaultTarget::SetExecState(const ATCPUExecState& state) {
	ATCPUEmulator& cpu = g_sim.GetCPU();

	// we must guard this to avoid disturbing an instruction in progress
	if (state.mPC != cpu.GetInsnPC())
		cpu.SetPC(state.mPC);

	cpu.SetA(state.mA);
	cpu.SetX(state.mX);
	cpu.SetY(state.mY);
	cpu.SetS(state.mS);
	cpu.SetP(state.mP);
	cpu.SetAH(state.mAH);
	cpu.SetXH(state.mXH);
	cpu.SetYH(state.mYH);
	cpu.SetSH(state.mSH);
	cpu.SetB(state.mB);
	cpu.SetK(state.mK);
	cpu.SetD(state.mDP);
	cpu.SetEmulationFlag(state.mbEmulationFlag);
}

uint8 ATDebuggerDefaultTarget::ReadByte(uint32 address) {
	if (address < 0x1000000)
		return g_sim.DebugExtReadByte(address);

	return 0;
}

void ATDebuggerDefaultTarget::ReadMemory(uint32 address, void *dst, uint32 n) {
	while(n--) {
		*(uint8 *)dst = ReadByte(address);
		dst = (uint8 *)dst + 1;
	}
}

uint8 ATDebuggerDefaultTarget::DebugReadByte(uint32 address) {
	return g_sim.DebugGlobalReadByte(address);
}

void ATDebuggerDefaultTarget::DebugReadMemory(uint32 address, void *dst, uint32 n) {
	while(n--) {
		*(uint8 *)dst = DebugReadByte(address);
		dst = (uint8 *)dst + 1;
	}

}

void ATDebuggerDefaultTarget::WriteByte(uint32 address, uint8 value) {
	g_sim.DebugGlobalWriteByte(address, value);
}

void ATDebuggerDefaultTarget::WriteMemory(uint32 address, const void *src, uint32 n) {
	while(n--) {
		WriteByte(address, *(const uint8 *)src);
		src = (const uint8 *)src + 1;
	}
}
