//	Altirra - Atari 800/800XL/5200 emulator
//	Copyright (C) 2009-2015 Avery Lee
//
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef f_AT_VERONICA_H
#define f_AT_VERONICA_H

#include <vd2/system/vdstl.h>
#include <vd2/system/refcount.h>
#include <at/atcore/deviceimpl.h>
#include <at/atcore/deviceprinter.h>
#include <at/atcore/deviceserial.h>
#include <at/atcpu/co65802.h>
#include <at/atdebugger/target.h>
#include "scheduler.h"

class ATMemoryLayer;
class ATIRQController;
class IATIDEDisk;

class ATVeronicaEmulator final : public ATDevice
	, public IATDeviceMemMap
	, public IATDeviceScheduling
	, public IATDeviceDebugTarget
	, public IATDebugTarget
	, public IATSchedulerCallback
{
public:
	ATVeronicaEmulator();
	~ATVeronicaEmulator();

	void *AsInterface(uint32 iid);

	virtual void GetDeviceInfo(ATDeviceInfo& info);
	virtual void GetSettings(ATPropertySet& settings);
	virtual bool SetSettings(const ATPropertySet& settings);
	virtual void Init();
	virtual void Shutdown();
	virtual void WarmReset();
	virtual void ColdReset();

public:
	virtual void InitMemMap(ATMemoryManager *memmap);
	virtual bool GetMappedRange(uint32 index, uint32& lo, uint32& hi) const;

public:
	virtual void InitScheduling(ATScheduler *sch, ATScheduler *slowsch);

public:	// IATDeviceDebugTarget
	IATDebugTarget *GetDebugTarget(uint32 index) override;

public:	// IATDebugTarget
	const char *GetName() override;

	void GetExecState(ATCPUExecState& state) override;
	void SetExecState(const ATCPUExecState& state) override;

	uint8 ReadByte(uint32 address) override;
	void ReadMemory(uint32 address, void *dst, uint32 n) override;

	uint8 DebugReadByte(uint32 address) override;
	void DebugReadMemory(uint32 address, void *dst, uint32 n) override;

	void WriteByte(uint32 address, uint8 value) override;
	void WriteMemory(uint32 address, const void *src, uint32 n) override;

public:
	virtual void OnScheduledEvent(uint32 id);

protected:
	static sint32 OnDebugRead(void *thisptr, uint32 addr);
	static sint32 OnRead(void *thisptr, uint32 addr);
	static bool OnWrite(void *thisptr, uint32 addr, uint8 value);

	void WriteVControl(uint8 val);
	void UpdateCoProcWindowDormant();
	void UpdateCoProcWindowActive();
	void UpdateWindowBase();
	void Sync();

	ATScheduler *mpScheduler;
	ATScheduler *mpSlowScheduler;
	ATEvent *mpRunEvent;
	ATMemoryManager *mpMemMan;
	ATMemoryLayer *mpMemLayerLeftWindow;
	ATMemoryLayer *mpMemLayerRightWindow;
	ATMemoryLayer *mpMemLayerControl;

	uint32 mLastSync;
	uint8 mAControl;
	uint8 mVControl;

	ATCoProcWriteMemNode mWriteNode;
	ATCoProc65802 mCoProc;

	VDALIGN(4) uint8 mRAM[0x20000];
};

#endif
