/**
 * Copyright (C) 2014 <a href="http://www.wudsn.com" target="_top">Peter Dell</a>
 *
 * This file is part of ROM Checker.
 * 
 * ROM Checker is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 * 
 * ROM Checker is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with ROM Checker.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.wudsn.tools.atariroms;

import com.wudsn.tools.base.repository.DataType;
import com.wudsn.tools.base.repository.NLS;

/**
 * Text repository.
 * 
 * @author Peter Dell
 */
public final class DataTypes extends NLS {

    public static DataType WorkbookEntry_Id = new DataType(Integer.class);
    public static DataType WorkbookEntry_FolderPath = new DataType(String.class);
    public static DataType WorkbookEntry_FileName = new DataType(String.class);
    public static DataType WorkbookEntry_MD5 = new DataType(String.class);
    public static DataType WorkbookEntry_CRC32 = new DataType(String.class);
    public static DataType WorkbookEntry_Message = new DataType(String.class);

    public static DataType ROM_FPP_CheckSum = new DataType(String.class);
    public static DataType ROM_OS1_CheckSum = new DataType(String.class);
    public static DataType ROM_OS2_CheckSum = new DataType(String.class);

    public static DataType Version_Type = new DataType(String.class);
    public static DataType Version_Revision = new DataType(String.class);
    public static DataType Version_Norm = new DataType(String.class);
    public static DataType Version_Year = new DataType(String.class);
    public static DataType Version_Comment = new DataType(String.class);
    public static DataType Version_Parts = new DataType(String.class);

    public static DataType Comparison_EntriesCount = new DataType(Integer.class);
    public static DataType ComparisonEntry_Id = new DataType(Integer.class);
    public static DataType ComparisonEntry_Offset = new DataType(String.class);
    public static DataType ComparisonEntry_Address = new DataType(String.class);
    public static DataType ComparisonEntry_Value = new DataType(String.class);

    static {
	initializeClass(DataTypes.class, null);
    }
}
