/**
 * Copyright (C) 2014 <a href="http://www.wudsn.com" target="_top">Peter Dell</a>
 *
 * This file is part of ROM Checker.
 * 
 * ROM Checker is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 * 
 * ROM Checker is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with ROM Checker.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.wudsn.tools.atariroms.model;

import java.io.File;

import com.wudsn.tools.atariroms.DataTypes;
import com.wudsn.tools.base.repository.Attribute;

public final class WorkbookEntry {
    public static final class Attributes {
	private Attributes() {
	}

	public static final Attribute ID = new Attribute("id", DataTypes.WorkbookEntry_Id);
	public static final Attribute FOLDER_PATH = new Attribute("folderPath", DataTypes.WorkbookEntry_FolderPath);
	public static final Attribute FILE_NAME = new Attribute("fileName", DataTypes.WorkbookEntry_FileName);
	public static final Attribute MD5 = new Attribute("md5", DataTypes.WorkbookEntry_MD5);
	public static final Attribute CRC32 = new Attribute("crc32", DataTypes.WorkbookEntry_CRC32);
	public static final Attribute MESSAGE = new Attribute("message", DataTypes.WorkbookEntry_Message);

    }

    private File file;
    private String folderPath;
    private String fileName;
    private String md5;
    private String crc32;
    private ROM rom;
    private ROMVersion romVersion;
    private String message;

    public WorkbookEntry(File file) {
	if (file == null) {
	    throw new IllegalArgumentException("Parameter 'file' must not be null.");
	}
	this.file = file;
	this.folderPath = file.getParentFile().getPath();
	this.fileName = file.getName();
	md5 = "";
	crc32 = "";
	rom = null;
	romVersion = null;
	message = "";
    }

    public File getFile() {
	return file;
    }

    public String getFolderPath() {
	return folderPath;
    }

    public void setFileName(String fileName) {
	if (fileName == null) {
	    throw new IllegalArgumentException("Parameter 'fileName' must not be null.");
	}
 	this.fileName= fileName;
     }
    
    public String getFileName() {
	return fileName;
    }

    public String getMD5() {
	return md5;
    }

    public void setMD5(String md5) {
	if (md5 == null) {
	    throw new IllegalArgumentException("Parameter 'md5' must not be null.");
	}
	this.md5 = md5;
    }

    public String getCRC32() {
	return crc32;
    }

    public void setCRC32(String crc32) {
	if (crc32 == null) {
	    throw new IllegalArgumentException("Parameter 'crc32' must not be null.");
	}
	this.crc32 = crc32;
    }

    public void setROM(ROM rom) {
	if (rom == null) {
	    throw new IllegalArgumentException("Parameter 'rom' must not be null.");
	}
	this.rom = rom;

	setMD5(rom.getMD5());
	setCRC32(rom.getCRC32());
	setROMVersion(ROMVersion.getByCRC32(rom.getCRC32()));
    }

    public ROM getROM() {
	return rom;
    }

    public void setROMVersion(ROMVersion romVersion) {
	if (romVersion == null) {
	    throw new IllegalArgumentException("Parameter 'romVersion' must not be null.");
	}
	this.romVersion = romVersion;
    }

    public ROMVersion getROMVersion() {
	return romVersion;
    }

    public void setMessage(String message) {
	if (message == null) {
	    throw new IllegalArgumentException("Parameter 'message' must not be null.");
	}
	this.message = message;
    }

    public String getMessage() {
	return message;
    }

}
