/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.atariroms;

import com.wudsn.tools.atariroms.Messages;
import com.wudsn.tools.atariroms.Preferences;
import com.wudsn.tools.atariroms.Texts;
import com.wudsn.tools.atariroms.model.Comparison;
import com.wudsn.tools.atariroms.model.Workbook;
import com.wudsn.tools.atariroms.model.WorkbookEntry;
import com.wudsn.tools.atariroms.model.WorkbookLogic;
import com.wudsn.tools.atariroms.ui.ComparisonDialog;
import com.wudsn.tools.atariroms.ui.MainMenu;
import com.wudsn.tools.atariroms.ui.WorkbookEntriesPanel;
import com.wudsn.tools.base.common.Application;
import com.wudsn.tools.base.common.Log;
import com.wudsn.tools.base.common.MessageQueue;
import com.wudsn.tools.base.common.TextUtility;
import com.wudsn.tools.base.gui.AttributeTable;
import com.wudsn.tools.base.gui.FileDrop;
import com.wudsn.tools.base.gui.HelpDialog;
import com.wudsn.tools.base.gui.StatusBar;
import com.wudsn.tools.base.gui.UIManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JFrame;

public final class ROMChecker
implements ActionListener,
FileDrop.Listener {
    static ROMChecker instance;
    private MessageQueue messageQueue;
    private Preferences preferences;
    private WorkbookLogic workbookLogic;
    private Workbook workbook;
    private JFrame mainWindowFrame;
    private MainMenu mainMenu;
    private WorkbookEntriesPanel entriesPanel;
    private StatusBar statusBar;
    private HelpDialog helpDialog;
    private FileDrop fileDrop;

    public static void main(final String[] args) {
        if (args == null) {
            throw new IllegalArgumentException("Parameter 'args' must not be null.");
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Application.createInstance("http://www.wudsn.com/productions/atari8000/atarirom/atariroms.zip", "AtariROMs.jar", "com/wudsn/tools/atariroms/AtariROMs.version");
                instance = new ROMChecker();
                instance.run(args);
            }
        });
    }

    ROMChecker() {
    }

    void run(String[] args) {
        if (args == null) {
            throw new IllegalArgumentException("Parameter 'args' must not be null.");
        }
        UIManager.init();
        this.messageQueue = new MessageQueue();
        this.preferences = new Preferences();
        this.workbookLogic = new WorkbookLogic();
        this.workbook = new Workbook();
        this.createUI();
        this.messageQueue.sendMessage(null, null, Messages.I100, Application.getInstance().getLocalVersion());
        this.dataToUI();
        ArrayList<File> filesList = new ArrayList<File>();
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            filesList.add(new File(arg));
            ++n2;
        }
        if (!filesList.isEmpty()) {
            this.performFilesDropped(filesList);
        }
    }

    private void createUI() {
        this.mainWindowFrame = new JFrame(Texts.MainWindow_Title);
        this.mainWindowFrame.setSize(800, 600);
        this.mainWindowFrame.setLocationRelativeTo(null);
        this.mainWindowFrame.setDefaultCloseOperation(0);
        this.mainWindowFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ROMChecker.this.actionPerformed(new ActionEvent(this, 0, "exit"));
            }
        });
        this.mainWindowFrame.setLayout(new BorderLayout());
        this.mainMenu = new MainMenu(this, this.preferences);
        this.mainWindowFrame.add((Component)this.mainMenu.menuBar, "North");
        this.entriesPanel = new WorkbookEntriesPanel(this.preferences, this.workbook);
        this.mainWindowFrame.add((Component)this.entriesPanel, "Center");
        this.statusBar = new StatusBar();
        this.messageQueue.setMessageQueueRenderer(this.statusBar);
        this.mainWindowFrame.add((Component)this.statusBar.getComponent(), "South");
        this.mainWindowFrame.setVisible(true);
        this.fileDrop = new FileDrop(this.mainWindowFrame, true, this);
    }

    public void dataFromUI() {
    }

    public void dataToUI() {
        this.entriesPanel.dataToUI();
        this.statusBar.displayMessageQueue(this.messageQueue);
    }

    public void performFilesDropped(List<File> filesList) {
        if (filesList == null) {
            throw new IllegalArgumentException("Parameter 'filesList' must not be null.");
        }
        this.dataFromUI();
        this.messageQueue.clear();
        try {
            this.workbookLogic.checkFiles(this.workbook, filesList);
            this.messageQueue.sendMessage(null, null, Messages.I102, TextUtility.formatAsDecimal(this.workbook.getResolvedFilesCount()));
        }
        catch (RuntimeException ex) {
            this.messageQueue.sendMessage(null, null, Messages.E101, ex.getMessage());
            Log.logError("Exception while checking files.", null, ex);
        }
        this.dataToUI();
    }

    @Override
    public boolean isDropAllowed() {
        return true;
    }

    @Override
    public void filesDropped(File[] files) {
        if (files == null) {
            throw new IllegalArgumentException("Parameter 'files' must not be null.");
        }
        this.performFilesDropped(Arrays.asList(files));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent == null) {
            throw new IllegalArgumentException("Parameter 'actionEvent' must not be null.");
        }
        this.dataFromUI();
        String command = actionEvent.getActionCommand();
        this.messageQueue.clear();
        this.statusBar.displayMessageQueue(this.messageQueue);
        if (command.equals("exit")) {
            this.performExit();
        } else if (command.equals("compareEntries") && this.mainMenu.compareEntriesMenuItem.isEnabled()) {
            this.performCompareEntries();
        } else if (command.equals("helpContents")) {
            this.performHelpDialog();
        }
        this.dataToUI();
    }

    private void performExit() {
        System.exit(0);
    }

    private void performHelpDialog() {
        if (this.helpDialog == null) {
            this.helpDialog = new HelpDialog(this.mainWindowFrame, "help/ROMChecker.html", 640, 320);
        }
        this.helpDialog.show();
    }

    private void performCompareEntries() {
        AttributeTable entriesTable = this.entriesPanel.getTable();
        int[] selectedViewRowIndexes = entriesTable.getSelectedRows();
        int[] selectedModelRowIndexes = new int[selectedViewRowIndexes.length];
        int i = 0;
        while (i < selectedViewRowIndexes.length) {
            selectedModelRowIndexes[i] = entriesTable.convertRowIndexToModel(selectedViewRowIndexes[i]);
            ++i;
        }
        List<WorkbookEntry> entries = this.workbook.getUnmodifiableEntriesList();
        ArrayList<WorkbookEntry> selectedEntries = new ArrayList<WorkbookEntry>();
        int i2 = 0;
        while (i2 < selectedModelRowIndexes.length) {
            selectedEntries.add(entries.get(selectedModelRowIndexes[i2]));
            ++i2;
        }
        Comparison comparison = this.workbookLogic.compareEntries(this.workbook, selectedEntries, this.messageQueue);
        if (comparison != null) {
            ComparisonDialog dialog = new ComparisonDialog(this.mainWindowFrame, this.preferences, comparison);
            dialog.showModal(this.messageQueue);
        }
    }

    public final class Commands {
        public static final String EXIT = "exit";
        public static final String COMPARE_ENTRIES = "compareEntries";
        public static final String HELP_CONTENTS = "helpContents";
    }
}

