/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.atariroms.model;

import com.wudsn.tools.atariroms.model.ComparisonEntry;
import com.wudsn.tools.atariroms.model.WorkbookEntry;
import com.wudsn.tools.base.gui.AttributeTableModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Comparison {
    public static final int MIN = 2;
    public static final int MAX = 5;
    private List<WorkbookEntry> workbookEntries;
    private List<ComparisonEntry> entriesList;
    private List<ComparisonEntry> unmodifiableEntriesList;
    private AttributeTableModel entriesModel;

    public Comparison(List<WorkbookEntry> workbookEntries) {
        if (workbookEntries == null) {
            throw new IllegalArgumentException("Parameter 'workbookEntries' must not be null.");
        }
        this.workbookEntries = workbookEntries;
        this.entriesList = new ArrayList<ComparisonEntry>();
        this.unmodifiableEntriesList = Collections.unmodifiableList(this.entriesList);
    }

    public int getWorkbookEntryCount() {
        return this.workbookEntries.size();
    }

    public WorkbookEntry getWorkbookEntry(int index) {
        return this.workbookEntries.get(index);
    }

    public void setEntriesTableModel(AttributeTableModel entriesModel) {
        this.entriesModel = entriesModel;
    }

    public void clear() {
        this.entriesList.clear();
        if (this.entriesModel != null) {
            this.entriesModel.fireTableDataChanged();
        }
    }

    public ComparisonEntry createEntry(int offset, int address) {
        ComparisonEntry entry = new ComparisonEntry(this.getWorkbookEntryCount());
        entry.setOffset(offset);
        entry.setAddress(address);
        return entry;
    }

    public void addEntry(ComparisonEntry entry) {
        if (entry == null) {
            throw new IllegalArgumentException("Parameter 'entry' must not be null.");
        }
        this.entriesList.add(entry);
        if (this.entriesModel != null) {
            this.entriesModel.fireTableDataChanged();
        }
    }

    public ComparisonEntry getEntry(int row) {
        return this.entriesList.get(row);
    }

    public int getEntryCount() {
        return this.entriesList.size();
    }

    public List<ComparisonEntry> getUnmodifiableEntriesList() {
        return this.unmodifiableEntriesList;
    }

    public long getMaximumOffset() {
        return 65535L;
    }

    public long getMaximumAddress() {
        return 65535L;
    }

    public String toString() {
        return "workbookEntryCount=" + this.getWorkbookEntryCount() + "/entries=" + this.entriesList.toString();
    }
}

