/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.atariroms.model;

import com.wudsn.tools.atariroms.DataTypes;
import com.wudsn.tools.base.common.ByteArrayUtility;
import com.wudsn.tools.base.common.HexUtility;
import com.wudsn.tools.base.repository.Attribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.zip.CRC32;

public final class ROM {
    public static final int MAX_SIZE = 65536;
    private static final int UNKNOWN = 0;
    private static final int OS_AB = 1;
    private static final int OS_XL = 2;
    private static final int FPP_OFFSET = 2046;
    private static final int OS1_OFFSET1 = 3087;
    private static final int OS1_OFFSET2 = 3103;
    private static final int OS2_OFFSET = 10232;
    private byte[] content;
    private int type;

    public ROM(byte[] content) {
        if (content == null) {
            throw new IllegalArgumentException("Parameter 'content' must not be null.");
        }
        this.content = content;
        switch (content.length) {
            case 10240: {
                this.type = 1;
                break;
            }
            case 16384: {
                this.type = 2;
                break;
            }
            default: {
                this.type = 0;
            }
        }
    }

    public int getSize() {
        return this.content.length;
    }

    public int getFPP() {
        if (this.type != 1) {
            return -1;
        }
        return this.getWord(2046);
    }

    public int getOS1() {
        if (this.type != 1) {
            return -1;
        }
        return this.getByte(3087) + (this.getByte(3103) << 8);
    }

    public int getOS2() {
        if (this.type != 1) {
            return -1;
        }
        return this.getWord(10232);
    }

    public String getCRC32() {
        CRC32 crc32 = new CRC32();
        crc32.update(this.content);
        return "0x" + HexUtility.getLongValueHexString(crc32.getValue(), 8).toLowerCase();
    }

    public String getMD5() {
        MessageDigest md5;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
        md5.update(this.content);
        return ByteArrayUtility.toHexString(md5.digest()).toLowerCase();
    }

    private int getWord(int offset) {
        return this.getByte(offset) + (this.getByte(offset + 1) << 8);
    }

    public int getByte(int offset) {
        return this.content[offset] & 0xFF;
    }

    public boolean contentEquals(ROM other) {
        return Arrays.equals(this.content, other.content);
    }

    public String toString() {
        return "FPP=" + ROM.toHexBytes(this.getFPP()) + " OS1=" + ROM.toHexBytes(this.getOS1()) + " OS2=" + ROM.toHexBytes(this.getOS2()) + " MD5=" + this.getMD5() + " CRC-32=" + this.getCRC32();
    }

    public int toAddress(int offset) {
        switch (this.type) {
            case 0: {
                return -1;
            }
            case 1: {
                if (offset < 0 || offset >= 10240) break;
                return 55296 + offset;
            }
            case 2: {
                if (offset < 0 || offset >= 16384) break;
                if (offset >= 4096 && offset < 6144) {
                    return 16384 + offset;
                }
                return 49152 + offset;
            }
            default: {
                throw new RuntimeException();
            }
        }
        return -1;
    }

    public static String toHexBytes(int value) {
        if (value < 0) {
            return "";
        }
        int low = value & 0xFF;
        int high = value >>> 8 & 0xFF;
        return String.valueOf(ROM.toHexByte(low)) + "/" + ROM.toHexByte(high);
    }

    private static String toHexByte(int value) {
        if ((value &= 0xFF) < 10) {
            return "$0" + Integer.toHexString(value);
        }
        return "$" + Integer.toHexString(value);
    }

    public ROM createFixture() {
        if (this.type != 1) {
            return this;
        }
        byte[] newContent = new byte[this.content.length];
        System.arraycopy(this.content, 0, newContent, 0, this.content.length);
        int fpp = 0;
        int i = 0;
        while (i < 2046) {
            fpp += this.content[i] & 0xFF;
            ++i;
        }
        newContent[2046] = (byte)((fpp &= 0xFFFF) & 0xFF);
        newContent[2047] = (byte)(fpp >>> 8);
        int os1 = 0;
        i = 2048;
        while (i < 3087) {
            os1 += this.content[i] & 0xFF;
            ++i;
        }
        i = 3088;
        while (i < 3103) {
            os1 += this.content[i] & 0xFF;
            ++i;
        }
        i = 3104;
        while (i < 6144) {
            os1 += this.content[i] & 0xFF;
            ++i;
        }
        newContent[3087] = (byte)((os1 &= 0xFFFF) & 0xFF);
        newContent[3103] = (byte)(os1 >>> 8);
        int os2 = 0;
        i = 6144;
        while (i < 10232) {
            os2 += this.content[i] & 0xFF;
            ++i;
        }
        i = 10234;
        while (i < 10240) {
            os2 += this.content[i] & 0xFF;
            ++i;
        }
        newContent[10232] = (byte)((os2 &= 0xFFFF) & 0xFF);
        newContent[10233] = (byte)(os2 >>> 8);
        return new ROM(newContent);
    }

    public static final class Attributes {
        public static final Attribute FPP_CHECK_SUM = new Attribute("fppCheckSum", DataTypes.ROM_FPP_CheckSum);
        public static final Attribute OS1_CHECK_SUM = new Attribute("os1CheckSum", DataTypes.ROM_OS1_CheckSum);
        public static final Attribute OS2_CHECK_SUM = new Attribute("os2CheckSum", DataTypes.ROM_OS2_CheckSum);

        private Attributes() {
        }
    }
}

