/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.atariroms.model;

import com.wudsn.tools.atariroms.DataTypes;
import com.wudsn.tools.atariroms.model.ROM;
import com.wudsn.tools.atariroms.model.ROMVersion;
import com.wudsn.tools.base.repository.Attribute;
import java.io.File;

public final class WorkbookEntry {
    private File file;
    private String folderPath;
    private String fileName;
    private String md5;
    private String crc32;
    private ROM rom;
    private ROMVersion romVersion;
    private String message;

    public WorkbookEntry(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 'file' must not be null.");
        }
        this.file = file;
        this.folderPath = file.getParentFile().getPath();
        this.fileName = file.getName();
        this.md5 = "";
        this.crc32 = "";
        this.rom = null;
        this.romVersion = null;
        this.message = "";
    }

    public File getFile() {
        return this.file;
    }

    public String getFolderPath() {
        return this.folderPath;
    }

    public void setFileName(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("Parameter 'fileName' must not be null.");
        }
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getMD5() {
        return this.md5;
    }

    public void setMD5(String md5) {
        if (md5 == null) {
            throw new IllegalArgumentException("Parameter 'md5' must not be null.");
        }
        this.md5 = md5;
    }

    public String getCRC32() {
        return this.crc32;
    }

    public void setCRC32(String crc32) {
        if (crc32 == null) {
            throw new IllegalArgumentException("Parameter 'crc32' must not be null.");
        }
        this.crc32 = crc32;
    }

    public void setROM(ROM rom) {
        if (rom == null) {
            throw new IllegalArgumentException("Parameter 'rom' must not be null.");
        }
        this.rom = rom;
        this.setMD5(rom.getMD5());
        this.setCRC32(rom.getCRC32());
        this.setROMVersion(ROMVersion.getByCRC32(rom.getCRC32()));
    }

    public ROM getROM() {
        return this.rom;
    }

    public void setROMVersion(ROMVersion romVersion) {
        if (romVersion == null) {
            throw new IllegalArgumentException("Parameter 'romVersion' must not be null.");
        }
        this.romVersion = romVersion;
    }

    public ROMVersion getROMVersion() {
        return this.romVersion;
    }

    public void setMessage(String message) {
        if (message == null) {
            throw new IllegalArgumentException("Parameter 'message' must not be null.");
        }
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public static final class Attributes {
        public static final Attribute ID = new Attribute("id", DataTypes.WorkbookEntry_Id);
        public static final Attribute FOLDER_PATH = new Attribute("folderPath", DataTypes.WorkbookEntry_FolderPath);
        public static final Attribute FILE_NAME = new Attribute("fileName", DataTypes.WorkbookEntry_FileName);
        public static final Attribute MD5 = new Attribute("md5", DataTypes.WorkbookEntry_MD5);
        public static final Attribute CRC32 = new Attribute("crc32", DataTypes.WorkbookEntry_CRC32);
        public static final Attribute MESSAGE = new Attribute("message", DataTypes.WorkbookEntry_Message);

        private Attributes() {
        }
    }
}

