/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.atariroms.model;

import com.wudsn.tools.atariroms.Messages;
import com.wudsn.tools.atariroms.model.Comparison;
import com.wudsn.tools.atariroms.model.ComparisonEntry;
import com.wudsn.tools.atariroms.model.ROM;
import com.wudsn.tools.atariroms.model.Workbook;
import com.wudsn.tools.atariroms.model.WorkbookEntry;
import com.wudsn.tools.base.common.CoreException;
import com.wudsn.tools.base.common.FileUtility;
import com.wudsn.tools.base.common.HexUtility;
import com.wudsn.tools.base.common.MessageQueue;
import com.wudsn.tools.base.common.TextUtility;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public final class WorkbookLogic {
    public void checkFiles(Workbook workbook, List<File> filesList) {
        if (filesList == null) {
            throw new IllegalArgumentException("Parameter 'filesList' must not be null.");
        }
        ArrayList<File> resolvedFilesList = new ArrayList<File>();
        for (File file : filesList) {
            this.resolveFiles(resolvedFilesList, file);
        }
        Collections.sort(resolvedFilesList);
        workbook.clear();
        workbook.setResolvedFilesCount(resolvedFilesList.size());
        for (File file : resolvedFilesList) {
            this.checkFile(workbook, file);
        }
    }

    private void resolveFiles(List<File> filesList, File file) {
        if (filesList == null) {
            throw new IllegalArgumentException("Parameter 'filesList' must not be null.");
        }
        if (filesList.contains(file)) {
            return;
        }
        if (file == null) {
            throw new IllegalArgumentException("Parameter 'file' must not be null.");
        }
        if (file.isDirectory()) {
            File[] innerFiles = file.listFiles();
            if (innerFiles != null) {
                File[] fileArray = innerFiles;
                int n = innerFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File innerFile = fileArray[n2];
                    this.resolveFiles(filesList, innerFile);
                    ++n2;
                }
            }
        } else {
            filesList.add(file.getAbsoluteFile());
        }
    }

    private void checkFile(Workbook workbook, File file) {
        byte[] content;
        if (workbook == null) {
            throw new IllegalArgumentException("Parameter 'workbook' must not be null.");
        }
        if (file == null) {
            throw new IllegalArgumentException("Parameter 'file' must not be null.");
        }
        WorkbookEntry entry = new WorkbookEntry(file);
        workbook.addEntry(entry);
        try {
            content = FileUtility.readBytes(file, 65536L, true);
        }
        catch (CoreException ex) {
            entry.setMessage(ex.getMessage());
            return;
        }
        ROM rom = new ROM(content);
        entry.setROM(rom);
        ROM fixture = rom.createFixture();
        if (!fixture.contentEquals(rom)) {
            entry.setMessage("Incorrect checksums");
            entry = new WorkbookEntry(file);
            entry.setFileName(String.valueOf(entry.getFileName()) + " (fixed)");
            workbook.addEntry(entry);
            entry.setROM(fixture);
            entry.setMessage("With corrected checksums");
        }
    }

    public Comparison compareEntries(Workbook workbook, List<WorkbookEntry> selectedEntries, MessageQueue messageQueue) {
        if (workbook == null) {
            throw new IllegalArgumentException("Parameter 'workbook' must not be null.");
        }
        if (selectedEntries == null) {
            throw new IllegalArgumentException("Parameter 'selectedEntries' must not be null.");
        }
        if (messageQueue == null) {
            throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
        }
        if (selectedEntries.size() < 2) {
            messageQueue.sendMessage(workbook, null, Messages.E103, TextUtility.formatAsDecimal(2L));
            return null;
        }
        ArrayList<WorkbookEntry> validEntries = new ArrayList<WorkbookEntry>();
        int fileSize = -1;
        int i = 0;
        while (i < selectedEntries.size()) {
            WorkbookEntry entry = selectedEntries.get(i);
            ROM rom = entry.getROM();
            if (rom != null) {
                if (fileSize == -1) {
                    fileSize = rom.getSize();
                }
                if (rom.getSize() == fileSize) {
                    validEntries.add(entry);
                }
            }
            ++i;
        }
        if (validEntries.size() < 2) {
            messageQueue.sendMessage(workbook, null, Messages.E104, TextUtility.formatAsDecimal(2L));
            return null;
        }
        if (validEntries.size() > 5) {
            messageQueue.sendMessage(workbook, null, Messages.E105, TextUtility.formatAsDecimal(5L));
            return null;
        }
        Comparison result = new Comparison(validEntries);
        HashMap<Integer, Integer> colorMap = new HashMap<Integer, Integer>();
        int offset = 0;
        while (offset < fileSize) {
            boolean same = true;
            int i2 = 0;
            int colorIndex = 0;
            ROM rom = ((WorkbookEntry)validEntries.get(i2)).getROM();
            int b0 = rom.getByte(offset);
            colorMap.clear();
            colorMap.put(b0, colorIndex);
            i2 = 1;
            while (i2 < validEntries.size()) {
                Integer key;
                Integer colorValue;
                int b1 = ((WorkbookEntry)validEntries.get(i2)).getROM().getByte(offset);
                if (b1 != b0) {
                    same = false;
                }
                if ((colorValue = (Integer)colorMap.get(key = Integer.valueOf(b1))) == null) {
                    colorMap.put(key, ++colorIndex);
                }
                ++i2;
            }
            if (!same) {
                ComparisonEntry entry = result.createEntry(offset, rom.toAddress(offset));
                i2 = 0;
                while (i2 < validEntries.size()) {
                    int value = ((WorkbookEntry)validEntries.get(i2)).getROM().getByte(offset);
                    entry.setValue(i2, "$" + HexUtility.getByteValueHexString(value), (Integer)colorMap.get(value));
                    ++i2;
                }
                result.addEntry(entry);
            }
            ++offset;
        }
        return result;
    }
}

