/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.atariroms.ui;

import com.wudsn.tools.atariroms.DataTypes;
import com.wudsn.tools.atariroms.Preferences;
import com.wudsn.tools.atariroms.Texts;
import com.wudsn.tools.atariroms.model.Comparison;
import com.wudsn.tools.atariroms.ui.ComparisonEntryPanel;
import com.wudsn.tools.base.common.MessageQueue;
import com.wudsn.tools.base.gui.IntegerField;
import com.wudsn.tools.base.gui.ModalDialog;
import com.wudsn.tools.base.gui.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SpringLayout;

public final class ComparisonDialog
extends ModalDialog {
    private IntegerField entriesCountField;
    private ComparisonEntryPanel entryPanel;
    private Comparison comparison;

    public ComparisonDialog(JFrame parent, Preferences preferences, Comparison comparison) {
        super(parent, Texts.ComparisonDialog_Title);
        if (comparison == null) {
            throw new IllegalArgumentException("Parameter 'comparison' must not be null.");
        }
        this.comparison = comparison;
        JPanel topPanel = new JPanel(new SpringLayout());
        this.entriesCountField = SpringUtilities.createIntegerField(topPanel, DataTypes.Comparison_EntriesCount);
        this.entriesCountField.setEditable(false);
        SpringUtilities.makeCompactGrid(topPanel, 1, 2, 6, 6, 6, 6);
        this.entryPanel = new ComparisonEntryPanel(preferences, comparison);
        this.fieldsPane.setLayout(new BorderLayout());
        this.fieldsPane.add((Component)topPanel, "North");
        this.fieldsPane.add((Component)this.entryPanel, "Center");
    }

    public void showModal(MessageQueue messageQueue) {
        if (messageQueue == null) {
            throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
        }
        this.showModal(this.entryPanel.getTable());
    }

    @Override
    protected void dataToUi() {
        this.entriesCountField.setValue(this.comparison.getEntryCount());
    }
}

