/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.atariroms.ui;

import com.wudsn.tools.atariroms.Preferences;
import com.wudsn.tools.atariroms.model.ROM;
import com.wudsn.tools.atariroms.model.ROMVersion;
import com.wudsn.tools.atariroms.model.Workbook;
import com.wudsn.tools.atariroms.model.WorkbookEntry;
import com.wudsn.tools.base.gui.AttributeTableModel;
import com.wudsn.tools.base.gui.AttributeTablePanel;
import com.wudsn.tools.base.repository.Attribute;
import java.awt.Font;
import javax.swing.table.DefaultTableCellRenderer;

public final class WorkbookEntriesPanel
extends AttributeTablePanel {
    private Workbook workbook;

    public WorkbookEntriesPanel(Preferences preferences, Workbook workbook) {
        super(new TableModel(workbook), preferences, "workbookEntriesTable");
        this.workbook = workbook;
        workbook.setEntriesTableModel((AttributeTableModel)this.getTable().getModel());
    }

    public void setSelectedWorkbookEntry(WorkbookEntry workbookEntry, Attribute attribute) {
        if (workbookEntry == null) {
            throw new IllegalArgumentException("Parameter 'workbookEntry' must not be null.");
        }
        int modelRowIndex = this.workbook.getUnmodifiableEntriesList().indexOf(workbookEntry);
        this.table.selectCell(modelRowIndex, attribute);
    }

    public static final class TableModel
    extends AttributeTableModel {
        private Workbook workbook;

        public TableModel(Workbook workbook) {
            if (workbook == null) {
                throw new IllegalArgumentException("Parameter 'workbook' must not be null.");
            }
            this.workbook = workbook;
            final Font monoSpacedFont = new Font("Monospaced", 0, 12);
            DefaultTableCellRenderer cellRenderer = new DefaultTableCellRenderer(){

                @Override
                protected void setValue(Object value) {
                    this.setFont(monoSpacedFont);
                    super.setValue(value);
                }
            };
            this.addColumn(WorkbookEntry.Attributes.ID, 2);
            this.addColumn(WorkbookEntry.Attributes.FOLDER_PATH, 2);
            this.addColumn(WorkbookEntry.Attributes.FILE_NAME, 2);
            this.addColumn(WorkbookEntry.Attributes.MD5, 2, cellRenderer, null);
            this.addColumn(WorkbookEntry.Attributes.CRC32, 2, cellRenderer, null);
            this.addColumn(ROM.Attributes.FPP_CHECK_SUM, 2, cellRenderer, null);
            this.addColumn(ROM.Attributes.OS1_CHECK_SUM, 2, cellRenderer, null);
            this.addColumn(ROM.Attributes.OS2_CHECK_SUM, 2, cellRenderer, null);
            this.addColumn(ROMVersion.Attributes.TYPE, 2);
            this.addColumn(ROMVersion.Attributes.REVISION, 2);
            this.addColumn(ROMVersion.Attributes.NORM, 2);
            this.addColumn(ROMVersion.Attributes.YEAR, 2);
            this.addColumn(ROMVersion.Attributes.COMMENT, 2);
            this.addColumn(ROMVersion.Attributes.PARTS, 2);
            this.addColumn(WorkbookEntry.Attributes.MESSAGE, 2);
        }

        @Override
        public Object getValueAt(int row, int column) {
            WorkbookEntry entry = this.workbook.getEntry(row);
            ROM rom = entry.getROM();
            ROMVersion romVersion = entry.getROMVersion();
            if (romVersion == null) {
                romVersion = ROMVersion.UNKNOWN;
            }
            switch (column) {
                case 0: {
                    return this.table.convertRowIndexToView(row) + 1;
                }
                case 1: {
                    return entry.getFolderPath();
                }
                case 2: {
                    return entry.getFileName();
                }
                case 3: {
                    return entry.getMD5();
                }
                case 4: {
                    return entry.getCRC32();
                }
                case 5: {
                    return rom != null ? ROM.toHexBytes(rom.getFPP()) : "";
                }
                case 6: {
                    return rom != null ? ROM.toHexBytes(rom.getOS1()) : "";
                }
                case 7: {
                    return rom != null ? ROM.toHexBytes(rom.getOS2()) : "";
                }
                case 8: {
                    return romVersion.getType();
                }
                case 9: {
                    return romVersion.getRevision();
                }
                case 10: {
                    return romVersion.getNorm();
                }
                case 11: {
                    return romVersion.getYear();
                }
                case 12: {
                    return romVersion.getComment();
                }
                case 13: {
                    return romVersion.getParts();
                }
                case 14: {
                    return entry.getMessage();
                }
            }
            throw new IllegalArgumentException("Invalid column " + column + ".");
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public int getRowCount() {
            return this.workbook.getEntryCount();
        }

        public final class Columns {
            public static final int ID = 0;
            public static final int FOLDER_PATH = 1;
            public static final int FILE_NAME = 2;
            public static final int MD5 = 3;
            public static final int CRC32 = 4;
            public static final int FPP_CHECK_SUM = 5;
            public static final int OS1_CHECK_SUM = 6;
            public static final int OS2_CHECK_SUM = 7;
            public static final int TYPE = 8;
            public static final int REVISION = 9;
            public static final int NORM = 10;
            public static final int YEAR = 11;
            public static final int COMMENT = 12;
            public static final int PARTS = 13;
            public static final int MESSAGE = 14;
        }
    }
}

