/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.base.gui;

import com.wudsn.tools.base.gui.AttributeTable;
import com.wudsn.tools.base.repository.Attribute;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public abstract class AttributeTableModel
extends AbstractTableModel {
    private final List<Column> columns = new ArrayList<Column>();
    protected AttributeTable table;

    protected AttributeTableModel() {
    }

    protected final void addColumn(Attribute attribute, int flags) {
        this.addColumn(attribute, flags, null, null);
    }

    protected final void addColumn(Attribute attribute, int flags, DefaultTableCellRenderer defaultTableCellRenderer, DefaultCellEditor defaultCellEditor) {
        this.columns.add(new Column(attribute, flags, defaultTableCellRenderer, defaultCellEditor));
    }

    @Override
    public final int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public final String getColumnName(int column) {
        return this.columns.get(column).getAttribute().getDataType().getLabelWithoutMnemonics();
    }

    public final Class<? extends Object> getColumnClass(int column) {
        return this.columns.get(column).getAttribute().getDataType().getValueClass();
    }

    public final Column getColumn(int index) {
        return this.columns.get(index);
    }

    public final int getColumnIndex(Attribute attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException("Parameter 'attribute' must not be null.");
        }
        int index = -1;
        int i = 0;
        while (i < this.columns.size() && index == -1) {
            if (this.columns.get(i).getAttribute() == attribute) {
                index = i;
            }
            ++i;
        }
        return index;
    }

    public final void setTable(AttributeTable table) {
        if (table == null) {
            throw new IllegalArgumentException("Parameter 'table' must not be null.");
        }
        this.table = table;
    }

    public static final class Column {
        public static final int HIDDEN = 0;
        public static final int FIXED = 1;
        public static final int VISIBLE = 2;
        private Attribute attribute;
        private int flags;
        private DefaultTableCellRenderer defaultTableCellRenderer;
        private DefaultCellEditor defaultCellEditor;

        Column(Attribute attribute, int flags, DefaultTableCellRenderer defaultTableCellRenderer, DefaultCellEditor defaultCellEditor) {
            this.attribute = attribute;
            this.flags = flags;
            this.defaultTableCellRenderer = defaultTableCellRenderer;
            this.defaultCellEditor = defaultCellEditor;
        }

        public Attribute getAttribute() {
            return this.attribute;
        }

        public boolean isFixed() {
            return (this.flags & 1) == 1;
        }

        public boolean isVisible() {
            return this.isFixed() || (this.flags & 2) == 2;
        }

        public DefaultTableCellRenderer getDefaultTableCellRenderer() {
            return this.defaultTableCellRenderer;
        }

        public DefaultCellEditor getDefaultCellEditor() {
            return this.defaultCellEditor;
        }
    }
}

