/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.base.gui;

import com.wudsn.tools.base.Actions;
import com.wudsn.tools.base.gui.ElementFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SpringLayout;

public abstract class ModalDialog
extends JDialog
implements ActionListener {
    protected final JPanel fieldsPane;
    private final JButton okButton;
    private final JButton cancelButton;
    protected transient boolean okPressed;

    public ModalDialog(JFrame parent, String title) {
        super(parent, title, true);
        Container pane = this.getContentPane();
        JPanel dataPane = new JPanel(new BorderLayout());
        pane.add((Component)dataPane, "North");
        this.fieldsPane = new JPanel(new SpringLayout());
        dataPane.add((Component)this.fieldsPane, "North");
        this.okButton = ElementFactory.createButton(Actions.ButtonBar_OK);
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModalDialog.this.actionPerformed(e);
            }
        };
        this.cancelButton = new JButton(cancelAction);
        ElementFactory.setButtonTextAndMnemonic(this.cancelButton, Actions.ButtonBar_Cancel);
        Box buttonBar = ElementFactory.createButtonBar();
        buttonBar.add(this.okButton);
        buttonBar.add(this.cancelButton);
        pane.add((Component)buttonBar, "South");
        this.okButton.addActionListener(this);
        ElementFactory.setDialogDefaultButtons(this.getRootPane(), this.okButton, this.cancelButton.getAction());
    }

    protected final void showModal(JComponent focusField) {
        if (focusField == null) {
            throw new IllegalArgumentException("Parameter 'focusField' must not be null.");
        }
        this.dataToUi();
        this.okPressed = false;
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        focusField.requestFocus();
        this.setVisible(true);
    }

    protected void dataFromUi() {
    }

    protected void dataToUi() {
    }

    protected boolean validateOK() {
        return true;
    }

    @Override
    public final void actionPerformed(ActionEvent evt) {
        boolean bl = this.okPressed = evt.getSource() == this.okButton;
        if (this.okPressed) {
            this.dataFromUi();
            this.dataToUi();
            if (!this.validateOK()) {
                return;
            }
        }
        this.setVisible(false);
    }
}

