/**
 * Copyright (C) 2015 <a href="http://www.wudsn.com" target="_top">Peter Dell</a>
 *
 * This file is part of the Atari ROM Maker.
 * 
 * ROM Checker is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 * 
 * ROM Checker is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with the Atari ROM Maker  If not, see <http://www.gnu.org/licenses/>.
 */

package com.wudsn.tools.atarirommaker;

import java.awt.EventQueue;

import com.wudsn.tools.atarirommaker.model.ROM;
import com.wudsn.tools.base.common.Application;
import com.wudsn.tools.base.common.MessageQueue;

/**
 * Atari ROM Maker by JAC!
 * 
 * @author Peter Dell
 */

public final class AtariROMMaker {

    public final class Commands {
	public static final String LOAD = "load";
	public static final String CONVERT_TO_CAR = "convertToCAR";
	public static final String SAVE = "save";
    }

    // Static instance
    static AtariROMMaker instance;

    // Message queue
    private MessageQueue messageQueue;
    private ROM rom;

    public static void main(final String[] args) {
	if (args == null) {
	    throw new IllegalArgumentException("Parameter 'args' must not be null.");
	}

	// Use the event dispatch thread for Swing components
	EventQueue.invokeLater(new Runnable() {

	    @Override
	    public void run() {

		Application.createInstance("http://www.wudsn.com/productions/atari800/atarirommaker/atarirommaker.zip",
			"AtariROMMaker.jar", "com/wudsn/tools/atariromchecker/AtariROMMaker.version");
		instance = new AtariROMMaker();
		instance.run(args);
	    }
	});
    }

    AtariROMMaker() {
    }

    void run(String[] args) {
	if (args == null) {
	    throw new IllegalArgumentException("Parameter 'args' must not be null.");
	}

	messageQueue = new MessageQueue();
	rom = new ROM();

	// Handle command line.
	AtariROMMakerConsole console = new AtariROMMakerConsole();
	console.runConsoleCommands(args, true, rom, messageQueue);
    }

}