/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.atarirommaker;

import com.wudsn.tools.atarirommaker.Actions;
import com.wudsn.tools.atarirommaker.model.ROM;
import com.wudsn.tools.base.Messages;
import com.wudsn.tools.base.common.MessageQueue;
import com.wudsn.tools.base.console.Console;
import com.wudsn.tools.base.console.ConsoleCommandExecution;
import com.wudsn.tools.base.console.ConsoleCommandParser;
import java.io.File;
import java.util.List;

public final class AtariROMMakerConsole {
    private ConsoleCommandParser consoleCommandParser = new ConsoleCommandParser("-jar AtariROMMaker.jar");

    public AtariROMMakerConsole() {
        this.consoleCommandParser.addCommand(Actions.Load, "load").addParameter(ROM.Attributes.FILE_PATH, 2);
        this.consoleCommandParser.addCommand(Actions.ConvertToCAR, "convertToCAR").addParameter(ROM.Attributes.CARTRDIGE_TYPE, 2);
        this.consoleCommandParser.addCommand(Actions.Save, "save").addParameter(ROM.Attributes.FILE_PATH, 2);
    }

    public boolean runConsoleCommands(String[] args, boolean mandatory, ROM rom, MessageQueue messageQueue) {
        if (args == null) {
            throw new IllegalArgumentException("Parameter 'args' must not be null.");
        }
        if (rom == null) {
            throw new IllegalArgumentException("Parameter 'rom' must not be null.");
        }
        if (messageQueue == null) {
            throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
        }
        this.consoleCommandParser.parse(args, mandatory, messageQueue);
        List<ConsoleCommandExecution> parseResult = this.consoleCommandParser.getParseResult();
        Console console = this.consoleCommandParser.getConsole();
        if (!parseResult.isEmpty()) {
            boolean errorOccurred = false;
            int i = 0;
            while (i < parseResult.size() && !errorOccurred) {
                File file;
                ConsoleCommandExecution commandExecution = parseResult.get(i);
                messageQueue.clear();
                messageQueue.sendMessage(this, null, Messages.S254, commandExecution.toString());
                String actionCommand = commandExecution.getConsoleCommand().getActionCommand();
                if (actionCommand.equals("load")) {
                    file = commandExecution.getParameterValueAsFile(ROM.Attributes.FILE_PATH);
                    if (file != null) {
                        rom.load(file, messageQueue);
                    }
                } else if (actionCommand.equals("save")) {
                    file = commandExecution.getParameterValueAsFile(ROM.Attributes.FILE_PATH);
                    if (file != null) {
                        rom.save(file, messageQueue);
                    }
                } else if (actionCommand.equals("convertToCAR")) {
                    String cartridgeTypeId = commandExecution.getParameterValueAsString(ROM.Attributes.CARTRDIGE_TYPE);
                    if (cartridgeTypeId != null) {
                        rom.convertToCAR(cartridgeTypeId, messageQueue);
                    }
                } else {
                    throw new RuntimeException("Unhandled action command '" + actionCommand + "'.");
                }
                errorOccurred = messageQueue.containsError();
                console.displayMessageQueue(messageQueue);
                ++i;
            }
            return true;
        }
        return false;
    }
}

