/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.atarirommaker.model;

import com.wudsn.tools.atarirommaker.DataTypes;
import com.wudsn.tools.atarirommaker.Messages;
import com.wudsn.tools.base.atari.CartridgeFileUtility;
import com.wudsn.tools.base.atari.CartridgeType;
import com.wudsn.tools.base.common.CoreException;
import com.wudsn.tools.base.common.FileUtility;
import com.wudsn.tools.base.common.MessageQueue;
import com.wudsn.tools.base.common.TextUtility;
import com.wudsn.tools.base.repository.Attribute;
import com.wudsn.tools.base.repository.ValueSet;
import java.io.File;
import java.util.List;

public final class ROM {
    private byte[] content = new byte[0];

    public boolean load(File file, MessageQueue messageQueue) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 'file' must not be null.");
        }
        if (messageQueue == null) {
            throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
        }
        try {
            this.content = FileUtility.readBytes(file, 0x8000000L, true);
        }
        catch (CoreException ex) {
            messageQueue.sendMessage(ex.createMessageQueueEntry(this, Attributes.FILE_PATH));
            return false;
        }
        messageQueue.sendMessage(this, null, Messages.I100, file.getAbsolutePath(), TextUtility.formatAsMemorySize(file.length()));
        return true;
    }

    public boolean save(File file, MessageQueue messageQueue) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 'file' must not be null.");
        }
        if (messageQueue == null) {
            throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
        }
        try {
            FileUtility.writeBytes(file, this.content);
        }
        catch (CoreException ex) {
            messageQueue.sendMessage(ex.createMessageQueueEntry(this, Attributes.FILE_PATH));
            return false;
        }
        messageQueue.sendMessage(this, null, Messages.I101, file.getAbsolutePath(), TextUtility.formatAsMemorySize(file.length()));
        return true;
    }

    public boolean convertToCAR(String cartridgeTypeId, MessageQueue messageQueue) {
        if (messageQueue == null) {
            throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
        }
        ValueSet cartridgeType = null;
        List<CartridgeType> cartridgeTypes = CartridgeType.getValues();
        int i = 0;
        while (i < cartridgeTypes.size() && cartridgeType == null) {
            if (Integer.toString(cartridgeTypes.get(i).getNumericId()).equals(cartridgeTypeId)) {
                cartridgeType = cartridgeTypes.get(i);
            }
            ++i;
        }
        if (cartridgeType == null) {
            messageQueue.sendMessage(this, Attributes.CARTRDIGE_TYPE, Messages.E103, cartridgeTypeId);
            return false;
        }
        String cartridgeTypeText = String.valueOf(cartridgeTypeId) + " - " + cartridgeType.getText();
        long sourceSize = this.content.length;
        long targetSize = ((CartridgeType)cartridgeType).getSizeInKB() * 1024;
        if (sourceSize != targetSize) {
            messageQueue.sendMessage(this, Attributes.CARTRDIGE_TYPE, Messages.E104, TextUtility.formatAsMemorySize(sourceSize), TextUtility.formatAsMemorySize(targetSize), cartridgeTypeText);
            return false;
        }
        byte[] header = CartridgeFileUtility.createCartridgeHeaderWithCheckSum(((CartridgeType)cartridgeType).getNumericId(), this.content);
        byte[] newContent = new byte[header.length + this.content.length];
        System.arraycopy(header, 0, newContent, 0, header.length);
        System.arraycopy(this.content, 0, newContent, header.length, this.content.length);
        this.content = newContent;
        messageQueue.sendMessage(this, null, Messages.I102, cartridgeTypeText);
        return true;
    }

    public static final class Attributes {
        public static final Attribute FILE_PATH = new Attribute("filePath", DataTypes.ROM_FilePath);
        public static final Attribute CARTRDIGE_TYPE = new Attribute("cartridgeType", DataTypes.ROM_CartridgeType);

        private Attributes() {
        }
    }
}

