/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.base.atari;

public final class CartridgeFileUtility {
    public static final int CART_HEADER_SIZE = 16;

    private CartridgeFileUtility() {
    }

    public static int getCartridgeTypeNumericId(byte[] content) {
        if (content == null) {
            throw new IllegalArgumentException("Parameter 'content' must not be null.");
        }
        int cartridgeTypeNumericId = 0;
        if (content.length > 16 && content.length % 1024 == 16 && content[0] == 67 && content[1] == 65 && content[2] == 82 && content[3] == 84) {
            cartridgeTypeNumericId = content[4] & 0xFF;
            cartridgeTypeNumericId <<= 8;
            cartridgeTypeNumericId |= content[5] & 0xFF;
            cartridgeTypeNumericId <<= 8;
            cartridgeTypeNumericId |= content[6] & 0xFF;
            cartridgeTypeNumericId <<= 8;
            cartridgeTypeNumericId |= content[7] & 0xFF;
        }
        return cartridgeTypeNumericId;
    }

    private static int getCartridgeHeaderCheckSum(byte[] content, int startOffset) {
        if (content == null) {
            throw new IllegalArgumentException("Parameter 'content' must not be null.");
        }
        if (startOffset < 0) {
            throw new IllegalArgumentException("Parameter 'startOffset' must not be negative. Specified values is " + startOffset + ".");
        }
        int result = 0;
        int i = startOffset;
        while (i < content.length) {
            result += content[i] & 0xFF;
            ++i;
        }
        return result;
    }

    public static byte[] createCartridgeHeaderWithCheckSum(int cartridgeTypeNumericId, byte[] content) {
        if (content == null) {
            throw new IllegalArgumentException("Parameter 'content' must not be null.");
        }
        byte[] header = new byte[16];
        header[0] = 67;
        header[1] = 65;
        header[2] = 82;
        header[3] = 84;
        header[7] = (byte)(cartridgeTypeNumericId & 0xFF);
        header[6] = (byte)((cartridgeTypeNumericId >>>= 8) & 0xFF);
        header[5] = (byte)((cartridgeTypeNumericId >>>= 8) & 0xFF);
        header[4] = (byte)((cartridgeTypeNumericId >>>= 8) & 0xFF);
        int checkSum = CartridgeFileUtility.getCartridgeHeaderCheckSum(content, 0);
        header[11] = (byte)(checkSum & 0xFF);
        header[10] = (byte)((checkSum >>>= 8) & 0xFF);
        header[9] = (byte)((checkSum >>>= 8) & 0xFF);
        header[8] = (byte)((checkSum >>>= 8) & 0xFF);
        header[12] = 0;
        header[13] = 0;
        header[14] = 0;
        header[15] = 0;
        return header;
    }
}

