/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.thecart.common;

public final class ByteArrayUtility {
    public static final int KB = 1024;
    public static final int MB = 0x100000;
    private static final String[] hexStrings = new String[256];

    static {
        int i = 0;
        while (i < 256) {
            String s = Integer.toHexString(i).toUpperCase();
            ByteArrayUtility.hexStrings[i] = s.length() < 2 ? "0" + s : s;
            ++i;
        }
    }

    private ByteArrayUtility() {
    }

    public static int getIndexOf(byte[] content, int startOffset, int length, byte[] pattern) {
        if (content == null) {
            throw new IllegalArgumentException("Parameter 'content' must not be null.");
        }
        if (startOffset < 0) {
            throw new IllegalArgumentException("Parameter 'startOffset' must not be negative. Specified value is " + startOffset + ".");
        }
        if (length < 0) {
            throw new IllegalArgumentException("Parameter 'startOffset' must not be negative. Specified value is " + length + ".");
        }
        if (pattern == null) {
            throw new IllegalArgumentException("Parameter 'pattern' must not be null.");
        }
        int endOffset = Math.min(startOffset + length - pattern.length + 1, content.length);
        int i = startOffset;
        while (i < endOffset) {
            if (content[i] == pattern[0]) {
                boolean equal = true;
                int j = 1;
                while (equal && j < pattern.length) {
                    equal = content[i + j] == pattern[j];
                    ++j;
                }
                if (equal) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    public static String toHexString(byte[] content) {
        if (content == null) {
            throw new IllegalArgumentException("Parameter 'content' must not be null.");
        }
        StringBuilder builder = new StringBuilder(content.length * 2);
        int i = 0;
        while (i < content.length) {
            builder.append(hexStrings[content[i] & 0xFF]);
            ++i;
        }
        return builder.toString();
    }
}

