/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.thecart.common;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public final class ClassPathUtility {
    public static URI getJarURI() {
        String jarPath;
        ClassLoader classLoader = ClassPathUtility.class.getClassLoader();
        URL url = classLoader.getResource(jarPath = String.valueOf(ClassPathUtility.class.getName().replace('.', '/')) + ".class");
        if (url == null) {
            url = ClassLoader.getSystemResource(jarPath);
        }
        if (url == null) {
            return null;
        }
        try {
            String uriString;
            int index;
            URI uri = url.toURI();
            if (uri.getScheme().equals("jar") && (index = (uriString = uri.getRawSchemeSpecificPart()).lastIndexOf("!")) > 0) {
                uriString = uriString.substring(0, index);
                uri = new URI(uriString);
                return uri;
            }
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException("Error when resolving URL '" + url + "'.");
        }
        return null;
    }

    public static File getJarFile() {
        URI uri = ClassPathUtility.getJarURI();
        File result = null;
        if (uri != null) {
            result = new File(uri);
        }
        return result;
    }

    public static File getJarFolder() {
        File result = ClassPathUtility.getJarFile();
        if (result != null) {
            result = result.getParentFile();
        }
        return result;
    }
}

