/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.thecart.common;

import com.wudsn.thecart.Messages;
import com.wudsn.thecart.common.CoreException;
import com.wudsn.thecart.common.StringUtility;
import com.wudsn.thecart.common.TextUtility;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.swing.filechooser.FileFilter;

public final class FileUtility {
    public static final int MAX_SIZE_UNLIMITED = -1;
    public static final int MAX_SIZE_1MB = 0x100000;
    private static final int BUFFER_SIZE = 1024;

    private FileUtility() {
    }

    public static String getAbsolutePath(String filePath) {
        String result;
        if (filePath == null) {
            throw new IllegalArgumentException("Parameter 'filePath' must not be null.");
        }
        File file = new File(filePath);
        try {
            result = file.getCanonicalPath();
        }
        catch (IOException ignore) {
            result = file.getAbsolutePath();
        }
        return result;
    }

    public static FileFilter createFileExtensionFileFilter(String fileExtension, String filterDescription) {
        if (fileExtension == null) {
            throw new IllegalArgumentException("Parameter 'fileExtension' must not be null.");
        }
        if (StringUtility.isEmpty(fileExtension)) {
            throw new IllegalArgumentException("Parameter 'fileExtension' must not be empty.");
        }
        if (fileExtension.charAt(0) != '.') {
            throw new IllegalArgumentException("Parameter 'fileExtension' must start with a '.'");
        }
        if (filterDescription == null) {
            throw new IllegalArgumentException("Parameter 'filterDescription' must not be null.");
        }
        if (StringUtility.isEmpty(filterDescription)) {
            throw new IllegalArgumentException("Parameter 'filterDescription' must not be empty.");
        }
        String fullFilterDescription = String.valueOf(filterDescription) + " (*" + fileExtension + ")";
        FileExtensionFileFilter fileExtensionFilefilter = new FileExtensionFileFilter(fileExtension, fullFilterDescription);
        return fileExtensionFilefilter;
    }

    public static File normalizeFileExtension(File file, String fileExtension) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 'file' must not be null.");
        }
        if (fileExtension == null) {
            throw new IllegalArgumentException("Parameter 'fileExtension' must not be null.");
        }
        if (StringUtility.isEmpty(fileExtension)) {
            throw new IllegalArgumentException("Parameter 'fileExtension' must not be empty.");
        }
        if (fileExtension.charAt(0) != '.') {
            throw new IllegalArgumentException("Parameter 'fileExtension' must start with a '.'");
        }
        if (!file.getName().toLowerCase().endsWith(fileExtension)) {
            String filePath = file.getAbsolutePath();
            int index = file.getName().lastIndexOf(46);
            if (index > 0) {
                int strip = file.getName().length() - index;
                filePath = filePath.substring(0, filePath.length() - strip);
            }
            file = new File(String.valueOf(filePath) + fileExtension);
        }
        return file;
    }

    public static InputStream openInputStream(File ioFile) throws CoreException {
        FileInputStream inputStream;
        if (ioFile == null) {
            throw new IllegalArgumentException("Parameter 'ioFile' must not be null.");
        }
        String filePath = ioFile.getAbsolutePath();
        if (!ioFile.exists()) {
            throw new CoreException(Messages.E203, filePath);
        }
        if (!ioFile.isFile()) {
            throw new CoreException(Messages.E204, filePath);
        }
        try {
            inputStream = new FileInputStream(ioFile);
        }
        catch (FileNotFoundException ex) {
            throw new CoreException(Messages.E205, filePath, ex.getLocalizedMessage());
        }
        return inputStream;
    }

    public static byte[] readBytes(File ioFile, long maxSize, boolean errorOnMaxSizeExceeded) throws CoreException {
        if (ioFile == null) {
            throw new IllegalArgumentException("Parameter 'ioFile' must not be null.");
        }
        InputStream inputStream = FileUtility.openInputStream(ioFile);
        return FileUtility.readBytes(ioFile.getAbsolutePath(), inputStream, maxSize, errorOnMaxSizeExceeded);
    }

    public static byte[] readBytes(String filePath, InputStream inputStream, long maxSize, boolean errrorOnMaxSizeExceeded) throws CoreException {
        byte[] result;
        if (filePath == null) {
            throw new IllegalArgumentException("Parameter 'filePath' must not be null.");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("Parameter 'inputStream' must not be null.");
        }
        if (maxSize < -1L) {
            throw new IllegalArgumentException("Parameter 'maxSize' must not be less than -1.");
        }
        try {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                int size = 0;
                byte[] buffer = new byte[1024];
                int count = 0;
                do {
                    if ((count = inputStream.read(buffer)) <= 0) continue;
                    bos.write(buffer, 0, count);
                    size += count;
                } while (count > -1 && (maxSize == -1L || (long)size <= maxSize));
                if (maxSize != -1L && (long)size > maxSize && errrorOnMaxSizeExceeded) {
                    throw new CoreException(Messages.E207, filePath, TextUtility.formatAsMemorySize(maxSize));
                }
                bos.close();
                result = bos.toByteArray();
            }
            catch (IOException ex) {
                throw new CoreException(Messages.E206, filePath, ex.getLocalizedMessage());
            }
        }
        finally {
            FileUtility.closeInputStream(new File(filePath), inputStream);
        }
        return result;
    }

    public static void closeInputStream(File ioFile, InputStream inputStream) throws CoreException {
        if (ioFile == null) {
            throw new IllegalArgumentException("Parameter 'ioFile' must not be null.");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("Parameter 'inputStream' must not be null.");
        }
        try {
            inputStream.close();
        }
        catch (IOException ex) {
            throw new CoreException(Messages.E209, ioFile.getAbsolutePath(), ex.getLocalizedMessage());
        }
    }

    public static OutputStream openOutputStream(File ioFile) throws CoreException {
        FileOutputStream outputStream;
        if (ioFile == null) {
            throw new IllegalArgumentException("Parameter 'ioFile' must not be null.");
        }
        String filePath = ioFile.getAbsolutePath();
        if (!ioFile.exists()) {
            try {
                ioFile.createNewFile();
            }
            catch (IOException ex) {
                throw new CoreException(Messages.E210, filePath, ex.getLocalizedMessage());
            }
        }
        if (!ioFile.isFile()) {
            throw new CoreException(Messages.E204, filePath);
        }
        try {
            outputStream = new FileOutputStream(ioFile);
        }
        catch (FileNotFoundException ex) {
            throw new CoreException(Messages.E211, filePath, ex.getLocalizedMessage());
        }
        return outputStream;
    }

    public static void writeBytes(File ioFile, byte[] content) throws CoreException {
        if (ioFile == null) {
            throw new IllegalArgumentException("Parameter 'ioFile' must not be null.");
        }
        if (content == null) {
            throw new IllegalArgumentException("Parameter 'content' must not be null.");
        }
        OutputStream outputStream = FileUtility.openOutputStream(ioFile);
        try {
            FileUtility.writeBytes(ioFile, outputStream, content, 0, content.length);
        }
        finally {
            FileUtility.closeOutputStream(ioFile, outputStream);
        }
    }

    public static void writeBytes(File ioFile, OutputStream outputStream, byte[] content, int offset, int length) throws CoreException {
        if (ioFile == null) {
            throw new IllegalArgumentException("Parameter 'ioFile' must not be null.");
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("Parameter 'outputStream' must not be null.");
        }
        if (content == null) {
            throw new IllegalArgumentException("Parameter 'content' must not be null.");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("Parameter 'offset' must not be negative. Specified value is " + offset + ".");
        }
        if (length < 0) {
            throw new IllegalArgumentException("Parameter 'length' must not be negative. Specified value is " + length + ".");
        }
        try {
            outputStream.write(content, offset, length);
        }
        catch (IOException ex) {
            throw new CoreException(Messages.E212, ioFile.getAbsolutePath(), ex.getLocalizedMessage());
        }
    }

    public static void closeOutputStream(File ioFile, OutputStream outputStream) throws CoreException {
        if (ioFile == null) {
            throw new IllegalArgumentException("Parameter 'ioFile' must not be null.");
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("Parameter 'outputStream' must not be null.");
        }
        try {
            outputStream.close();
        }
        catch (IOException ex) {
            throw new CoreException(Messages.E213, ioFile.getAbsolutePath(), ex.getLocalizedMessage());
        }
    }

    public static String readString(File ioFile, long maxSize) throws CoreException {
        FileInputStream inputStream;
        if (ioFile == null) {
            throw new IllegalArgumentException("Parameter 'ioFile' must not be null.");
        }
        String filePath = ioFile.getAbsolutePath();
        if (!ioFile.exists()) {
            throw new CoreException(Messages.E203, filePath);
        }
        if (!ioFile.isFile()) {
            throw new CoreException(Messages.E204, filePath);
        }
        try {
            inputStream = new FileInputStream(ioFile);
        }
        catch (FileNotFoundException ex) {
            throw new CoreException(Messages.E205, filePath, ex.getLocalizedMessage());
        }
        return FileUtility.readString(filePath, inputStream, maxSize);
    }

    public static String readString(String filePath, InputStream inputStream, long maxSize) throws CoreException {
        if (filePath == null) {
            throw new IllegalArgumentException("Parameter 'filePath' must not be null.");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("Parameter 'inputStream' must not be null.");
        }
        if (maxSize < -1L) {
            throw new IllegalArgumentException("Parameter 'maxSize' must not be less than -1.");
        }
        StringBuilder result = new StringBuilder();
        try {
            try {
                InputStreamReader reader = new InputStreamReader(inputStream);
                int size = 0;
                char[] buffer = new char[1024];
                int count = 0;
                do {
                    if ((count = reader.read(buffer)) <= 0) continue;
                    result.append(buffer, 0, count);
                    size += count;
                } while (count > -1 && (maxSize == -1L || (long)size <= maxSize));
                if (maxSize != -1L && (long)size > maxSize) {
                    throw new CoreException(Messages.E208, filePath, TextUtility.formatAsDecimal(maxSize));
                }
                reader.close();
            }
            catch (IOException ex) {
                throw new CoreException(Messages.E206, filePath, ex.getLocalizedMessage());
            }
        }
        finally {
            FileUtility.closeInputStream(new File(filePath), inputStream);
        }
        return result.toString();
    }

    public static void writeString(File ioFile, String content) throws CoreException {
        if (ioFile == null) {
            throw new IllegalArgumentException("Parameter 'ioFile' must not be null.");
        }
        if (content == null) {
            throw new IllegalArgumentException("Parameter 'content' must not be null.");
        }
        OutputStream outputStream = FileUtility.openOutputStream(ioFile);
        String filePath = ioFile.getAbsolutePath();
        FileUtility.writeString(filePath, outputStream, content);
    }

    private static void writeString(String filePath, OutputStream outputStream, String content) throws CoreException {
        if (filePath == null) {
            throw new IllegalArgumentException("Parameter 'filePath' must not be null.");
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("Parameter 'outputStream' must not be null.");
        }
        if (content == null) {
            throw new IllegalArgumentException("Parameter 'content' must not be null.");
        }
        try {
            try {
                OutputStreamWriter writer = new OutputStreamWriter(outputStream);
                writer.write(content);
                writer.close();
            }
            catch (IOException ex) {
                throw new CoreException(Messages.E212, filePath, ex.getLocalizedMessage());
            }
        }
        catch (Throwable throwable) {
            try {
                outputStream.close();
            }
            catch (IOException ex) {
                throw new CoreException(Messages.E213, filePath, ex.getLocalizedMessage());
            }
            throw throwable;
        }
        try {
            outputStream.close();
        }
        catch (IOException ex) {
            throw new CoreException(Messages.E213, filePath, ex.getLocalizedMessage());
        }
    }

    public static void copyFile(File sourceFile, File targetFile) throws CoreException {
        if (sourceFile == null) {
            throw new IllegalArgumentException("Parameter 'sourceFile' must not be null.");
        }
        if (targetFile == null) {
            throw new IllegalArgumentException("Parameter 'targetFile' must not be null.");
        }
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = FileUtility.openInputStream(sourceFile);
            outputStream = FileUtility.openOutputStream(targetFile);
            byte[] buffer = new byte[1024];
            int count = 0;
            do {
                try {
                    count = inputStream.read(buffer);
                }
                catch (IOException ex) {
                    throw new CoreException(Messages.E206, sourceFile.getAbsolutePath(), ex.getLocalizedMessage());
                }
                if (count <= 0) continue;
                try {
                    outputStream.write(buffer, 0, count);
                }
                catch (IOException ex) {
                    throw new CoreException(Messages.E212, sourceFile.getAbsolutePath(), ex.getLocalizedMessage());
                }
            } while (count > -1);
            if (outputStream != null) {
                try {
                    FileUtility.closeOutputStream(targetFile, outputStream);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            try {
                FileUtility.closeInputStream(sourceFile, inputStream);
            }
            catch (CoreException coreException) {}
        }
        catch (CoreException ex) {
            if (outputStream != null) {
                try {
                    FileUtility.closeOutputStream(targetFile, outputStream);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            if (inputStream != null) {
                try {
                    FileUtility.closeInputStream(sourceFile, inputStream);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            throw ex;
        }
    }

    public static final class FileExtensionFileFilter
    extends FileFilter {
        private String fileExtension;
        private String fullFilterDescription;

        FileExtensionFileFilter(String fileExtension, String fullFilterDescription) {
            if (fileExtension == null) {
                throw new IllegalArgumentException("Parameter 'fileExtension' must not be null.");
            }
            if (fullFilterDescription == null) {
                throw new IllegalArgumentException("Parameter 'fullFilterDescription' must not be null.");
            }
            this.fileExtension = fileExtension;
            this.fullFilterDescription = fullFilterDescription;
        }

        public String getFileExtension() {
            return this.fileExtension;
        }

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().endsWith(this.fileExtension);
        }

        @Override
        public String getDescription() {
            return this.fullFilterDescription;
        }
    }
}

