/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.thecart.directory;

import com.wudsn.thecart.common.Main;
import com.wudsn.thecart.directory.Directory;
import java.io.IOException;

public final class DirectoryCreator
extends Main {
    public static void main(String[] args) {
        Directory directory = new Directory();
        String path = "C:\\Users\\D025328\\Documents\\Eclipse\\workspace.jac\\TheCart\\tst\\fandal\\atari.fandal.cz.csv";
        directory.readRecords(path, "files_nazev");
        DirectoryCreator.logInfo("Total Record Count: " + directory.getRecords().size());
        DirectoryCreator.logInfo("Total Title Length: " + directory.getTotalTitleLength());
        DirectoryCreator.logInfo("Maximum Title Length: " + directory.getMaximumTitleLength());
        DirectoryCreator.logInfo("Total Word Count: " + directory.getAllWordsSet().size());
        DirectoryCreator.logInfo("Total Word Length: " + directory.getAllWordsTotalLength());
        DirectoryCreator.logInfo("Maximum Word Length: " + directory.getAllWordsMaximumLength());
        DirectoryCreator.logInfo("Words: " + directory.getAllWordsSet());
        DirectoryCreator.logInfo(directory.getRecords().toString());
        directory.createLevels();
        directory.alignToBankSize(8192);
        DirectoryCreator.logInfo("Bank Size: " + directory.getBankSize() + " ($" + Integer.toHexString(directory.getBankSize()) + ")");
        DirectoryCreator.logInfo("Total Bank Count: " + directory.getTotalBankCount());
        DirectoryCreator.logInfo("Total Padding Bytes: " + directory.getTotalPaddingBytes());
        DirectoryCreator.logInfo("Total Level Count: " + directory.getLevels().size());
        try {
            int directorySize = directory.writeAsBinary(path);
            DirectoryCreator.logInfo("Total Directory Size: " + directorySize + " ($" + Integer.toHexString(directorySize) + ")");
        }
        catch (IOException ex) {
            DirectoryCreator.logError("Cannot write directory as binary. " + ex.getMessage());
        }
        try {
            directory.writeAsHTML(path);
        }
        catch (IOException ex) {
            DirectoryCreator.logError("Cannot write directory as HTML. " + ex.getMessage());
        }
    }
}

