/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.thecart.directory;

import com.wudsn.thecart.common.ASCIIString;
import java.io.ByteArrayOutputStream;

public class DirectoryWriter {
    private ByteArrayOutputStream outputStream = new ByteArrayOutputStream();

    public int getSize() {
        return this.outputStream.size();
    }

    public void writeByte(int value) {
        this.outputStream.write(value);
    }

    public void writeWord(int value) {
        this.outputStream.write(value);
        this.outputStream.write(value >>> 8);
    }

    public void writeString(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Parameter 'value' must not be null.");
        }
        byte[] bytes = ASCIIString.getBytes(value);
        int i = 0;
        while (i < bytes.length) {
            this.outputStream.write(bytes[i]);
            ++i;
        }
    }

    public void writePaddingBytes(int number) {
        int i = 0;
        while (i < number) {
            this.outputStream.write(0);
            ++i;
        }
    }

    public byte[] toByteArray() {
        return this.outputStream.toByteArray();
    }
}

