/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.thecart.directory;

import java.util.ArrayList;
import java.util.List;

final class HTMLWriter {
    private StringBuilder builder = new StringBuilder();
    private List<String> stack = new ArrayList<String>();
    private boolean tableBorder;

    public void begin(String tag, String attributes) {
        if (tag == null) {
            throw new IllegalArgumentException("Parameter 'tag' must not be null.");
        }
        this.builder.append("<");
        this.builder.append(tag);
        if (attributes != null) {
            this.builder.append(" ");
            this.builder.append(attributes);
        } else if ((tag.equals("th") || tag.equals("td")) && this.tableBorder) {
            this.builder.append(" style=\"border:1px solid\"");
        }
        this.builder.append(">");
        this.stack.add(tag);
    }

    public void end() {
        if (this.stack.isEmpty()) {
            throw new RuntimeException("No open tag: " + this.builder);
        }
        String tag = this.stack.remove(this.stack.size() - 1);
        this.builder.append("</");
        this.builder.append(tag);
        this.builder.append(">\n");
        if (tag.equals("table")) {
            this.tableBorder = false;
        }
    }

    public void writeText(String text) {
        if (text == null) {
            throw new IllegalArgumentException("Parameter 'text' must not be null.");
        }
        this.builder.append(text);
    }

    public void beginTable() {
        this.beginTable(false);
    }

    public void beginTable(boolean border) {
        this.begin("table", "style=\"text-align:left;\"");
        this.tableBorder = border;
    }

    public void beginTableRow() {
        this.begin("tr", null);
    }

    public void writeTableRow(String header, String text) {
        if (header == null) {
            throw new IllegalArgumentException("Parameter 'header' must not be null.");
        }
        if (text == null) {
            throw new IllegalArgumentException("Parameter 'text' must not be null.");
        }
        this.beginTableRow();
        this.writeTableHeader(header);
        this.writeTableCell(text);
        this.end();
    }

    public void writeTableRowCode(String header, String text) {
        this.beginTableRow();
        this.writeTableHeader(header);
        this.begin("td", "style=\"vertical-align:top;font-family:Courier New, Courier, monospace;border:1px solid;\"");
        if (text.trim().length() == 0) {
            text = "&nbsp;";
        }
        this.builder.append(text);
        this.end();
        this.end();
    }

    public void writeTableRowCode(String header, char character) {
        String text = "";
        if (character >= ' ') {
            text = Character.toString(character);
        }
        this.writeTableRowCode(header, text);
    }

    public void writeTableHeader(String text) {
        if (text == null) {
            throw new IllegalArgumentException("Parameter 'text' must not be null.");
        }
        this.begin("th", "style=\"border:1px solid;white-space:nowrap;\"");
        this.builder.append(text);
        this.end();
    }

    public void writeTableCell(String text) {
        if (text == null) {
            throw new IllegalArgumentException("Parameter 'text' must not be null.");
        }
        this.begin("td", null);
        this.builder.append(text);
        this.end();
    }

    public void beginList() {
        this.begin("ul", null);
    }

    public void writeListItem(String text) {
        if (text == null) {
            throw new IllegalArgumentException("Parameter 'text' must not be null.");
        }
        this.begin("li", null);
        this.builder.append(text);
        this.end();
    }

    public String toHTML() {
        if (!this.stack.isEmpty()) {
            throw new IllegalStateException("There are still open tags: " + this.stack + "\n" + this.builder.toString());
        }
        return this.builder.toString();
    }

    public static String getImage(String src, String alt, String text) {
        if (src == null) {
            throw new IllegalArgumentException("Parameter 'src' must not be null.");
        }
        if (alt == null) {
            throw new IllegalArgumentException("Parameter 'alt' must not be null.");
        }
        if (text == null) {
            throw new IllegalArgumentException("Parameter 'text' must not be null.");
        }
        return "<img src=\"" + src + "\" alt=\"" + alt + "\"> " + text + "</img>";
    }

    public static String getLink(String href, String text) {
        if (href == null) {
            throw new IllegalArgumentException("Parameter 'href' must not be null.");
        }
        if (text == null) {
            throw new IllegalArgumentException("Parameter 'text' must not be null.");
        }
        return "<a href=\"" + href + "\" >" + text + "</a>";
    }

    public static String getString(List<String> list) {
        if (list == null) {
            throw new IllegalArgumentException("Parameter 'list' must not be null.");
        }
        StringBuilder builder = new StringBuilder();
        int size = list.size();
        int i = 0;
        while (i < size) {
            builder.append(list.get(i));
            if (i < size - 1) {
                builder.append(" ");
            }
            ++i;
        }
        return builder.toString();
    }
}

