/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.thecart.gui;

import com.wudsn.thecart.common.ASCIIString;
import com.wudsn.thecart.common.MemorySize;
import com.wudsn.thecart.gui.AttributeTableColumnChooser;
import com.wudsn.thecart.gui.AttributeTableModel;
import com.wudsn.thecart.gui.AttributeTablePrinter;
import com.wudsn.thecart.gui.ElementFactory;
import com.wudsn.thecart.gui.ValueSetField;
import com.wudsn.thecart.model.Preferences;
import com.wudsn.thecart.repository.ValueSet;
import java.awt.Rectangle;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;

public final class AttributeTable
extends JTable {
    private AttributeTableModel model;
    private Preferences preferences;
    private String prefix;
    private List<TableColumn> allTableColumns;

    public AttributeTable(AttributeTableModel model, Preferences preferences, String prefix) {
        if (model == null) {
            throw new IllegalArgumentException("Parameter 'model' must not be null.");
        }
        if (preferences == null && prefix != null) {
            throw new IllegalArgumentException("Parameter 'preferences' must not be null if prefix is specified.");
        }
        if (preferences != null && prefix == null) {
            throw new IllegalArgumentException("Parameter 'prefix' must not be null if preferecces are specified.");
        }
        this.model = model;
        this.preferences = preferences;
        this.prefix = prefix;
        this.allTableColumns = new ArrayList<TableColumn>();
        this.setDefaultRenderer(MemorySize.class, ElementFactory.createMemorySizeTableCellRenderer());
        this.setDefaultRenderer(Number.class, ElementFactory.createNumberTableCellRenderer());
        TableRowSorter<AttributeTableModel> rowSorter = new TableRowSorter<AttributeTableModel>(model);
        int i = 0;
        while (i < model.getColumnCount()) {
            Class<? extends Object> columnClass = model.getColumnClass(i);
            if (columnClass.isAssignableFrom(ValueSet.class)) {
                ValueSetField<? extends Object> field = new ValueSetField<Object>(columnClass);
                this.setDefaultEditor(columnClass, new DefaultCellEditor(field));
            }
            if (columnClass.isAssignableFrom(ASCIIString.class)) {
                rowSorter.setComparator(i, ASCIIString.COMPARATOR);
            }
            ++i;
        }
        DefaultCellEditor editor = (DefaultCellEditor)this.getDefaultEditor(String.class);
        this.setDefaultEditor(ASCIIString.class, editor);
        editor.setClickCountToStart(1);
        editor = (DefaultCellEditor)this.getDefaultEditor(Number.class);
        editor.setClickCountToStart(1);
        this.setModel(model);
        this.setRowSorter(rowSorter);
        this.loadLayout();
        AttributeTableColumnChooser.install(this);
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        TableColumn tableColumn = this.columnModel.getColumn(column);
        TableCellRenderer renderer = this.model.getColumn(tableColumn.getModelIndex()).getDefaultTableCellRenderer();
        if (renderer == null) {
            renderer = this.getDefaultRenderer(this.getColumnClass(column));
        }
        return renderer;
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        TableColumn tableColumn = this.getColumnModel().getColumn(column);
        TableCellEditor editor = this.model.getColumn(tableColumn.getModelIndex()).getDefaultCellEditor();
        if (editor == null) {
            editor = this.getDefaultEditor(this.getColumnClass(column));
        }
        return editor;
    }

    final void setColumnDefaults() {
        int modelColumnIndex = 0;
        while (modelColumnIndex < this.model.getColumnCount()) {
            this.setColumnVisible(modelColumnIndex, false);
            ++modelColumnIndex;
        }
        modelColumnIndex = 0;
        while (modelColumnIndex < this.model.getColumnCount()) {
            AttributeTableModel.Column column = this.model.getColumn(modelColumnIndex);
            this.setColumnVisible(modelColumnIndex, column.isVisible());
            ++modelColumnIndex;
        }
    }

    public final void setColumnVisible(int modelColumnIndex, boolean visible) {
        TableColumnModel columnModel = this.getColumnModel();
        int viewColumnIndex = this.convertColumnIndexToView(modelColumnIndex);
        TableColumn column = null;
        if (viewColumnIndex != -1) {
            column = columnModel.getColumn(viewColumnIndex);
        }
        if (!visible) {
            if (column != null) {
                columnModel.removeColumn(column);
            }
        } else if (column == null) {
            column = this.allTableColumns.get(modelColumnIndex);
            this.addColumn(column);
            int closestBefore = Integer.MIN_VALUE;
            int closestAfter = Integer.MAX_VALUE;
            int i = 0;
            while (i < this.getColumnCount() - 1) {
                TableColumn tc = columnModel.getColumn(i);
                if (modelColumnIndex > tc.getModelIndex()) {
                    closestBefore = Math.max(closestBefore, tc.getModelIndex());
                }
                if (modelColumnIndex < tc.getModelIndex()) {
                    closestAfter = Math.min(closestAfter, tc.getModelIndex());
                }
                ++i;
            }
            int targetViewIndex = -1;
            targetViewIndex = closestBefore != Integer.MIN_VALUE ? this.convertColumnIndexToView(closestBefore) + 1 : this.convertColumnIndexToView(closestAfter);
            if (targetViewIndex != -1) {
                this.moveColumn(this.getColumnCount() - 1, targetViewIndex);
            }
        }
    }

    private void loadLayout() {
        while (this.columnModel.getColumnCount() > 0) {
            this.columnModel.removeColumn(this.columnModel.getColumn(0));
        }
        this.allTableColumns.clear();
        Map<String, String> properties = this.preferences != null ? this.preferences.getLayoutProperties() : null;
        ArrayList<TableColumn> tableColumns = new ArrayList<TableColumn>();
        int modelColumnIndex = 0;
        while (modelColumnIndex < this.model.getColumnCount()) {
            TableColumn tableColumn = new TableColumn(modelColumnIndex);
            AttributeTableModel.Column column = this.model.getColumn(modelColumnIndex);
            boolean visible = column.isVisible();
            int viewColumnIndex = Integer.MAX_VALUE;
            if (properties != null) {
                String columnKey = String.valueOf(this.prefix) + ".columns." + column.getAttribute().getName();
                String value = properties.get(String.valueOf(columnKey) + ".visible");
                int width = -1;
                if (value != null) {
                    visible = Boolean.parseBoolean(value) || column.isFixed();
                    try {
                        viewColumnIndex = Integer.parseInt(properties.get(String.valueOf(columnKey) + ".index"));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    try {
                        width = Integer.parseInt(properties.get(String.valueOf(columnKey) + ".width"));
                        if (width > 0) {
                            tableColumn.setPreferredWidth(width);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            if (visible) {
                tableColumn.setIdentifier(viewColumnIndex);
                tableColumns.add(tableColumn);
            }
            this.allTableColumns.add(tableColumn);
            ++modelColumnIndex;
        }
        Collections.sort(tableColumns, new Comparator<TableColumn>(){

            @Override
            public int compare(TableColumn o1, TableColumn o2) {
                Integer i1 = (Integer)o1.getIdentifier();
                Integer i2 = (Integer)o2.getIdentifier();
                return i1.compareTo(i2);
            }
        });
        for (TableColumn tableColumn : this.allTableColumns) {
            tableColumn.setIdentifier(this.model.getColumn(tableColumn.getModelIndex()).getAttribute().getName());
        }
        for (TableColumn tableColumn : tableColumns) {
            this.addColumn(tableColumn);
        }
    }

    public void saveLayout() {
        if (this.preferences == null) {
            throw new RuntimeException("This table has not preferences assigned.");
        }
        Map<String, String> properties = this.preferences.getLayoutProperties();
        ArrayList<String> keys = new ArrayList<String>(properties.keySet());
        for (String key : keys) {
            if (!key.startsWith(this.prefix)) continue;
            properties.remove(key);
        }
        int modelIndex = 0;
        while (modelIndex < this.model.getColumnCount()) {
            AttributeTableModel.Column column = this.model.getColumn(modelIndex);
            TableColumn tableColumn = this.allTableColumns.get(modelIndex);
            int viewIndex = this.convertColumnIndexToView(modelIndex);
            boolean visible = viewIndex != -1;
            String columnKey = String.valueOf(this.prefix) + ".columns." + column.getAttribute().getName();
            properties.put(String.valueOf(columnKey) + ".visible", Boolean.toString(visible));
            properties.put(String.valueOf(columnKey) + ".index", Integer.toString(viewIndex));
            properties.put(String.valueOf(columnKey) + ".width", Integer.toString(tableColumn.getWidth()));
            ++modelIndex;
        }
    }

    public void scrollToVisible(int rowIndex, int columnIndex) {
        Rectangle rect = this.getCellRect(rowIndex, columnIndex, true);
        this.scrollRectToVisible(rect);
    }

    public boolean print(String headerText, String subHeaderText, String footerText) throws PrinterException {
        if (headerText == null) {
            throw new IllegalArgumentException("Parameter 'headerText' must not be null.");
        }
        if (subHeaderText == null) {
            throw new IllegalArgumentException("Parameter 'subHeaderText' must not be null.");
        }
        if (footerText == null) {
            throw new IllegalArgumentException("Parameter 'footerText' must not be null.");
        }
        AttributeTablePrinter printer = new AttributeTablePrinter(this);
        return printer.print(headerText, subHeaderText, footerText);
    }
}

